/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.sigge.filerunner.view.tabs.TabContent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;

public class CaretStateUpdate {
    private final int lineNumber;
    private final int colNumber;
    private final int selectionLength;
    private final String newLineAtLine;
    private final String selection;
    private final int charNumber;
    private final int selectedLines;
    private final String tokenAtCursor;
    private final TabContent tabContent;

    private CaretStateUpdate(int lineNumber, int colNumber, int charNumber, int selectionLength, int selectedLines, String newLineAtLine, String selection, String tokenAtCursor, TabContent tc) {
        this.lineNumber = lineNumber;
        this.colNumber = colNumber;
        this.charNumber = charNumber;
        this.selectionLength = selectionLength;
        this.selectedLines = selectedLines;
        this.newLineAtLine = newLineAtLine;
        this.selection = selection;
        this.tokenAtCursor = tokenAtCursor;
        this.tabContent = tc;
    }

    public static CaretStateUpdate getFromTextArea(RSyntaxTextArea ra, TabContent tc) {
        int caretPos = ra.getCaretPosition();
        Document doc = ra.getDocument();
        Element map = doc.getDefaultRootElement();
        int lineNum = map.getElementIndex(caretPos);
        int markNum = map.getElementIndex(ra.getCaret().getMark());
        Element line = map.getElement(lineNum);
        int start = line.getStartOffset();
        int column = caretPos - start + 1;
        String selection = StringUtils.isBlank(ra.getSelectedText(), "");
        try {
            String allTheWay = doc.getText(start, caretPos - line.getStartOffset()).replaceAll("[\r\n]", "");
            int len = 0;
            int tabLength = ra.getTabSize();
            int i = 0;
            while (i < allTheWay.length()) {
                if (allTheWay.charAt(i) == '\t') {
                    if (tabLength > 0) {
                        len += tabLength - len % tabLength;
                    }
                } else {
                    ++len;
                }
                ++i;
            }
            column = len + 1;
        }
        catch (BadLocationException allTheWay) {
            // empty catch block
        }
        int selLen = Math.abs(ra.getSelectionEnd() - ra.getSelectionStart());
        String newLine = TextPaneUtil.getNewLineFromCurrentPosition((RTextArea)ra);
        String newLineExpanded = CaretStateUpdate.getExpandedNewLIne(newLine);
        String tokenAtCursor = CaretStateUpdate.tokenAtCursor(ra);
        return new CaretStateUpdate(lineNum + 1, column, caretPos + 1, selLen, Math.abs(lineNum - markNum) + 1, newLineExpanded, selection, tokenAtCursor, tc);
    }

    private static String getExpandedNewLIne(String newLine) {
        switch (newLine) {
            case "\n": {
                return "Linux: \\n";
            }
            case "\r": {
                return "Mac: \\r";
            }
            case "\r\n": {
                return "Windows \\r\\n";
            }
        }
        return "Unknown " + newLine.replace("\n", "\\n").replace("\r", "\\r");
    }

    private static String tokenAtCursor(RSyntaxTextArea rsta) {
        Token curToken = RSyntaxUtilities.getTokenAtOffset((RSyntaxTextArea)rsta, (int)rsta.getCaretPosition());
        if (curToken == null) {
            return "";
        }
        return curToken.getLexeme();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColNumber() {
        return this.colNumber;
    }

    public int getSelectionLength() {
        return this.selectionLength;
    }

    public String getNewLineAtLine() {
        return this.newLineAtLine;
    }

    public String getSelection() {
        return this.selection;
    }

    public int getCharNumber() {
        return this.charNumber;
    }

    public int getSelectedLines() {
        return this.selectedLines;
    }

    public String getTokenAtCursor() {
        return this.tokenAtCursor;
    }

    public TabContent getTabContent() {
        return this.tabContent;
    }

    public static interface CaretStateUpdateListener {
        public void caretStateUpdate(CaretStateUpdate var1);
    }
}

