/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.core;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.jdesktop.swingx.JXTableHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregatedMouseListener
implements MouseListener,
MouseMotionListener {
    private final List<MouseListener> listenerList = new ArrayList<MouseListener>();
    private final List<MouseMotionListener> motionListenerList = new ArrayList<MouseMotionListener>();
    private final Component c;
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregatedMouseListener.class);
    private volatile boolean unwrapped = false;

    public AggregatedMouseListener(Component c) {
        MouseListener[] listeners = this.checkAndUnwrap(c);
        int i = listeners.length - 1;
        while (i >= 0) {
            this.listenerList.add(listeners[i]);
            c.removeMouseListener(listeners[i]);
            --i;
        }
        MouseMotionListener[] ml = c.getMouseMotionListeners();
        int i2 = ml.length - 1;
        while (i2 >= 0) {
            this.motionListenerList.add(ml[i2]);
            c.removeMouseMotionListener(ml[i2]);
            --i2;
        }
        c.addMouseListener(this);
        c.addMouseMotionListener(this);
        this.c = c;
    }

    private MouseListener[] checkAndUnwrap(Component c) {
        MouseListener[] listeners;
        MouseListener[] mouseListenerArray = listeners = c.getMouseListeners();
        if (listeners.length != 0) {
            MouseListener ml = mouseListenerArray[0];
            if (ml instanceof AggregatedMouseListener) {
                ((AggregatedMouseListener)ml).unwrapListener();
            }
            return c.getMouseListeners();
        }
        return listeners;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.checkListeners();
        for (MouseListener l : this.listenerList) {
            if (e.isConsumed()) {
                return;
            }
            l.mouseClicked(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkListeners();
        for (MouseListener l : this.listenerList) {
            if (e.isConsumed()) {
                return;
            }
            l.mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkListeners();
        for (MouseListener l : this.listenerList) {
            if (e.isConsumed()) {
                return;
            }
            l.mouseReleased(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.checkListeners();
        for (MouseListener l : this.listenerList) {
            if (e.isConsumed()) {
                return;
            }
            try {
                l.mouseEntered(e);
            }
            catch (Exception ex) {
                LOGGER.error("Error occured when mouse entered component:" + this.c, (Throwable)ex);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.checkListeners();
        for (MouseListener l : this.listenerList) {
            if (e.isConsumed()) {
                return;
            }
            try {
                l.mouseExited(e);
            }
            catch (Exception ex) {
                LOGGER.error("Error occured when mouse entered component:" + this.c, (Throwable)ex);
            }
        }
    }

    public synchronized void unwrapListener() {
        if (this.unwrapped) {
            return;
        }
        this.unwrapped = true;
        this.c.removeMouseListener(this);
        this.c.removeMouseMotionListener(this);
        int i = this.listenerList.size() - 1;
        while (i >= 0) {
            this.c.addMouseListener(this.listenerList.get(i));
            --i;
        }
        i = this.motionListenerList.size() - 1;
        while (i >= 0) {
            this.c.addMouseMotionListener(this.motionListenerList.get(i));
            --i;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.checkListeners();
        for (MouseMotionListener l : this.motionListenerList) {
            if (e.isConsumed()) {
                return;
            }
            l.mouseDragged(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.checkListeners();
        for (MouseMotionListener l : this.motionListenerList) {
            if (e.isConsumed()) {
                return;
            }
            try {
                l.mouseMoved(e);
            }
            catch (Exception ex) {
                LOGGER.error("Error occured when mouse entered component:" + this.c, (Throwable)ex);
            }
        }
    }

    private void checkListeners() {
        EventListener m;
        int n;
        int n2;
        EventListener[] eventListenerArray;
        if (this.unwrapped || !(this.c instanceof JXTableHeader)) {
            return;
        }
        if (this.c.getMouseListeners().length > 1) {
            eventListenerArray = this.c.getMouseListeners();
            n2 = eventListenerArray.length;
            n = 0;
            while (n < n2) {
                m = eventListenerArray[n];
                if (!(m instanceof AggregatedMouseListener)) {
                    boolean listener = false;
                    int i = this.listenerList.size() - 1;
                    while (i >= 0) {
                        if (this.listenerList.get(i).getClass().isInstance(m)) {
                            this.listenerList.set(i, (MouseListener)m);
                            listener = true;
                            break;
                        }
                        --i;
                    }
                    if (!listener) {
                        this.listenerList.add((MouseListener)m);
                    }
                }
                ++n;
            }
        }
        if (this.c.getMouseMotionListeners().length > 1) {
            eventListenerArray = this.c.getMouseMotionListeners();
            n2 = eventListenerArray.length;
            n = 0;
            while (n < n2) {
                m = eventListenerArray[n];
                if (!(m instanceof AggregatedMouseListener)) {
                    int i = this.motionListenerList.size() - 1;
                    while (i >= 0) {
                        if (this.motionListenerList.get(i).getClass().isInstance(m)) {
                            this.motionListenerList.set(i, (MouseMotionListener)m);
                            break;
                        }
                        --i;
                    }
                }
                ++n;
            }
        }
    }
}

