/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.changedb;

import com.sigge.filerunner.core.HighlightingFilter;
import com.sigge.filerunner.sql.DatabaseFromConfig;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.core.DatabaseUtils;
import java.awt.Component;
import java.awt.Font;
import java.util.function.Supplier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class DatabaseListRenderer
implements ListCellRenderer<ServerDatabase> {
    protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private final Supplier<String> filterSupplier;
    private final Font deriveFont = new Font("Verdana", 0, 12);

    public DatabaseListRenderer(Supplier<String> filterSupplier) {
        this.filterSupplier = filterSupplier;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends ServerDatabase> list, ServerDatabase value, int index, boolean isSelected, boolean cellHasFocus) {
        this.defaultRenderer.putClientProperty("html", null);
        JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        renderer.setFont(this.deriveFont);
        if (value != null) {
            String server = value.getDb() == null ? "" : " <font color=blue>" + value.getDb().getLabel() + "</font>";
            String database = value.getDatabase();
            if (this.filterSupplier.get().length() > 0) {
                database = new HighlightingFilter(this.filterSupplier.get()).highlight(database);
            }
            renderer.setText("<html>&nbsp;" + DatabaseUtils.getColorBlob((DatabaseFromConfig)value.getDb()) + database + server + "</html>");
        }
        return renderer;
    }
}

