/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.changedb;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.core.FilterHelper;
import com.sigge.filerunner.sql.SQLManager;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.changedb.ChangeDatabaseModel;
import com.sigge.filerunner.view.changedb.ChangeDatabasePreviewer;
import com.sigge.filerunner.view.changedb.ChangeDatabaseView;
import com.sigge.filerunner.view.changedb.DatabaseListRenderer;
import com.sigge.filerunner.view.changedb.DbHolder;
import com.sigge.filerunner.view.core.JListUtils;
import com.sigge.filerunner.view.core.RowFilterExtension;
import com.siggemannen.binding.ADocumentAdapter;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.IView;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.sort.ListSortController;

@Singleton
public class ChangeDatabasePresenter
extends APresenter<DbHolder, ChangeDatabaseModel, ChangeDatabaseView> {
    private final SQLManager manager;
    private final RowFilterExtension<ServerDatabase> re = new RowFilterExtension<ServerDatabase>(50, this.dbCompare());
    private final ChangeDatabasePreviewer previewer;
    private final JFrame mainFrame;

    @Inject
    ChangeDatabasePresenter(ChangeDatabaseModel model, ChangeDatabaseView viewer, SQLManager manager, ChangeDatabasePreviewer previewer, @Named(value="mainFrame") JFrame mainFrame) {
        super((AModel)model, (IView)viewer);
        this.manager = manager;
        this.previewer = previewer;
        this.mainFrame = mainFrame;
    }

    protected void initBindings() {
        ((ChangeDatabaseView)this.view).filterText.getDocument().addDocumentListener((DocumentListener)new ADocumentAdapter(){

            protected void setValueFromDocument(DocumentEvent e) {
                ChangeDatabasePresenter.this.filterFromText();
            }
        });
        this.bind((JList)((ChangeDatabaseView)this.view).filterList).to(((ChangeDatabaseModel)this.model).objectsModel);
        ((ChangeDatabaseView)this.view).filterList.setSortable(true);
        ((ChangeDatabaseView)this.view).filterList.setCellRenderer((ListCellRenderer)new DatabaseListRenderer(((ChangeDatabaseView)this.view).filterText::getText));
        ((ChangeDatabaseView)this.view).okButton.addActionListener(a -> this.chooseSelectedDatabase());
        JListUtils.bindArrowsToFilter(((ChangeDatabaseView)this.view).filterText, (JComponent)((ChangeDatabaseView)this.view).filterList, this::chooseSelectedDatabase);
    }

    private void filterFromText() {
        String text = ((ChangeDatabaseView)this.view).filterText.getText();
        ServerDatabase sd = null;
        String regexFromString = FilterHelper.getRegexFromString2(text);
        if (this.getSelectedItem() != null && this.getSelectedItem().getDatabase().matches(regexFromString)) {
            sd = this.getSelectedItem();
        }
        this.re.filterOut(((List)((ChangeDatabaseModel)this.model).objects.getValue()).stream().filter(v -> v != null && v.getDb() != null && (text.length() == 0 || v.getDatabase().matches(regexFromString) || v.getDb().getServerLabel() != null && v.getDb().getServerLabel().matches(regexFromString))), sd);
        ((ChangeDatabaseView)this.view).filterList.setRowFilter(this.re);
        if (((ChangeDatabaseView)this.view).filterList.getSelectedValue() == null && ((ChangeDatabaseView)this.view).filterList.getRowSorter().getViewRowCount() > 0) {
            ((ChangeDatabaseView)this.view).filterList.setSelectedIndex(0);
        }
        ((ChangeDatabaseView)this.view).filterList.ensureIndexIsVisible(((ChangeDatabaseView)this.view).filterList.getSelectedIndex());
    }

    @VisibleForTesting
    void chooseSelectedDatabase() {
        if (((ChangeDatabaseView)this.view).filterList.getRowSorter().getViewRowCount() > 0) {
            ServerDatabase selectedItem = this.getSelectedItem();
            this.re.hit(selectedItem);
            if (this.previewer.preview(Arrays.asList(selectedItem))) {
                this.manager.setCurrent(selectedItem);
            }
        }
        ((ChangeDatabaseView)this.view).setVisible(false);
    }

    private ServerDatabase getSelectedItem() {
        return (ServerDatabase)((ChangeDatabaseModel)this.model).objectsModel.getSelectedItem();
    }

    protected void afterObjectSet() {
        ListSortController sorter = new ListSortController(((ChangeDatabaseModel)this.model).objectsModel);
        sorter.setComparator(0, this.re);
        ((ChangeDatabaseView)this.view).filterList.setRowSorter((RowSorter)sorter);
        sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        sorter.sort();
    }

    public void present() {
        ServerDatabase selectedItem = this.manager.getCurrent();
        this.re.filterOut(((List)((ChangeDatabaseModel)this.model).objects.getValue()).stream().filter(l -> l != null && l.getDb() != null), selectedItem);
        ((ChangeDatabaseView)this.view).filterList.setRowFilter(this.re);
        ((ChangeDatabaseModel)this.model).objectsModel.setSelectedItem((Object)selectedItem);
        ((ChangeDatabaseView)this.view).filterList.ensureIndexIsVisible(((ChangeDatabaseView)this.view).filterList.getSelectedIndex());
        ((ChangeDatabaseView)this.view).filterText.selectAll();
        ((ChangeDatabaseView)this.view).pack();
        ((ChangeDatabaseView)this.view).centerOnCorrectScreen(this.mainFrame);
        this.filterFromText();
        SwingUtilities.invokeLater(() -> {
            boolean bl = ((ChangeDatabaseView)this.view).filterText.requestFocusInWindow();
        });
        ((ChangeDatabaseView)this.view).setVisible(true);
    }

    private Comparator<ServerDatabase> dbCompare() {
        return Comparator.comparing(ServerDatabase::getDatabase, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(s -> Optional.of(s.getDb()).map(m -> m.getServer() != null ? m.getServer() : m.getUrl()).orElse(""), Comparator.nullsFirst(Comparator.naturalOrder()));
    }
}

