/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.activity;

import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.core.ProgressReportedAdaptor;
import com.sigge.filerunner.sql.ResultsetConsumer;
import com.sigge.filerunner.sql.ServerDatabase;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLRunner
implements Closeable {
    final SQLOptions defaultOptions = this.createDefaultOption();
    private final ServerDatabase db;
    private IScriptRunner runner;
    private boolean isRunning;
    protected boolean closed = false;
    protected final String query;
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    private SQLOptions createDefaultOption() {
        return new SQLOptions.Builder().parseOnly(false).rollbackAllUncommitedTransactions(true).timeout(240).build();
    }

    public SQLRunner(ServerDatabase db, String query) {
        this.db = db;
        this.query = query;
    }

    public void runQuery(ResultsetConsumer consumer, Consumer<Exception> onError) {
        this.runQuery(consumer, onError, this.defaultOptions);
    }

    public void runQuery(ResultsetConsumer consumer, Consumer<Exception> onError, SQLOptions options) {
        if (this.isRunning) {
            return;
        }
        try {
            this.runSQL(this.query, consumer, onError, options);
        }
        catch (Exception ex) {
            this.LOGGER.error("Error while executing query", (Throwable)ex);
            onError.accept(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.defaultOptions.cancel();
        if (this.runner != null) {
            this.runner.closeConnection();
        }
    }

    public synchronized void runSQL(String sql, final ResultsetConsumer resultConsumer, final Consumer<Exception> onError, SQLOptions so) throws SQLException, Exception {
        this.isRunning = true;
        if (this.runner == null || !this.runner.isAlive()) {
            this.runner = this.createRunner();
        }
        this.runner.runScript(new StringReader(sql), Arrays.asList(new ProgressReportedAdaptor(){
            int prevResults = 0;

            @Override
            public void reportScriptFailure(String command, Statement s, Exception e, boolean result) {
                if (!SQLRunner.this.closed) {
                    onError.accept(e);
                }
                SQLRunner.this.isRunning = false;
            }

            @Override
            public void reportScriptFinished(String command, Statement s, boolean result) {
                try {
                    try {
                        this.prevResults += SQLRunner.this.processStatement(s, resultConsumer, this.prevResults);
                    }
                    catch (Exception ex) {
                        if (!SQLRunner.this.closed) {
                            onError.accept(ex);
                        }
                        SQLRunner.this.isRunning = false;
                    }
                }
                finally {
                    SQLRunner.this.isRunning = false;
                }
            }
        }), so);
    }

    protected IScriptRunner createRunner() throws SQLException {
        return this.db.getDb().createRunner(this.db.getDatabase(), null);
    }

    protected int processStatement(Statement s, ResultsetConsumer resultConsumer, int prevResults) throws SQLException {
        int resultSets = 0;
        while (true) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (ResultSet r = s.getResultSet();){
                if (r == null) {
                    int updateCount = s.getUpdateCount();
                    if (updateCount == -1) break;
                    s.getMoreResults();
                    continue;
                }
                resultConsumer.consume(r, ++resultSets + prevResults);
                s.getMoreResults();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return resultSets;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

