/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.activity;

import com.google.gson.JsonArray;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.sigge.dbrunner.Database;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.sqlserver.queryplan.Node;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanBuilder;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanGraph;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanStatHandler;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanStats;
import com.sigge.filerunner.sql.sqlserver.queryplan.XmlParser;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.SpinnerCellEditor;
import com.sigge.filerunner.view.activity.Activity;
import com.sigge.filerunner.view.activity.ActivityHandler;
import com.sigge.filerunner.view.activity.ActivityProcess;
import com.sigge.filerunner.view.activity.ActivityTableModel;
import com.sigge.filerunner.view.activity.MonitorPanel;
import com.sigge.filerunner.view.activity.ServerMonitor;
import com.sigge.filerunner.view.activity.ServerMonitorTableModel;
import com.sigge.filerunner.view.core.ComponentUtils;
import com.sigge.filerunner.view.core.DatabaseUtils;
import com.sigge.filerunner.view.core.ITableSerializer;
import com.sigge.filerunner.view.core.VTable;
import com.sigge.filerunner.view.core.VTableCellRenderer;
import com.sigge.filerunner.view.results.QueryPlanPanel;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.siggemannen.backgroundrunner.AccumulatedBackgroundRunner;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.core.Tuple;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultRowSorter;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.jdesktop.swingx.VerticalLayout;
import org.oxbow.swingbits.table.filter.TableRowFilterSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityPresenter
implements Closeable {
    static final String VIEW_CONFIG_ACTIVITY_MONITOR_REFRESH_RATE = "viewConfig.ActivityMonitor.refreshRate";
    static final String VIEW_CONFIG_ACTIVITY_MONITOR_DECAY_RATE = "viewConfig.ActivityMonitor.decayhRate";
    static final String VIEW_CONFIG_ACTIVITY_MONITOR_DATABASES = "viewConfig.ActivityMonitor.databases";
    private final JPanel COMP_LEFT = new JPanel();
    private final JPanel COMP_RIGHT = new JPanel();
    private final List<Database> databases;
    private RSyntaxTextArea queryTextArea;
    private MonitorPanel monitoringPanel;
    private ActivityHandler handler;
    private Activity prev = null;
    private Action stopAction;
    private Action toggleQueryPlan;
    private final String ALL_DISABLED = "AD";
    private JFrame fr;
    private static Logger LOGGER = LoggerFactory.getLogger(ActivityPresenter.class);
    private AtomicLong ab = new AtomicLong(0L);
    private QueryPlanPanel lastPanel;
    private ITableSerializer serializer;

    public ActivityPresenter(List<Database> basadates, ITableSerializer serializer) {
        this.databases = basadates;
        this.serializer = serializer;
    }

    public void present(JFrame mainFrame, final MonitorPanel monitoringPanel) {
        this.monitoringPanel = monitoringPanel;
        ServerMonitorTableModel db = new ServerMonitorTableModel();
        db.setColumns(Arrays.asList("Monitor", "Server", "Refresh rate"));
        List<String> enabledDbs = ConfigHandler.getConfig().getListValues(VIEW_CONFIG_ACTIVITY_MONITOR_DATABASES);
        if (enabledDbs.size() == 0) {
            db.setRows(this.databases.stream().map(ServerMonitor::new).collect(Collectors.toList()));
        } else {
            String allDisabled = enabledDbs.get(0);
            if (allDisabled.equals("AD")) {
                db.setRows(this.databases.stream().map(ServerMonitor::new).map(e -> {
                    e.setMonitor(false);
                    return e;
                }).collect(Collectors.toList()));
            } else {
                db.setRows(this.databases.stream().map(d -> new ServerMonitor((Database)d, enabledDbs.contains(d.getUniqueProviderName()))).collect(Collectors.toList()));
            }
        }
        final VTable serverList = monitoringPanel.getServerList();
        serverList.setModel((TableModel)((Object)db));
        serverList.getColumn(0).setPreferredWidth(10);
        serverList.getColumn(1).setPreferredWidth(300);
        serverList.getColumn(2).setPreferredWidth(50);
        serverList.getColumn(2).setCellEditor(new SpinnerCellEditor(0, 0));
        VTableCellRenderer cellRenderer = new VTableCellRenderer(){

            @Override
            public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setBorder(BorderFactory.createEmptyBorder(8, 4, 8, 4));
                Database d = (Database)value;
                String server = StringUtils.isBlank(d.getServerLabel(), String.valueOf(d.getUser() != null ? String.valueOf(d.getUser()) + "@" : "") + d.getServer());
                String blob = DatabaseUtils.getColorBlob(d);
                if (blob != null && !blob.isEmpty()) {
                    server = "<html>" + blob + server + "</html>";
                }
                this.setText(server);
                return this;
            }
        };
        serverList.getColumn(1).setCellRenderer(cellRenderer);
        cellRenderer.putClientProperty("html.disable", Boolean.FALSE);
        serverList.getColumn(2).setCellRenderer(new VTableCellRenderer(){

            @Override
            public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Integer val = (Integer)value;
                if (val == null || val == 0) {
                    this.setText("Default rate");
                } else {
                    this.setText(val + " seconds");
                }
                return this;
            }
        });
        this.serializer.restoreSettings((JTable)((Object)serverList), "activityPresent.serverList");
        this.fr = new JFrame("Server activity");
        this.fr.setIconImages(Arrays.asList(IconUtils.getIcon("activity.png").getImage(), IconUtils.getSmallIcon("activity.png").getImage()));
        this.fr.setDefaultCloseOperation(0);
        this.fr.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ActivityPresenter.this.serializer.saveSettings((JTable)((Object)serverList), "activityPresent.serverList");
                ActivityPresenter.this.serializer.saveSettings((JTable)((Object)monitoringPanel.getProcessTable()), "activityPresent.processTable");
                try {
                    ActivityPresenter.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.fr.getContentPane().add(monitoringPanel);
        this.fr.pack();
        this.fr.setLocationRelativeTo(mainFrame == null ? new JFrame() : new JFrame(mainFrame.getGraphicsConfiguration()));
        final ActivityTableModel at = new ActivityTableModel();
        List<String> columns = Arrays.asList("Server", "Id", "Blocked by", "Text", "Database", "Object", "User", "Application", "Duration", "Completed%", "Reads", "Writes");
        at.setColumns(columns);
        final VTable processTable = monitoringPanel.getProcessTable();
        processTable.setModel((TableModel)((Object)at));
        RowSorter sorter = processTable.getRowSorter();
        if (sorter instanceof DefaultRowSorter) {
            DefaultRowSorter drs = (DefaultRowSorter)sorter;
            drs.setComparator(7, Comparator.naturalOrder());
        }
        int x = 0;
        while (x < processTable.getColumnCount()) {
            TableColumn tc = processTable.getColumn(x);
            final int counter = x;
            VTableCellRenderer processRenderer = new VTableCellRenderer(){

                @Override
                public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    ActivityProcess ap = (ActivityProcess)at.getValueAt(ActivityPresenter.convertRowIndexToModel((VTable)((Object)table), row));
                    if (ap != null) {
                        if (ap.isQuarantine()) {
                            if (!isSelected) {
                                this.setBackground(new Color(250, 255, 214));
                            }
                            this.setFont(this.getFont().deriveFont(2));
                        }
                        switch (counter) {
                            case 0: {
                                Database db = ap.getActivity().getServer();
                                String server = value != null ? value.toString().replaceAll("\\s+", " ") : "";
                                String blob = DatabaseUtils.getColorBlob(db);
                                if (blob != null && !blob.isEmpty()) {
                                    server = "<html>" + blob + server + "</html>";
                                }
                                this.setText(server);
                                return this;
                            }
                            case 8: {
                                Number durationMs = (Number)value;
                                if (durationMs == null) break;
                                this.setText(DateUtils.getDuration(durationMs.intValue()));
                                return this;
                            }
                        }
                    }
                    if (value instanceof String && ((String)value).length() > 100000) {
                        this.setText(((String)value).substring(0, 99997).replaceAll("\\s+", " "));
                    } else if (value != null) {
                        if (value instanceof Double) {
                            if ((Double)value % 1.0 == 0.0) {
                                this.setText(String.format("%.0f", value));
                            } else {
                                this.setText(BigDecimal.valueOf((Double)value).toPlainString());
                            }
                        }
                        this.setText(value.toString().replaceAll("\\s+", " "));
                    }
                    return this;
                }

                @Override
                public String getToolTipText() {
                    return null;
                }
            };
            if (x == 0) {
                processRenderer.putClientProperty("html.disable", Boolean.FALSE);
            }
            tc.setCellRenderer(processRenderer);
            ++x;
        }
        TableRowFilterSupport.forTable((JTable)((Object)monitoringPanel.processTable)).useTableRenderers(true).searchable(true).apply();
        this.serializer.restoreSettings((JTable)((Object)processTable), "activityPresent.processTable");
        int refreshRate = ConfigHandler.getConfig().getNumberConfigValue(VIEW_CONFIG_ACTIVITY_MONITOR_REFRESH_RATE, 1).intValue();
        SpinnerModel refreshRateModel = monitoringPanel.getRefreshRate().getModel();
        refreshRateModel.setValue(refreshRate);
        refreshRateModel.addChangeListener(l -> this.changeRate());
        int decay = ConfigHandler.getConfig().getNumberConfigValue(VIEW_CONFIG_ACTIVITY_MONITOR_DECAY_RATE, 10).intValue();
        SpinnerModel decayModel = monitoringPanel.getDecayRate().getModel();
        decayModel.setValue(decay);
        decayModel.addChangeListener(l -> this.changeDecay());
        this.handler = new ActivityHandler(at, db.getDataVector(), refreshRate * 1000, decay * 1000);
        this.queryTextArea = new RSyntaxTextArea();
        RTextScrollPane rs = new RTextScrollPane((RTextArea)this.queryTextArea);
        TextPaneUtil.configureSyntaxTextArea(this.queryTextArea);
        this.queryTextArea.setSyntaxEditingStyle("text/tsql");
        this.queryTextArea.setText("");
        this.queryTextArea.setCaretPosition(0);
        TextPaneUtil.configureSyntaxTextArea(this.queryTextArea);
        this.COMP_LEFT.setLayout(new BorderLayout());
        this.COMP_RIGHT.setLayout(new BorderLayout());
        this.COMP_LEFT.add((Component)rs, "Center");
        monitoringPanel.getDetailsPane().setLeftComponent(this.COMP_LEFT);
        monitoringPanel.getDetailsPane().setRightComponent(this.COMP_RIGHT);
        monitoringPanel.getDetailsPane().setDividerLocation(0.5);
        this.stopAction = new AbstractAction("Stop", IconUtils.getSmallIcon("stop.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] ixs = processTable.getSelectedRows();
                ArrayList<Activity> activities = new ArrayList<Activity>();
                int[] nArray = ixs;
                int n = ixs.length;
                int n2 = 0;
                while (n2 < n) {
                    ActivityProcess ax;
                    int ix = nArray[n2];
                    if (ix > -1 && (ax = (ActivityProcess)at.getValueAt(processTable.convertRowIndexToModel(ix))) != null && !ax.isQuarantine()) {
                        Activity activity = ax.getActivity();
                        activities.add(activity);
                    }
                    ++n2;
                }
                if (activities.size() == 0) {
                    return;
                }
                if (JOptionPane.showConfirmDialog(null, "Do you want to stop " + (activities.size() > 1 ? "processes" : "process") + " " + String.join((CharSequence)",", activities.stream().map(Activity::getId).collect(Collectors.toList())) + " @ server(s): " + String.join((CharSequence)",", activities.stream().map(Activity::getServer).distinct().map(Database::getLabel).collect(Collectors.toList())), "Confirm stopping", 2) == 0) {
                    ActivityPresenter.this.handler.stopActivity(activities.toArray(new Activity[0]));
                }
            }
        };
        this.stopAction.setEnabled(false);
        monitoringPanel.getStopProcess().setAction(this.stopAction);
        this.toggleQueryPlan = new AbstractAction("Query plan", IconUtils.getSmallIcon("up_down_question.png")){
            private boolean toggled;
            {
                this.toggled = true;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (this.toggled) {
                        ComponentUtils.unwrapPanelsFromASplitPane(ActivityPresenter.this.COMP_LEFT);
                    } else {
                        ComponentUtils.wrapPanelsIntoASplitPane(ActivityPresenter.this.COMP_LEFT, ActivityPresenter.this.COMP_RIGHT, "qp", false, false);
                        ActivityPresenter.this.prev = null;
                        ActivityPresenter.this.processRowChanged("toggleQueryPlan");
                    }
                }
                catch (Throwable throwable) {
                    this.toggled = !this.toggled;
                    throw throwable;
                }
                this.toggled = !this.toggled;
            }
        };
        this.toggleQueryPlan.putValue("SwingSelectedKey", true);
        monitoringPanel.getQueryPlanToggle().setAction(this.toggleQueryPlan);
        processTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.processRowChanged("addListSelectionListener");
            }
        });
        processTable.getModel().addTableModelListener(e -> {
            int minRow = Math.min(e.getFirstRow(), e.getLastRow());
            int maxRow = Math.max(e.getFirstRow(), e.getLastRow());
            int selectedRow = processTable.getSelectedRow();
            if (minRow > selectedRow) {
                return;
            }
            if (e.getType() < 1 && maxRow < selectedRow) {
                return;
            }
            if (selectedRow == minRow && selectedRow == maxRow && this.getFromType(e.getType()).equals("DELETE")) {
                return;
            }
            this.processRowChanged("addTableModelListener");
        });
        db.addTableModelListener(e -> this.refreshServers(db));
        AccumulatedBackgroundRunner.schedule((String)"AD", null, (int)decay, (TimeUnit)TimeUnit.MILLISECONDS);
        this.fr.setVisible(true);
    }

    private String getFromType(int type) {
        switch (type) {
            case -1: {
                return "DELETE";
            }
            case 0: {
                return "UPDATE";
            }
            case 1: {
                return "INSERT";
            }
        }
        return "UNKNOWN";
    }

    private static Integer convertRowIndexToModel(VTable table, int i) {
        return table.getRowSorter() == null ? i : table.getRowSorter().convertRowIndexToModel(i);
    }

    private void saveNewValue(String config, int value) {
        ConfigHandler.getConfig().setConfigValue(config, value);
    }

    private void changeRate() {
        int newRate = (Integer)this.monitoringPanel.getRefreshRate().getModel().getValue();
        this.saveNewValue(VIEW_CONFIG_ACTIVITY_MONITOR_REFRESH_RATE, newRate);
        this.handler.setDefaultRate(newRate * 1000);
    }

    private void changeDecay() {
        int newRate = (Integer)this.monitoringPanel.getDecayRate().getModel().getValue();
        this.saveNewValue(VIEW_CONFIG_ACTIVITY_MONITOR_DECAY_RATE, newRate);
        this.handler.changeDecayRate(newRate * 1000);
    }

    private void cleanUpPanel() {
        QueryPlanGraph qg;
        if (this.lastPanel != null && (qg = this.lastPanel.getGraph()) != null) {
            try {
                qg.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void processRowChanged(String source) {
        int row = this.monitoringPanel.getProcessTable().getSelectedRow();
        if (row == -1) {
            this.stopAction.setEnabled(false);
        }
        if (row > -1) {
            row = ActivityPresenter.convertRowIndexToModel(this.monitoringPanel.getProcessTable(), row);
            try {
                ActivityProcess acp = null;
                if (row < this.monitoringPanel.getProcessTable().getModel().getRowCount()) {
                    acp = (ActivityProcess)((ActivityTableModel)((Object)this.monitoringPanel.getProcessTable().getModel())).getValueAt(row);
                }
                this.stopAction.setEnabled(acp != null && !acp.isQuarantine());
                if (acp == null) {
                    this.queryTextArea.setText("");
                    this.queryTextArea.discardAllEdits();
                    this.queryTextArea.setCaretPosition(0);
                    this.COMP_RIGHT.removeAll();
                    this.ab.incrementAndGet();
                    this.cleanUpPanel();
                } else if (!(this.prev != null && this.prev.isContinuationOf(acp.getActivity()) && this.prev.getQuery().equals(acp.getActivity().getQuery()) && this.prev.getExtraFields().equals(acp.getActivity().getExtraFields()))) {
                    long counter = this.ab.incrementAndGet();
                    Activity ac = acp.getActivity();
                    String currentText = this.queryTextArea.getText();
                    if (!currentText.equals(ac.getQuery())) {
                        this.queryTextArea.setText(ac.getQuery());
                        this.queryTextArea.discardAllEdits();
                        this.queryTextArea.setCaretPosition(0);
                        this.COMP_RIGHT.removeAll();
                        this.cleanUpPanel();
                        this.lastPanel = null;
                        if (this.COMP_LEFT.getParent() instanceof JSplitPane) {
                            JSplitPane jp = (JSplitPane)this.COMP_LEFT.getParent();
                            jp.setDividerLocation(jp.getDividerLocation());
                        }
                    }
                    if (((Boolean)this.toggleQueryPlan.getValue("SwingSelectedKey")).booleanValue()) {
                        Object ox = ac.getQueryPlan();
                        if (ox != null && ox instanceof String) {
                            if (this.lastPanel != null && ac.getExtraFields().size() > 0 && currentText.equals(ac.getQuery()) && (this.prev == null || ac.isSameQueryForQueryPlan(this.prev))) {
                                String xmlStats = (String)ac.getExtraFields().get("PROGRESS_XML");
                                ArrayList<QueryPlanStats> qps = new ArrayList<QueryPlanStats>();
                                if (xmlStats != null) {
                                    for (Node nx : new XmlParser().parse(xmlStats, "progress").getNodes()) {
                                        qps.add(new QueryPlanStats(nx));
                                    }
                                }
                                QueryPlanStatHandler handler = new QueryPlanStatHandler(qps);
                                mxGraphModel model = (mxGraphModel)this.lastPanel.getGraph().getModel();
                                for (QueryPlanStats q : qps) {
                                    mxCell xcell;
                                    Object cell = model.getCell("NodeId" + q.getNodeId());
                                    if (!(cell instanceof mxCell) || !((xcell = (mxCell)cell).getValue() instanceof Tuple)) continue;
                                    Tuple nodeTuple = (Tuple)xcell.getValue();
                                    String statsFromId = handler.getStatsFromId(q.getNodeId());
                                    if (Objects.equals(statsFromId, ((QueryPlanBuilder.NodeItem)nodeTuple.second()).getExtra())) continue;
                                    ((QueryPlanBuilder.NodeItem)nodeTuple.second()).setExtra(statsFromId);
                                    this.lastPanel.getGraph().cellLabelChanged(xcell, xcell.getValue(), true);
                                }
                                return;
                            }
                            new BackgroundRunner(() -> {
                                List<QueryPlanPanel> res = new QueryPlanBuilder().buildGraph((String)ox, false, ac.getExtraFields());
                                JScrollPane js = new JScrollPane();
                                JPanel jp = new JPanel();
                                jp.setLayout((LayoutManager)new VerticalLayout(0));
                                js.setViewportView(jp);
                                if (this.ab.get() != counter) {
                                    return;
                                }
                                SwingUtilities.invokeLater(() -> {
                                    this.COMP_RIGHT.removeAll();
                                    this.COMP_RIGHT.add((Component)js, "Center");
                                    this.cleanUpPanel();
                                    for (QueryPlanPanel p : res) {
                                        p.setName("activityPresenter");
                                        jp.add(p);
                                    }
                                    this.lastPanel = res.size() == 1 ? (QueryPlanPanel)res.get(0) : null;
                                    if (this.COMP_LEFT.getParent() instanceof JSplitPane) {
                                        JSplitPane jpx = (JSplitPane)this.COMP_LEFT.getParent();
                                        jpx.setDividerLocation(jpx.getDividerLocation());
                                    }
                                });
                            }).execute();
                        } else {
                            SwingUtilities.invokeLater(() -> {
                                this.COMP_RIGHT.removeAll();
                                this.cleanUpPanel();
                                this.lastPanel = null;
                                if (this.COMP_LEFT.getParent() instanceof JSplitPane) {
                                    JSplitPane jpx = (JSplitPane)this.COMP_LEFT.getParent();
                                    jpx.setDividerLocation(jpx.getDividerLocation());
                                }
                            });
                        }
                    }
                    this.prev = ac;
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error while refreshing row", (Throwable)ex);
            }
        }
    }

    private void refreshServers(ServerMonitorTableModel db) {
        List dataVector = db.getDataVector();
        JsonArray arr = new JsonArray();
        dataVector.stream().filter(ServerMonitor::isMonitor).forEach(sm -> arr.add(sm.getServer().getUniqueProviderName()));
        if (arr.size() == 0) {
            arr.add("AD");
        }
        ConfigHandler.getConfig().setConfigValue(VIEW_CONFIG_ACTIVITY_MONITOR_DATABASES, arr);
        ConfigHandler.saveInBackground();
        this.handler.setMonitorServers(dataVector);
    }

    @Override
    public void close() throws IOException {
        try {
            this.handler.close();
        }
        finally {
            this.fr.dispose();
            this.cleanUpPanel();
            this.fr = null;
            this.handler = null;
        }
    }
}

