/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.activity;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.view.activity.Activity;
import com.sigge.filerunner.view.activity.ActivityProcess;
import com.sigge.filerunner.view.activity.ActivityTableModel;
import com.sigge.filerunner.view.activity.IRunner;
import com.sigge.filerunner.view.activity.Runners;
import com.sigge.filerunner.view.activity.ServerMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;

public class ActivityHandler
implements Closeable {
    private final ActivityTableModel model;
    private int pollTime;
    private int effectivePollTime;
    private int decayTime;
    private final List<Monitorer> monitorers = new ArrayList<Monitorer>();
    private final ScheduledExecutorService sXs = Executors.newSingleThreadScheduledExecutor();
    private final ExecutorService ex = Executors.newWorkStealingPool();
    private ScheduledFuture future;
    private ScheduledFuture futureX;
    private long executionTime;

    ActivityHandler(ActivityTableModel model, List<ServerMonitor> list, int pollTime, int decayTime) {
        this.model = model;
        this.pollTime = pollTime;
        this.effectivePollTime = pollTime;
        this.decayTime = decayTime;
        this.setMonitorServers(list);
        this.reschedule();
    }

    public void setMonitorServers(List<ServerMonitor> dbs) {
        for (ServerMonitor mon : dbs) {
            ServerMonitor newServer = new ServerMonitor(mon.getServer());
            if (mon.getRefreshRate() != null) {
                newServer.setRefreshRate(mon.getRefreshRate() * 1000);
            }
            newServer.setMonitor(mon.isMonitor());
            Optional<Monitorer> s = this.monitorers.stream().filter(monitor -> ((Monitorer)monitor).server.getServer().equals(newServer.getServer())).findFirst();
            if (s.isPresent()) {
                Monitorer m = s.get();
                if (m.server.isMonitor() && !newServer.isMonitor()) {
                    this.updateDb(mon.getServer(), Collections.EMPTY_LIST);
                }
                m.server = newServer;
                continue;
            }
            Runners.getFromProvider(mon.getServer().getDatabaseProvider()).ifPresent(p -> {
                boolean bl = this.monitorers.add(new Monitorer(newServer, p.supplier.apply(mon.getServer())));
            });
        }
    }

    public void stopActivity(Activity ... acs) {
        Activity[] activityArray = acs;
        int n = acs.length;
        int n2 = 0;
        while (n2 < n) {
            Activity ac = activityArray[n2];
            for (Monitorer m : this.monitorers) {
                if (!m.server.getServer().equals(ac.getServer())) continue;
                m.runner.stopActivity(ac);
                break;
            }
            ++n2;
        }
    }

    private void reschedule() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        if (this.futureX != null) {
            this.futureX.cancel(false);
        }
        ++this.executionTime;
        if (this.executionTime % 1000L == 0L) {
            System.gc();
        }
        this.effectivePollTime = this.getEffectivePollTime();
        this.future = this.sXs.scheduleWithFixedDelay(this::update, 0L, this.effectivePollTime, TimeUnit.MILLISECONDS);
        this.futureX = this.sXs.scheduleWithFixedDelay(this::checkDecay, 0L, this.decayTime / 4, TimeUnit.MILLISECONDS);
    }

    private int getEffectivePollTime() {
        int minValue = Integer.MAX_VALUE;
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (Monitorer mon : this.monitorers) {
            ServerMonitor monitor = mon.server;
            int val = monitor.getRefreshRate() != null && monitor.getRefreshRate() > 0 ? monitor.getRefreshRate() : this.pollTime;
            if ((val = val / 100 * 100) == 0) continue;
            minValue = Math.min(minValue, val);
            values.add(val);
        }
        if (minValue == Integer.MAX_VALUE) {
            return this.pollTime;
        }
        if (minValue <= 500) {
            return 500;
        }
        int gcd = 0;
        int i = minValue / 100;
        while (i > 0) {
            boolean allGood = true;
            for (Integer ix : values) {
                if (ix % (i * 100) == 0) continue;
                allGood = false;
                break;
            }
            if (allGood) {
                gcd = i * 100;
                break;
            }
            --i;
        }
        return gcd > 0 ? gcd : 1000;
    }

    private void update() {
        for (Monitorer mon : this.monitorers) {
            if (!mon.fireTime(this.pollTime)) continue;
            IRunner r = mon.runner;
            this.ex.execute(() -> r.getActivities(x -> SwingUtilities.invokeLater(() -> this.updateDb(r.getDatabase(), (List<Activity>)x))));
        }
    }

    private void checkDecay() {
        if (this.model.getRowCount() == 0) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            int i = this.model.getRowCount() - 1;
            while (i >= 0) {
                LocalDateTime time;
                ActivityProcess acp = (ActivityProcess)this.model.getValueAt(i);
                if (acp.isQuarantine() && (time = acp.quarantineTime()) != null && DateUtils.isOlderThan(time, this.decayTime)) {
                    this.model.removeRow(i);
                }
                --i;
            }
        });
    }

    private void updateDb(Database d, List<Activity> activities) {
        int i = this.model.getRowCount() - 1;
        while (i >= 0) {
            ActivityProcess acp = (ActivityProcess)this.model.getValueAt(i);
            Activity ac = acp.getActivity();
            if (ac.getServer().equals(d)) {
                boolean changed = false;
                int j = activities.size() - 1;
                while (j >= 0) {
                    Activity acx = activities.get(j);
                    if (acx.isContinuationOf(ac)) {
                        activities.remove(j);
                        acp.update(acx);
                        this.model.replaceRow(i, acp);
                        changed = true;
                        break;
                    }
                    --j;
                }
                if (!changed && !acp.isQuarantine()) {
                    acp.quarantine();
                    this.model.replaceRow(i, acp);
                }
            }
            --i;
        }
        this.model.insertRows(activities.stream().map(ActivityProcess::new).collect(Collectors.toList()));
    }

    public void setDefaultRate(int i) {
        this.pollTime = i;
        this.reschedule();
    }

    @Override
    public void close() {
        for (Monitorer mon : this.monitorers) {
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try {
                    IRunner r = mon.runner;
                    if (r == null) continue;
                    r.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.ex.shutdownNow();
        this.sXs.shutdownNow();
        this.future = null;
        this.futureX = null;
    }

    public void changeDecayRate(int i) {
        this.decayTime = i;
        this.reschedule();
    }

    private class Monitorer {
        private ServerMonitor server;
        private LocalDateTime lastCheck;
        private final IRunner runner;

        Monitorer(ServerMonitor server, IRunner runner) {
            this.server = server;
            this.runner = runner;
        }

        boolean fireTime(int effectivePollTime) {
            int pollTime;
            if (!this.server.isMonitor()) {
                return false;
            }
            if (this.lastCheck == null) {
                this.lastCheck = DateUtils.getTimeAtUTC();
                return true;
            }
            int n = pollTime = this.server.getRefreshRate() != null && this.server.getRefreshRate() > 0 ? this.server.getRefreshRate() : effectivePollTime;
            if (DateUtils.isOlderThan(this.lastCheck, pollTime - 200)) {
                this.lastCheck = DateUtils.getTimeAtUTC();
                return true;
            }
            return false;
        }
    }
}

