/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.activity;

import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.core.ProgressReportedAdaptor;
import com.sigge.filerunner.sql.ResultsetConsumer;
import com.sigge.filerunner.view.activity.Activity;
import com.sigge.filerunner.view.activity.ActivityHandler;
import com.sigge.filerunner.view.activity.IRunner;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ARunner
implements IRunner {
    final SQLOptions defaultOptions = new SQLOptions.Builder().parseOnly(false).rollbackAllUncommitedTransactions(true).timeout(240).build();
    protected Database db;
    IScriptRunner runner;
    IScriptRunner stopRunner;
    private boolean isRunning;
    protected boolean closed = false;
    protected final String query = this.readQueryString(this.getFileNameWithQueryForActivity());
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public ARunner(Database db) {
        this.db = db;
    }

    @Override
    public Database getDatabase() {
        return this.db;
    }

    private String readQueryString(String string) {
        try {
            return FileUtils.streamContents(ActivityHandler.class.getResourceAsStream(string), "UTF8");
        }
        catch (Exception e) {
            this.LOGGER.error("Error while loading:" + string, (Throwable)e);
            return "";
        }
    }

    @Override
    public void getActivities(Consumer<List<Activity>> consumer) {
        if (this.isRunning) {
            return;
        }
        try {
            this.runSQL(this.query, (rs, result) -> consumer.accept(this.getActivities(rs, result)), this.defaultOptions);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected abstract List<Activity> getActivities(ResultSet var1, int var2) throws SQLException;

    protected abstract String getFileNameWithQueryForActivity();

    @Override
    public void close() {
        this.closed = true;
        this.defaultOptions.cancel();
        if (this.runner != null) {
            this.runner.closeConnection();
        }
    }

    public synchronized void runSQL(String sql, final ResultsetConsumer resultConsumer, SQLOptions so) throws SQLException, Exception {
        this.isRunning = true;
        if (this.runner == null || !this.runner.isAlive()) {
            this.runner = this.createRunner();
        }
        this.runner.runScript(new StringReader(sql), Arrays.asList(new ProgressReportedAdaptor(){
            int prevResults = 0;

            @Override
            public void reportScriptFailure(String command, Statement s, Exception e, boolean result) {
                if (!ARunner.this.closed) {
                    ARunner.this.LOGGER.error("Running script {} failed with {}", (Object)command, (Object)e);
                }
                ARunner.this.isRunning = false;
            }

            @Override
            public void reportScriptFinished(String command, Statement s, boolean result) {
                try {
                    try {
                        this.prevResults += ARunner.this.processStatement(s, resultConsumer, this.prevResults);
                    }
                    catch (Exception ex) {
                        if (!ARunner.this.closed) {
                            ARunner.this.LOGGER.error("Processing statement from command {} failed with exception {}", (Object)command, (Object)ex);
                        }
                        ARunner.this.isRunning = false;
                    }
                }
                finally {
                    ARunner.this.isRunning = false;
                }
            }
        }), so);
    }

    protected IScriptRunner createRunner() throws SQLException {
        return this.db.createRunner("", null);
    }

    protected int processStatement(Statement s, ResultsetConsumer resultConsumer, int prevResults) throws SQLException {
        int resultSets = 0;
        while (true) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (ResultSet r = s.getResultSet();){
                if (r == null) {
                    int updateCount = s.getUpdateCount();
                    if (updateCount == -1) break;
                    s.getMoreResults();
                    continue;
                }
                resultConsumer.consume(r, ++resultSets + prevResults);
                s.getMoreResults();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return resultSets;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    @Override
    public synchronized void stopActivity(Activity activity) {
        try {
            if (this.stopRunner == null || !this.stopRunner.isAlive()) {
                this.stopRunner = this.createRunner();
            }
            this.stopRunner.runScript(new StringReader(this.getKillQueryForActivity(activity)), Arrays.asList(new ProgressReportedAdaptor()), new SQLOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error occured while stopping task: " + activity.getId() + ": " + e.getMessage());
        }
    }

    protected abstract String getKillQueryForActivity(Activity var1);
}

