/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.DatabaseServerConfig;
import com.sigge.dbrunner.IProgressReporter;
import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.dbrunner.SQLPlanType;
import com.sigge.filerunner.action.ActionUtils;
import com.sigge.filerunner.commands.EditorCommands;
import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.ButtonUtils;
import com.sigge.filerunner.core.CardHolder;
import com.sigge.filerunner.core.CardHolderChangeTracker;
import com.sigge.filerunner.core.FileRunnerProgressReporter;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.core.InstanceActivationHandler;
import com.sigge.filerunner.core.ProgressReportedAdaptor;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.core.ValueHolder;
import com.sigge.filerunner.export.ExportAction;
import com.sigge.filerunner.imports.core.FileImporter;
import com.sigge.filerunner.imports.core.ImportResult;
import com.sigge.filerunner.imports.geopackage.GeoPackageImporter;
import com.sigge.filerunner.imports.grib.GribImporter;
import com.sigge.filerunner.imports.raw.RawImporter;
import com.sigge.filerunner.sql.DatabaseFromConfig;
import com.sigge.filerunner.sql.DatabaseManager;
import com.sigge.filerunner.sql.IOutput;
import com.sigge.filerunner.sql.ISQLManager;
import com.sigge.filerunner.sql.OutputBuilder;
import com.sigge.filerunner.sql.OutputFormat;
import com.sigge.filerunner.sql.RunContext;
import com.sigge.filerunner.sql.RunFilesInDBs;
import com.sigge.filerunner.sql.SQLManager;
import com.sigge.filerunner.sql.Server;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.BrowseForScriptsController;
import com.sigge.filerunner.view.ColorUtils;
import com.sigge.filerunner.view.DatabaseTreeLabelProvider;
import com.sigge.filerunner.view.FileToRun;
import com.sigge.filerunner.view.IEditorManager;
import com.sigge.filerunner.view.IQueryActionHolder;
import com.sigge.filerunner.view.IStatusUpdater;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.MainPanel;
import com.sigge.filerunner.view.RunMode;
import com.sigge.filerunner.view.Runner;
import com.sigge.filerunner.view.RunnerModel;
import com.sigge.filerunner.view.RunnerView;
import com.sigge.filerunner.view.RunningTabContent;
import com.sigge.filerunner.view.changedb.ChangeDatabaseListener;
import com.sigge.filerunner.view.changedb.ChangeDatabaseModel;
import com.sigge.filerunner.view.changedb.ChangeDatabasePresenter;
import com.sigge.filerunner.view.changedb.ChangeDatabasePreviewer;
import com.sigge.filerunner.view.changedb.DatabaseComboboxConfigurer;
import com.sigge.filerunner.view.changedb.DbHolder;
import com.sigge.filerunner.view.core.IWindowListener;
import com.sigge.filerunner.view.core.IWindowState;
import com.sigge.filerunner.view.core.JCheckBoxTree;
import com.sigge.filerunner.view.core.JListUtils;
import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.sigge.filerunner.view.core.VTableColumnFactory;
import com.sigge.filerunner.view.core.WideDropDownComboBox;
import com.sigge.filerunner.view.database.AddDatabaseAction;
import com.sigge.filerunner.view.database.RunnerServerConfig;
import com.sigge.filerunner.view.editors.TabContentFilter;
import com.sigge.filerunner.view.editors.TableEditor;
import com.sigge.filerunner.view.results.export.ExportDialog;
import com.sigge.filerunner.view.results.export.scripter.IScriptOutputPresenter;
import com.sigge.filerunner.view.runners.IRunningState;
import com.sigge.filerunner.view.runners.RecurringRunState;
import com.sigge.filerunner.view.runners.SQLScriptState;
import com.sigge.filerunner.view.tabs.ITabEditor;
import com.sigge.filerunner.view.tabs.TabContent;
import com.sigge.filerunner.view.tabs.TabContentEditorListener;
import com.sigge.filerunner.view.tabs.TabListener;
import com.sigge.filerunner.view.tabs.TabRendererSupplier;
import com.sigge.filerunner.view.tools.SQLTool;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.binding.ADocumentAdapter;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.Binder;
import com.siggemannen.binding.IListProperty;
import com.siggemannen.binding.IView;
import com.siggemannen.core.MapBuilder;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import com.siggemannen.functional.throwing.ThrowingSupplier;
import com.siggemannen.view.UIBackgroundRunner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.StringReader;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.sort.ListSortController;
import org.jdesktop.swingx.table.ColumnFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RunnerPresenter
extends APresenter<Runner, RunnerModel, RunnerView>
implements TabListener,
ChangeDatabaseListener,
ChangeDatabasePreviewer,
IWindowListener,
ISQLManager,
TabContentEditorListener,
IQueryActionHolder {
    public static final String STATE_KEY_FOR_CURRENT_DB = "db";
    public static final String STATE_KEY_FOR_CURRENT_DB_STRING = "db_string";
    private final JFrame mainFrame;
    @Inject
    IEditorManager editorManager;
    final ChangeDatabasePresenter cdb;
    private JButton validateButton;
    private Action executeSQLAction;
    @Inject
    SQLManager sqlManager;
    @Inject
    private EditorCommands.ChangeDatabaseAction changeDbAction;
    @Inject
    private IRunningState scriptReporter;
    @Inject
    private TableEditor editor;
    private final DatabaseManager dbm;
    private static final ScheduledExecutorService NEW_SINGLE_THREAD_SCHEDULED_EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private final CardHolder<TabContent> holder;
    private JToggleButton qPlanButton;
    private final IWindowState stateListener;
    private final ImageIcon executeSingleIcon = IconUtils.getSmallIcon("flash.png");
    private final ImageIcon executeMultipleIcon = IconUtils.getSmallIcon("multiflash.png");
    private static final Logger LOGGER = LoggerFactory.getLogger(RunnerPresenter.class);
    private Action recurringActionDropDown;
    private Action estimatedQueryPlan;
    private final IStatusUpdater status;
    private boolean ready = false;
    private final Set<ExportAction> actions;
    @Inject
    private IScriptOutputPresenter outputPresenter;

    @Inject
    public RunnerPresenter(RunnerModel model, RunnerView view, @Named(value="mainFrame") JFrame mainFrame, ChangeDatabasePresenter presenter, DatabaseManager dbm, CardHolder<TabContent> holder, IWindowState stateListener, IStatusUpdater status, Set<ExportAction> actions) {
        super((AModel)model, (IView)view);
        this.actions = actions;
        LOGGER.debug("Create runner presenter");
        this.dbm = dbm;
        this.holder = holder;
        this.mainFrame = mainFrame;
        this.cdb = presenter;
        this.stateListener = stateListener;
        this.status = status;
    }

    protected void initBindings() {
        this.sqlManager.addChangeDatabaseListener(this);
        this.editorManager.addContentEditorListener(this);
        ((RunnerView)this.view).getPanel().statusBar.setBorder(BorderFactory.createEmptyBorder());
        this.bind(((RunnerView)this.view).browseFolder).to(((RunnerModel)this.model).defaultPath);
        MainPanel panel = ((RunnerView)this.view).getPanel();
        panel.clearButton.addActionListener(l -> ((RunnerModel)this.model).scriptTableModel.setData(Arrays.asList(new FileToRun[0])));
        panel.browseButton.addActionListener(new BrowseForScriptsController((RunnerModel)this.model, (Component)((Object)panel), true));
        panel.addDirButton.addActionListener(new BrowseForScriptsController((RunnerModel)this.model, (Component)((Object)panel), false));
        this.mainFrame.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                if (!evt.getTransferable().isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    return;
                }
                try {
                    evt.acceptDrop(1);
                    List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    RunnerPresenter.this.openFiles(droppedFiles, false);
                }
                catch (Exception ex) {
                    LOGGER.error("Drop failed", (Throwable)ex);
                }
            }
        });
        DatabaseComboboxConfigurer.configureDatabaseCombo(panel.databaseCombobox, this::selectDbFromCombo);
        JCheckBoxTree checkBoxTree = panel.getCheckBoxTree();
        checkBoxTree.addCheckChangeEventListener(l -> {
            List<ServerDatabase> db = this.getSelectedDatabases(checkBoxTree.getCheckedPaths());
            if (!db.isEmpty()) {
                if (this.preview(db)) {
                    this.sqlManager.setCurrent(db);
                } else {
                    this.findAndSelectDatabaseNode(this.sqlManager.getCurrents());
                }
            }
        });
        checkBoxTree.setTreeRenderer(new DatabaseTreeLabelProvider());
        panel.reloadDBButton.addActionListener(l -> {
            this.sqlManager.reloadDbs();
            this.reloadDBs(true);
        });
        panel.addDBButton.setIcon(IconUtils.getSmallIcon("data_add.png"));
        panel.reloadDBButton.setIcon(IconUtils.getSmallIcon("data_refresh.png"));
        panel.addDBButton.addActionListener(new AddDatabaseAction(this.mainFrame, (RunnerModel)this.model, this.dbm, () -> {
            this.sqlManager.reloadDbs();
            this.reloadDBs(true);
        }, this.sqlManager));
        String key = "Execute  ";
        this.executeSQLAction = new AbstractAction(key, this.executeSingleIcon){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RunnerPresenter.this.execute(false);
            }

            public String toString() {
                return "EXECUTEACTION";
            }
        };
        panel.executeScriptButton.setAction(this.executeSQLAction);
        panel.executeScriptButton.getInputMap(2).put(KeyStroke.getKeyStroke(116, 0), key);
        panel.executeScriptButton.getInputMap(2).put(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), key);
        panel.executeScriptButton.getActionMap().put(key, this.executeSQLAction);
        JButton executeExtra = new JButton();
        executeExtra.setHorizontalTextPosition(4);
        executeExtra.setFocusable(false);
        this.recurringActionDropDown = ActionUtils.createAction("", "arrow_down_menu.png", true, () -> {
            JPopupMenu pp = new JPopupMenu("Recurring SQL run");
            pp.add(new JMenuItem(ActionUtils.createAction("Run every second", this.recurringFactory(1000L))));
            pp.add(new JMenuItem(ActionUtils.createAction("Run every 2 seconds", this.recurringFactory(2000L))));
            pp.add(new JMenuItem(ActionUtils.createAction("Each 5 seconds", this.recurringFactory(5000L))));
            pp.add(new JMenuItem(ActionUtils.createAction("Each 30 seconds", this.recurringFactory(30000L))));
            pp.addSeparator();
            pp.add(new JMenuItem(ActionUtils.createAction("Each 1 minute", this.recurringFactory(60000L))));
            pp.add(new JMenuItem(ActionUtils.createAction("Each 5 minute", this.recurringFactory(300000L))));
            pp.add(new JMenuItem(ActionUtils.createAction("Each 15 minute", this.recurringFactory(900000L))));
            pp.addSeparator();
            pp.add(new JMenuItem(ActionUtils.createAction("Each 1 hour", this.recurringFactory(3600000L))));
            pp.add(new JMenuItem(ActionUtils.createAction("Each 1 day", this.recurringFactory(86400000L))));
            pp.add(new JMenuItem(ActionUtils.createAction("Each week", this.recurringFactory(604800000L))));
            pp.addSeparator();
            pp.add(new JMenuItem(ActionUtils.createAction("Each year", null, false, () -> JOptionPane.showMessageDialog(null, (new String[]{"Really?", "One year is a really really long time", "I'm sorry Hal, i can't do that"})[(int)(Math.random() * 3.0)]), null)));
            pp.show(executeExtra, 0, 15);
        }, null);
        executeExtra.setAction(this.recurringActionDropDown);
        executeExtra.setToolTipText("Execute with options...");
        panel.toolBar.add(executeExtra);
        panel.toolBar.addSeparator();
        JButton executeForEdit = new JButton("Edit from query");
        executeForEdit.setFocusable(false);
        executeForEdit.setIcon(IconUtils.getSmallIcon("table_selection_header.png"));
        executeForEdit.addActionListener(al -> {
            String scriptToRun = this.getScriptToRun();
            if (StringUtils.isEmpty(scriptToRun)) {
                return;
            }
            this.editor.editTable(scriptToRun, Optional.ofNullable(this.getOrCreateScriptStateForTab(this.editorManager.currentTab())));
        });
        panel.toolBar.add(executeForEdit);
        panel.toolBar.addSeparator();
        panel.toggleFileScriptButton.addActionListener(l -> this.scriptReporter.toggleFileScriptButton());
        ((RunnerView)this.view).getPanel().mainSplitPane.setDividerLocation(RunnerPresenter.getConfig().getNumberConfigValue("viewConfig.treeSplitDividerLocation", -1).intValue());
        panel.mainSplitPane.addPropertyChangeListener(evt -> {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("dividerLocation")) {
                if (!mainPanel.toggleServersButton.isSelected() && (Integer)evt.getNewValue() > (Integer)evt.getOldValue() && (Integer)evt.getOldValue() > -1) {
                    mainPanel.toggleServersButton.setSelected(true);
                    this.toggleServerView(true);
                }
                RunnerPresenter.getConfig().setConfigValue("viewConfig.treeSplitDividerLocation", evt.getNewValue());
                ConfigHandler.saveInBackground();
            }
        });
        panel.toggleServersButton.addActionListener(l -> this.toggleServerView(((AbstractButton)l.getSource()).isSelected()));
        this.validateButton = ButtonUtils.createToolbarButton(JButton::new, "Validate", "table_sql_check.png", true, () -> this.execute(true), new KeyStroke[0]);
        panel.toolBar.add(this.validateButton);
        panel.toolBar.addSeparator();
        this.qPlanButton = ButtonUtils.createToolbarButton(JToggleButton::new, "Query plan", "up_down_question.png", true, () -> {
            RunnerPresenter.getConfig().setConfigValue("query.queryplan", this.qPlanButton.isSelected());
            ConfigHandler.saveInBackground();
        }, new KeyStroke[0]);
        this.qPlanButton.setSelected(RunnerPresenter.getConfig().getBooleanConfigValue("query.queryplan", false));
        panel.toolBar.add(this.qPlanButton);
        JButton qPlanExtra = new JButton();
        qPlanExtra.setHorizontalTextPosition(4);
        qPlanExtra.setFocusable(false);
        this.estimatedQueryPlan = ActionUtils.createAction("Estimated query plan", "up_down_question.png", true, () -> this.runQuery(RunMode.ESTIMATE, this.getStuffToRun(), this.editorManager.currentTab(), Optional.empty(), new FileRunnerProgressReporter[0]));
        Action qPlanAction = ActionUtils.createAction("", "arrow_down_menu.png", true, () -> {
            JPopupMenu pp = new JPopupMenu("Query plan utils");
            pp.add(new JMenuItem(this.estimatedQueryPlan));
            pp.show(qPlanExtra, 0, 15);
        }, null);
        qPlanExtra.setAction(qPlanAction);
        qPlanExtra.setToolTipText("Query plan with options...");
        panel.toolBar.add(qPlanExtra);
        panel.toolBar.addSeparator();
        JToggleButton toggleButton = new JToggleButton(this.scriptReporter.getViewOutputAction());
        toggleButton.setFocusable(false);
        panel.toolBar.add(toggleButton);
        Object toggleName = this.scriptReporter.getViewOutputAction().getValue("Name");
        toggleButton.getInputMap(2).put((KeyStroke)this.scriptReporter.getViewOutputAction().getValue("AcceleratorKey"), toggleName);
        toggleButton.getActionMap().put(toggleName, this.scriptReporter.getViewOutputAction());
        panel.toolBar.add(new JToolBar.Separator());
        JButton excelButton = ButtonUtils.createToolbarButton(JButton::new, "Export data", "document_up.png", true, this.scriptReporter::exportData, new KeyStroke[0]);
        panel.toolBar.add(excelButton);
        JButton exportExtra = ButtonUtils.createToolbarButton(JButton::new, "", "arrow_down_menu.png", true, this.scriptReporter::exportDataWithOptions, new KeyStroke[0]);
        panel.toolBar.add(exportExtra);
        panel.toolBar.addSeparator();
        JButton importDataButton = ButtonUtils.createToolbarButton(JButton::new, "Import data", "document_down.png", true, () -> {
            ServerDatabase d = this.sqlManager.getCurrent();
            if (d != null && d.getDb() != null) {
                FileImporter f = new FileImporter(d.getDb(), d.getDatabase());
                f.doImport(this.mainFrame);
            } else {
                JOptionPane.showConfirmDialog(this.mainFrame, "No database selected");
            }
        }, new KeyStroke[0]);
        panel.toolBar.add(importDataButton);
        JButton importExtraButton = new JButton();
        importExtraButton.setHorizontalTextPosition(4);
        importExtraButton.setFocusable(false);
        Action importRaw = ActionUtils.createAction("Import whole files", "file.png", true, () -> {
            ServerDatabase d = this.sqlManager.getCurrent();
            if (d != null) {
                new RawImporter(this.mainFrame).importFile(d, (ThrowingConsumer<ImportResult>)((ThrowingConsumer)r -> {
                    if (r.isSuccessful()) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Import successful");
                    } else if (!r.isCancelled()) {
                        JXErrorPane.showDialog((Component)this.mainFrame, (ErrorInfo)new ErrorInfo("Import failed", "Error occured while importing raw file", r.getFailureReason(), null, (Throwable)r.getException(), Level.WARNING, null));
                    }
                }));
            }
        });
        Action importGeo = ActionUtils.createAction("Import geo files", "map.png", true, () -> {
            ServerDatabase d = this.sqlManager.getCurrent();
            if (d != null) {
                new GeoPackageImporter(this.mainFrame).importFile(d, (ThrowingConsumer<ImportResult>)((ThrowingConsumer)r -> {
                    if (r.isSuccessful()) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Import successful");
                    } else if (!r.isCancelled()) {
                        JXErrorPane.showDialog((Component)this.mainFrame, (ErrorInfo)new ErrorInfo("Import failed", "Error while importing geo", r.getFailureReason(), null, (Throwable)r.getException(), Level.WARNING, null));
                    }
                }));
            }
        });
        Action importGrib = ActionUtils.createAction("Import grib files", "map.png", true, () -> {
            ServerDatabase d = this.sqlManager.getCurrent();
            if (d != null) {
                new GribImporter(this.mainFrame).importFile(d, (ThrowingConsumer<ImportResult>)((ThrowingConsumer)r -> {
                    if (r.isSuccessful()) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Import successful");
                    } else if (!r.isCancelled()) {
                        JXErrorPane.showDialog((Component)this.mainFrame, (ErrorInfo)new ErrorInfo("Import failed", "Error while importing grib", r.getFailureReason(), null, (Throwable)r.getException(), Level.WARNING, null));
                    }
                }));
            }
        });
        Action importExtra = ActionUtils.createAction("", "arrow_down_menu.png", true, () -> {
            JPopupMenu pp = new JPopupMenu("Import");
            pp.add(new JMenuItem(importRaw));
            pp.add(new JMenuItem(importGeo));
            pp.add(new JMenuItem(importGrib));
            pp.show(importExtraButton, 0, 15);
        }, null);
        importExtraButton.setAction(importExtra);
        importExtraButton.setToolTipText("Import...");
        panel.toolBar.add(importExtraButton);
        panel.toolBar.addSeparator();
        panel.recentToggler.setIcon(IconUtils.getSmallIcon("clock.png"));
        panel.recentToggler.addActionListener(l -> {
            boolean selected = mainPanel.recentToggler.isSelected();
            if (selected) {
                ((RunnerView)this.view).getPanel().recentSplitPane.setDividerLocation(RunnerPresenter.getConfig().getNumberConfigValue("viewConfig.recentSplitDividerLocation", -1).intValue());
            } else {
                RunnerPresenter.getConfig().setConfigValue("viewConfig.recentSplitDividerLocation", ((RunnerView)this.view).getPanel().recentSplitPane.getDividerLocation());
                ConfigHandler.saveInBackground();
            }
            mainPanel.recentPanel.setVisible(selected);
        });
        LOGGER.debug("Finished runner presenter");
    }

    private Runnable recurringFactory(long delay) {
        return () -> this.runRecurringQuery(delay);
    }

    private void runRecurringQuery(long delay) {
        final String toRun = this.getScriptToRun();
        if (toRun.isEmpty()) {
            return;
        }
        final RecurringRunState rrr = new RecurringRunState(toRun, delay);
        final TabContent currentTab = this.editorManager.currentTab();
        final SQLScriptState state = this.getOrCreateScriptStateForTab(currentTab);
        state.setRecurringState(rrr);
        ProgressReportedAdaptor progressReportedAdaptor = new ProgressReportedAdaptor(){

            @Override
            public void reportFinished() {
                NEW_SINGLE_THREAD_SCHEDULED_EXECUTOR.schedule(() -> {
                    if (rrr.equals(state.getRecurringState())) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = toRun;
                        RunnerPresenter.this.runQuery(RunMode.RUN, objectArray, currentTab, Optional.empty(), new FileRunnerProgressReporter[]{this});
                    }
                }, rrr.getDelayBetweenRuns(), TimeUnit.MILLISECONDS);
            }
        };
        Object[] objectArray = new Object[2];
        objectArray[0] = toRun;
        this.runQuery(RunMode.RUN, objectArray, currentTab, Optional.empty(), progressReportedAdaptor);
    }

    @Override
    public Action getValidateSQLAction() {
        return this.validateButton.getAction();
    }

    @Override
    public Action getRecurringActionDropDown() {
        return this.recurringActionDropDown;
    }

    public Action getSQLAction() {
        return ((RunnerView)this.view).getPanel().executeScriptButton.getAction();
    }

    @Override
    public void setSQLAction(Action executeAction) {
        if (executeAction == this.executeSQLAction) {
            LOGGER.error("Setting exec action to sql action, this isn't supposed to happen");
            executeAction = null;
        }
        if (executeAction == null) {
            ((RunnerView)this.view).getPanel().executeScriptButton.setAction(this.executeSQLAction);
            this.executeSQLAction.setEnabled(true);
            ((RunnerView)this.view).getPanel().executeScriptButton.setEnabled(true);
            this.updateExecuteButton();
        } else {
            this.executeSQLAction.setEnabled(false);
            ((RunnerView)this.view).getPanel().executeScriptButton.setAction(executeAction);
            ((RunnerView)this.view).getPanel().executeScriptButton.setEnabled(executeAction.isEnabled());
        }
        ((RunnerView)this.view).getPanel().executeScriptButton.repaint();
    }

    @Override
    public Action getEstimatedQueryPlanAction() {
        return this.estimatedQueryPlan;
    }

    private void updateExecuteButton() {
        List<? extends ServerDatabase> currentDatabase = this.sqlManager.getCurrents();
        int cnt = currentDatabase != null ? currentDatabase.size() : 1;
        this.executeSQLAction.putValue("SmallIcon", cnt > 1 ? this.executeMultipleIcon : this.executeSingleIcon);
        this.executeSQLAction.putValue("Name", cnt > 1 ? "Execute(" + cnt + ")" : "Execute  ");
        SwingUtilities.invokeLater(() -> {
            ((RunnerView)this.view).getPanel().recentList.revalidate();
            ((RunnerView)this.view).getPanel().recentList.repaint();
        });
    }

    public void newScriptRun(String script, ServerDatabase sd) {
        this.editorManager.newFile(null, script, new MapBuilder((Object)"runScript", (Object)true).append((Object)STATE_KEY_FOR_CURRENT_DB, (Object)sd).build());
    }

    public void openFiles(List<File> files, boolean activateEditor) {
        block6: {
            if (activateEditor && !this.stateListener.isHasFocus()) {
                try {
                    try {
                        this.mainFrame.getWindowListeners()[0].windowActivated(new WindowEvent(this.mainFrame, 205));
                        ((RunnerView)this.view).getPanel().requestFocusInWindow();
                        this.mainFrame.setAlwaysOnTop(true);
                    }
                    catch (Exception exception) {
                        this.mainFrame.setAlwaysOnTop(false);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    this.mainFrame.setAlwaysOnTop(false);
                    throw throwable;
                }
                this.mainFrame.setAlwaysOnTop(false);
            }
        }
        SwingUtilities.invokeLater(() -> FileUtils.displayFileMessages(this.editorManager.openFiles(files)));
    }

    private void toggleServerView(boolean isToggled) {
        ((RunnerView)this.view).getPanel().serverPanel.setVisible(isToggled);
        ((RunnerView)this.view).getPanel().mainSplitPane.setDividerLocation(-1);
    }

    private void execute(boolean parseOnly) {
        Object[] scriptFiles = this.getStuffToRun();
        if (scriptFiles == null) {
            return;
        }
        this.runQuery(parseOnly, scriptFiles, new FileRunnerProgressReporter[0]);
    }

    private void runQuery(String script, FileRunnerProgressReporter ... reporters) {
        Object[] objectArray = new Object[2];
        objectArray[0] = script;
        this.runQuery(false, objectArray, reporters);
    }

    private void runQuery(boolean parseOnly, Object[] scriptFiles, FileRunnerProgressReporter ... reporters) {
        this.runQuery(parseOnly ? RunMode.VERIFY : RunMode.RUN, scriptFiles, this.editorManager.currentTab(), Optional.empty(), reporters);
    }

    private void runQuery(String sql, IOutput mode) {
        Object[] objectArray = new Object[2];
        objectArray[0] = sql;
        this.runQuery(RunMode.RUN, objectArray, this.editorManager.currentTab(), Optional.of(mode), new FileRunnerProgressReporter[0]);
    }

    private IOutput getOutputTarget(boolean parseOnly) {
        OutputFormat oof = ConfigHandler.getConfig().getOutputFormat();
        if (!parseOnly) {
            if (OutputFormat.FILE == oof) {
                ExportDialog ed = new ExportDialog(this.mainFrame, true);
                ed.setTitle("Export output as");
                Binder.Presenter presenter = Binder.bindToCombo(ed.getExportCombo(), this.actions.stream().collect(Collectors.toList()));
                ed.getExportCombo().setRenderer(new LabelledCellRenderer(false));
                ed.getExportButton().setIcon(IconUtils.getSmallIcon("export2.png"));
                ed.getJustRunButton().setIcon(IconUtils.getSmallIcon("flash.png"));
                ed.getCancelButton().setIcon(IconUtils.getSmallIcon("close.png"));
                ed.getExportButton().addActionListener(e -> {
                    ed.setReturnStatus(1);
                    ed.dispose();
                });
                ed.getCancelButton().addActionListener(e -> {
                    ed.setReturnStatus(0);
                    ed.dispose();
                });
                ed.getJustRunButton().addActionListener(e -> {
                    ed.setReturnStatus(3);
                    ed.dispose();
                });
                ed.setVisible(true);
                if (ed.getReturnStatus() == 1) {
                    Object pref;
                    ExportAction chosen = this.actions.stream().filter(f -> f.equals(((com.siggemannen.binding.ValueHolder)presenter.getModel().getObject()).getValue())).findFirst().get();
                    String f2 = chosen.getFile(pref = chosen.getPreferences(null, false));
                    if (f2 != null) {
                        return OutputBuilder.toFile(chosen, new File(f2), pref);
                    }
                    return null;
                }
                if (ed.getReturnStatus() == 0) {
                    return null;
                }
            } else if (OutputFormat.SCRIPT == oof) {
                return this.outputPresenter.present(this.mainFrame, false);
            }
        }
        switch (oof) {
            case TEXT: {
                return OutputBuilder.toText();
            }
        }
        return OutputBuilder.toTable();
    }

    private void runQuery(RunMode runMode, Object[] scriptFiles, TabContent current, Optional<IOutput> outputMode, FileRunnerProgressReporter ... reporters) {
        boolean severalServers;
        if (!this.ready) {
            return;
        }
        this.status.removeMessage("RunnerPresenter");
        if (this.scriptReporter.isRunning(current)) {
            this.status.addMessage("Query already running", "RunnerPresenter", 1500);
            return;
        }
        boolean parseOnly = runMode == RunMode.VERIFY;
        boolean estimatePlan = runMode == RunMode.ESTIMATE;
        boolean generateQueryPlan = RunnerPresenter.getConfig().getBooleanConfigValue("query.queryplan", false);
        List<Server> selectedServers = this.getSelectedServers();
        if (selectedServers.size() == 0) {
            JOptionPane.showMessageDialog(this.mainFrame, "No servers selected", "Select a server first", 0, null);
            this.status.addMessage("No servers selected", "RunnerPresenter", 1500);
            return;
        }
        IOutput output = outputMode.orElse(this.getOutputTarget(parseOnly));
        if (output == null) {
            return;
        }
        SQLScriptState scriptState = this.scriptReporter.isFileViewToggled() ? this.scriptReporter.getOrCreateRunFilesState() : this.getOrCreateScriptStateForTab(current);
        scriptState.init();
        ArrayList<FileRunnerProgressReporter> reports = new ArrayList<FileRunnerProgressReporter>();
        reports.add(scriptState);
        reports.add(new ProgressWatcher(current));
        reports.addAll(Arrays.asList(reporters));
        boolean bl = severalServers = selectedServers.size() > 1 || selectedServers.stream().anyMatch(l -> l.getDatabases().size() > 1);
        if (scriptFiles[1] != null || severalServers) {
            SQLOptions options = new SQLOptions.Builder().parseOnly(parseOnly).generateQueryPlan(estimatePlan ? SQLPlanType.ESTIMATED : (generateQueryPlan ? SQLPlanType.ACTUAL : SQLPlanType.NONE)).build();
            scriptState.setServers(selectedServers);
            RunFilesInDBs.run(selectedServers, (String)scriptFiles[0], (List)scriptFiles[1], reports, options, output);
        } else {
            scriptState.setServers(null);
            Server server = selectedServers.get(0);
            String database = server.getDatabases().get(0);
            String script = (String)scriptFiles[0];
            SQLOptions options = new SQLOptions.Builder().parseOnly(parseOnly).rollbackAllUncommitedTransactions(false).generateQueryPlan(estimatePlan ? SQLPlanType.ESTIMATED : (generateQueryPlan ? SQLPlanType.ACTUAL : SQLPlanType.NONE)).build();
            Runnable hardCancel = () -> {
                reports.stream().forEachOrdered(IProgressReporter::reportCancelled);
                reports.stream().forEachOrdered(IProgressReporter::reportFinished);
                scriptState.setScriptRunner(null);
                LOGGER.debug("Hard cancel fired");
            };
            scriptState.setHardCancel(hardCancel);
            reports.stream().forEachOrdered(l -> l.reportStarted(options));
            reports.stream().forEachOrdered(l -> {
                l.setRunContext(new RunContext(server, null, null, null, options, output));
                l.reportServerStarted();
            });
            reports.stream().forEachOrdered(l -> l.setRunContext(new RunContext(server, database, null, script, options, output)));
            new BackgroundRunner(() -> {
                IScriptRunner runner = null;
                try {
                    try {
                        runner = scriptState.getScriptRunner();
                        if (runner == null) {
                            runner = server.getDatabase().createRunner(database, options);
                            scriptState.setScriptRunner(runner);
                        }
                        if (!this.backgroundExecute(runner::isAlive, false, "Checking db for liveness", "It seems the connection associated with the window is no longer alive, do you want to create a new one?", "Create new").booleanValue()) {
                            runner.closeConnection();
                            runner = server.getDatabase().createRunner(database, options);
                            scriptState.setScriptRunner(runner);
                        }
                        runner.runScript(new StringReader(script), reports.stream().map(l -> l).collect(Collectors.toList()), options);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Exception while checking", (Throwable)ex);
                        try {
                            reports.stream().forEach(l -> l.reportScriptFailure("Script run", null, ex, false));
                        }
                        catch (Exception e) {
                            LOGGER.error("Error while running", (Throwable)e);
                        }
                        throw new RuntimeException("Exception " + ex + "occured while processing db:" + database, ex);
                    }
                }
                catch (Throwable throwable) {
                    reports.stream().forEachOrdered(l -> {
                        l.setRunContext(new RunContext(server, null, null, null, options, output));
                        l.reportServerFinished();
                    });
                    reports.stream().forEachOrdered(IProgressReporter::reportFinished);
                    throw throwable;
                }
                reports.stream().forEachOrdered(l -> {
                    l.setRunContext(new RunContext(server, null, null, null, options, output));
                    l.reportServerFinished();
                });
                reports.stream().forEachOrdered(IProgressReporter::reportFinished);
            }).execute();
        }
    }

    private void getDatabaseInBackground() {
        try {
            List<ServerDatabase> l = this.getCurrentDatabase();
            if (l != null && !Objects.equals(l, this.sqlManager.getCurrents()) && l.size() > 0) {
                WideDropDownComboBox databaseCombobox = ((RunnerView)this.view).getPanel().databaseCombobox;
                ServerDatabase anObject = l.get(0);
                DefaultComboBoxModel mox = (DefaultComboBoxModel)databaseCombobox.getModel();
                boolean foundDb = false;
                int el = 0;
                while (el < mox.getSize()) {
                    ServerDatabase comboDb;
                    Object item = mox.getElementAt(el);
                    if (item instanceof ServerDatabase && (comboDb = (ServerDatabase)item).equals(anObject)) {
                        foundDb = true;
                        break;
                    }
                    ++el;
                }
                if (!foundDb) {
                    LOGGER.info("Adding {}", (Object)anObject);
                    DefaultMutableTreeNode t = DatabaseManager.findNode(anObject.getId());
                    if (t != null) {
                        ((RunnerView)this.view).getPanel().getCheckBoxTree().addSubtreeToCheckingStateTracking(t);
                    } else {
                        LOGGER.error("Tree node not found for some reason");
                    }
                    mox.addElement(anObject);
                }
                this.findAndSelectDatabaseNode(l);
                databaseCombobox.setSelectedItem(anObject);
                this.sqlManager.setCurrent(l);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Exception", (Throwable)ex);
        }
    }

    protected void afterObjectSet() {
        super.afterObjectSet();
        this.editorManager.addTabListener(this);
        this.editorManager.addTabListener(this.scriptReporter);
        final DefaultListModel contents = new DefaultListModel();
        new BackgroundRunner(() -> {
            block5: {
                try {
                    try {
                        FileUtils.displayFileMessages(this.editorManager.configure());
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while configuring", (Throwable)e);
                        this.ready = true;
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    this.ready = true;
                    throw throwable;
                }
                this.ready = true;
            }
            this.holder.addListener((CardHolder.CardHolderListener<TabContent>)new CardHolderChangeTracker<TabContent>(){

                @Override
                public void removedFromResurrection(TabContent element) {
                    RunnerPresenter.this.scriptReporter.removedFromResurrection(element);
                }

                @Override
                public void onChange() {
                    SwingUtilities.invokeLater(() -> RunnerPresenter.this.recreateContexts(contents));
                }
            });
            SwingUtilities.invokeLater(() -> this.recreateContexts(contents));
        }).execute();
        ((RunnerView)this.view).fileTable.setColumnFactory((ColumnFactory)new VTableColumnFactory());
        final MainPanel panel = ((RunnerView)this.view).getPanel();
        panel.fileScrollPane.setViewportView((Component)panel.fileTable);
        ((RunnerView)this.view).fileTable.setColumnModel(((RunnerModel)this.model).scriptTableModel.getTableColumnModel());
        ((RunnerView)this.view).fileTable.setModel((TableModel)((Object)((RunnerModel)this.model).scriptTableModel));
        ((RunnerView)this.view).fileTable.revalidate();
        ((RunnerView)this.view).fileTable.getModel().addTableModelListener(l -> {
            if (((RunnerView)this.view).fileTable.getModel().getRowCount() > 0) {
                ((RunnerView)this.view).fileTable.packAll();
            }
        });
        panel.recentList.setModel(contents);
        final TabContentFilter filter = new TabContentFilter(panel.filterRecents);
        panel.recentList.setSortable(true);
        panel.recentList.setRowSorter((RowSorter)new ListSortController(contents));
        panel.recentList.setRowFilter((RowFilter)filter);
        panel.recentList.setCellRenderer(TabRendererSupplier.get());
        Runnable chooseRecentItem = () -> {
            TabContent tc = (TabContent)mainPanel.recentList.getSelectedValue();
            if (tc != null) {
                this.holder.current(tc);
            }
        };
        JListUtils.bindArrowsToFilter(panel.filterRecents, (JComponent)panel.recentList, chooseRecentItem);
        panel.filterRecents.getDocument().addDocumentListener((DocumentListener)new ADocumentAdapter(){

            protected void setValueFromDocument(DocumentEvent e) {
                panel.recentList.setRowFilter((RowFilter)filter);
            }
        });
        SwingUtilities.invokeLater(() -> {
            panel.getCheckBoxTree().setModel(new DefaultTreeModel(this.getTree(((List)((RunnerModel)this.model).getServers().getValue()).stream().filter(RunnerServerConfig::isEnabled).collect(Collectors.toList()))));
            ((RunnerView)this.view).tree.expandAll();
        });
        this.reloadDBs(false);
    }

    private void recreateContexts(DefaultListModel<TabContent> contents) {
        contents.clear();
        new ArrayList<TabContent>(this.holder.historyView()).forEach(cx -> {
            RunningTabContent tr = new RunningTabContent((TabContent)cx);
            SQLScriptState q = this.scriptReporter.getCurrentState((TabContent)cx);
            if (q != null && q.isRunning()) {
                tr.setRunning(true);
            }
            contents.addElement(tr);
        });
    }

    private TreeNode getTree(List<RunnerServerConfig> databases) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Servers");
        for (DatabaseServerConfig databaseServerConfig : databases) {
            root.add(new DefaultMutableTreeNode(databaseServerConfig));
        }
        return root;
    }

    private Object[] getStuffToRun() {
        String script = null;
        List<File> files = null;
        if (this.scriptReporter.isFileViewToggled()) {
            files = this.getSelectedFiles(((RunnerModel)this.model).filesToRun);
            if (files.size() == 0) {
                JOptionPane.showMessageDialog(this.mainFrame, "There are no files to run");
                return null;
            }
        } else {
            script = this.getScriptToRun();
            if (script.isEmpty()) {
                JOptionPane.showMessageDialog(this.mainFrame, "There's nothing to run");
                return null;
            }
        }
        if (RunnerPresenter.getConfig().getBooleanConfigValue("query.newbiemode", false).booleanValue() && JOptionPane.showConfirmDialog(this.mainFrame, "Are you really sure you want to run?", "Confirm execution", 2, 3, null) != 0) {
            return null;
        }
        return new Object[]{script, files};
    }

    private String getScriptToRun() {
        String scriptText = (String)((RunnerModel)this.model).getSelectedScript().getValue();
        if (scriptText.isEmpty()) {
            String selectedAccordingToTextArea = this.editorManager.getCurrentTab().getSelectedText();
            if (selectedAccordingToTextArea.length() > 0) {
                LOGGER.error("Unsynched selection occured");
                return selectedAccordingToTextArea;
            }
            return ((RSyntaxTextArea)((RunnerModel)this.model).getCurrentEditor().getValue()).getText();
        }
        return scriptText;
    }

    private void reloadDBs(boolean actuallyReload) {
        boolean ready;
        boolean encrypted = RunnerPresenter.getConfig().isEncryptedData();
        if (encrypted && RunnerPresenter.getConfig().getKeypass() == null) {
            char[] pass = this.pass("Please enter keyphrase for your password");
            if (pass == null || pass.length == 0) {
                return;
            }
            RunnerPresenter.getConfig().setKeypass(pass);
            actuallyReload = true;
        }
        if (actuallyReload) {
            if (this.sqlManager.getCurrents().size() > 0) {
                RunnerPresenter.getConfig().setLastSelectedDatabases(this.sqlManager.getCurrents().stream().map(ServerDatabase::getId).collect(Collectors.toList()));
            }
            this.dbm.loadDatabasesFromConfig((ThrowingConsumer<Exception>)((ThrowingConsumer)e -> {
                if (e instanceof InvalidKeyException && encrypted) {
                    JOptionPane.showMessageDialog(null, "Couldn't decrypt with attached key");
                    RunnerPresenter.getConfig().setKeypass(null);
                } else {
                    JOptionPane.showMessageDialog(null, "Error occured while loading databases: " + DatabaseManager.getLastErrorMessage());
                }
                this.unwind(null);
            }));
        }
        if (ready = DatabaseManager.isReady(() -> SwingUtilities.invokeLater(this::processDatabases2), this::prepareReload)) {
            SwingUtilities.invokeLater(this::processDatabases2);
        }
    }

    private void prepareReload() {
        ((RunnerView)this.view).getPanel().databaseCombobox.setEnabled(false);
        this.mainFrame.getGlassPane().setVisible(true);
        this.mainFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
    }

    private char[] pass(String input) {
        JPasswordField pf = new JPasswordField();
        int okCxl = JOptionPane.showConfirmDialog(this.mainFrame, pf, input, 2, -1);
        if (okCxl == 0) {
            return pf.getPassword();
        }
        return null;
    }

    void processDatabases2() {
        this.unwind(null);
        String error = DatabaseManager.getLastErrorMessage();
        JCheckBoxTree checkBoxTree = ((RunnerView)this.view).getPanel().getCheckBoxTree();
        checkBoxTree.setModel(new DefaultTreeModel(DatabaseManager.getRoot()));
        ArrayList<ServerDatabase> dbs2 = new ArrayList<ServerDatabase>();
        dbs2.add(new ServerDatabase(null, "(Choose database)"));
        dbs2.addAll(DatabaseManager.getServerDatabases());
        ((RunnerView)this.view).getPanel().databaseCombobox.setModel(new DefaultComboBoxModel<Object>(dbs2.toArray()));
        ((RunnerView)this.view).getPanel().databaseCombobox.adjustDropDownMenuWidth(l -> {
            if (l == null) {
                return "";
            }
            ServerDatabase db = (ServerDatabase)l;
            String serverString = db.getDb() == null ? " " : String.valueOf(db.getDb().getLabel()) + " ";
            return " " + db.getDatabase() + " " + serverString;
        });
        SwingUtilities.invokeLater(((RunnerView)this.view).tree::expandAll);
        new BackgroundRunner(() -> {
            this.cdb.setObject((Object)new DbHolder(dbs2));
            this.sqlManager.setCurrent(RunnerPresenter.getConfig().getLastSelectedDatabases().stream().map(s -> DatabaseManager.findDb(s)).filter(Objects::nonNull).collect(Collectors.toList()));
        }).execute();
        if (error.length() > 0) {
            SwingUtilities.invokeLater(() -> JXErrorPane.showDialog((Component)((Object)((RunnerView)this.view).getPanel()), (ErrorInfo)new ErrorInfo("Error", "Error while loading databases", error, null, null, Level.INFO, null)));
        }
    }

    void unwind(Exception e) {
        this.mainFrame.getGlassPane().setVisible(false);
        this.mainFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
        ((RunnerView)this.view).getPanel().databaseCombobox.setEnabled(true);
    }

    void findAndSelectDatabaseNode(List<? extends ServerDatabase> d) {
        JCheckBoxTree checkBoxTree = ((RunnerView)this.view).getPanel().getCheckBoxTree();
        if (d.size() == 0) {
            checkBoxTree.quickResetAllChecks();
            return;
        }
        if (d.size() == 1 && d.get(0).getDb() == null) {
            return;
        }
        List<TreePath> tps = d.stream().filter(Objects::nonNull).map(q -> DatabaseManager.findDbTreePath(q.getId())).collect(Collectors.toList());
        checkBoxTree.quickResetAllChecks();
        checkBoxTree.setCheckStatus(tps, true);
        if (tps.size() > 0 && d.size() == 1) {
            checkBoxTree.scrollPathToVisible(tps.get(tps.size() - 1));
        }
    }

    void selectDbFromCombo() {
        ServerDatabase db = (ServerDatabase)((RunnerView)this.view).getPanel().databaseCombobox.getSelectedItem();
        if (db != null && db.getDb() != null) {
            SwingUtilities.invokeLater(() -> {
                if (!this.preview(Arrays.asList(db))) {
                    ((RunnerView)this.view).getPanel().databaseCombobox.setSelectedItem(this.sqlManager.getCurrent());
                    return;
                }
                this.sqlManager.setCurrent(db);
            });
        }
    }

    private List<ServerDatabase> getCurrentDatabase() {
        SQLScriptState state = this.scriptReporter.getCurrentState(this.editorManager.currentTab());
        if (state == null) {
            return null;
        }
        return state.getCurrentDatabases();
    }

    private String getDatabase(IScriptRunner runner) {
        try {
            return runner.getCurrentDatabase();
        }
        catch (SQLException se) {
            LOGGER.error("Failed getting db", (Throwable)se);
            return null;
        }
    }

    private void expandTree() {
        JCheckBoxTree checkBoxTree = ((RunnerView)this.view).getPanel().getCheckBoxTree();
        int i = 0;
        while (i < checkBoxTree.getRowCount()) {
            checkBoxTree.expandRow(i);
            ++i;
        }
        checkBoxTree.revalidate();
        checkBoxTree.repaint();
    }

    private List<File> getSelectedFiles(IListProperty<FileToRun> filesToRun) {
        return ((List)filesToRun.getValue()).stream().filter(l -> l.isChecked()).map(l -> new File(l.getPath())).collect(Collectors.toList());
    }

    private List<Server> getSelectedServers() {
        HashMap servers = new HashMap();
        this.getLastSelectedDbs().stream().forEach(l -> servers.computeIfAbsent(l.getDb().getUniqueProviderName(), q -> new Server(l.getDb(), new ArrayList<String>())).getDatabases().add(l.getDatabase()));
        return servers.values().stream().collect(Collectors.toList());
    }

    private List<ServerDatabase> getSelectedDatabases(TreePath[] treePaths) {
        ArrayList<ServerDatabase> db = new ArrayList<ServerDatabase>();
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            Object[] objectArray = path.getPath();
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object p = objectArray[n4];
                DefaultMutableTreeNode o = (DefaultMutableTreeNode)p;
                if (o.getUserObject() instanceof ServerDatabase) {
                    db.add((ServerDatabase)o.getUserObject());
                }
                ++n4;
            }
            ++n2;
        }
        return db;
    }

    private List<? extends ServerDatabase> getLastSelectedDbs() {
        return this.sqlManager.getCurrents();
    }

    @Override
    public void runSQL(String sql) {
        this.runQuery(sql, new FileRunnerProgressReporter[0]);
    }

    public void runSQLTool(SQLTool sqltool) {
        this.runQuery(this.buildCommandFromTool(sqltool), sqltool.isTextmode() ? OutputBuilder.toText() : OutputBuilder.toTable());
    }

    private static Config getConfig() {
        return ConfigHandler.getConfig();
    }

    private String buildCommandFromTool(SQLTool sqltool) {
        return this.getCommandFromString(sqltool.getCommand());
    }

    private String getCommandFromString(String str) {
        String command = str;
        TabContent tc = this.editorManager.currentTab();
        if (tc.isAFile()) {
            command = command.replace("${fullpath}", tc.getFileName());
            command = command.replace("${filename}", Paths.get(tc.getFileName(), new String[0]).getFileName().toString());
            command = command.replace("${dirpath}", Paths.get(tc.getFileName(), new String[0]).getParent().toString());
        }
        command = command.replace("${selected}", ((String)((RunnerModel)this.model).getSelectedScript().getValue()).isEmpty() ? (CharSequence)((RunnerModel)this.model).cursorToken.getValue() : (CharSequence)((RunnerModel)this.model).getSelectedScript().getValue());
        command = command.replace("${onlyselected}", ((String)((RunnerModel)this.model).getSelectedScript().getValue()).isEmpty() ? "" : (CharSequence)((RunnerModel)this.model).getSelectedScript().getValue());
        command = command.replace("${alltext}", ((RSyntaxTextArea)((RunnerModel)this.model).getCurrentEditor().getValue()).getText());
        return command;
    }

    @Override
    public void newActive(TabContent tc) {
        SQLScriptState state = this.getOrCreateScriptStateForTab(tc);
        ServerDatabase sd = (ServerDatabase)tc.getStateValue(STATE_KEY_FOR_CURRENT_DB);
        String sdString = (String)tc.getStateValue(STATE_KEY_FOR_CURRENT_DB_STRING);
        if (sdString != null) {
            sd = DatabaseManager.findDb(sdString);
            if (DatabaseManager.isReady() || state.getScriptRunner() != null) {
                System.out.println("Removing: " + sdString);
                tc.setStateValue(STATE_KEY_FOR_CURRENT_DB_STRING, null);
            } else {
                System.out.println("Keepin': " + sdString);
            }
        }
        if (sd != null) {
            if (state.getScriptRunner() == null) {
                this.sqlManager.setCurrent(sd);
                if (this.isStickyServer().booleanValue()) {
                    state.setServers(Arrays.asList(new Server(sd)));
                }
            }
            tc.setStateValue(STATE_KEY_FOR_CURRENT_DB, null);
        }
        if (tc.getStateValue("runScript") != null) {
            tc.setStateValue("runScript", null);
            if (sd != null) {
                this.sqlManager.setCurrent(sd);
                this.runQuery(tc.getContent(), new FileRunnerProgressReporter[0]);
            }
        }
        this.enableDatabaseChanges(state);
        if (this.isStickyServer().booleanValue() && this.scriptReporter.getCurrentState().filter(s -> s.getScriptRunner() != null || s.getServers() != null).isPresent()) {
            this.getDatabaseInBackground();
        }
    }

    private Boolean isStickyServer() {
        return RunnerPresenter.getConfig().isStickyServer();
    }

    private void enableDatabaseChanges(SQLScriptState state) {
        Optional<SQLScriptState> ss = state != null ? Optional.of(state) : this.scriptReporter.getCurrentState();
        ss.ifPresent(x -> {
            boolean isRunning = x.isRunning();
            boolean isRecurring = x.getRecurringState() != null;
            boolean changeable = !isRunning && !isRecurring;
            ((RunnerView)this.view).getPanel().databaseCombobox.setEnabled(changeable);
            ((RunnerView)this.view).tree.setEnabled(changeable);
            this.changeDbAction.setEnabled(changeable);
        });
        SwingUtilities.invokeLater(() -> {
            ((RunnerView)this.view).getPanel().recentList.revalidate();
            ((RunnerView)this.view).getPanel().recentList.repaint();
        });
    }

    private SQLScriptState getOrCreateScriptStateForTab(TabContent tc) {
        return this.scriptReporter.getOrCreateState(tc);
    }

    @Override
    public SQLScriptState getForTab(TabContent tc) {
        return this.scriptReporter.getCurrentState(tc);
    }

    @Override
    public void newDatabase(List<ServerDatabase> bases, ServerDatabase sb) {
        SwingUtilities.invokeLater(() -> {
            if (bases.size() > 0) {
                ((RunnerView)this.view).getPanel().databaseCombobox.setSelectedItem(sb);
                this.findAndSelectDatabaseNode(bases);
                ((ChangeDatabaseModel)this.cdb.getModel()).objectsModel.setSelectedItem((Object)sb);
                if (sb == null) {
                    LOGGER.error("sb is null");
                } else if (sb.getDb() == null) {
                    LOGGER.error("sb db is null");
                } else {
                    this.mainFrame.setTitle("FileRunner -" + sb.getLabel());
                }
                ((RunnerView)this.view).getPanel().statusBar.setOpaque(true);
                ((RunnerView)this.view).getPanel().statusBar.setBackground(((DatabaseFromConfig)sb.getDb()).getConfig().getServerColor());
                ((RunnerView)this.view).getPanel().statusBar.repaint();
                this.status.addMessage(this.getColorBlob(sb.getDatabase(), (DatabaseFromConfig)sb.getDb()), "CurrentDb");
            } else {
                this.mainFrame.setTitle("FileRunner");
                this.status.removeMessage("CurrentDb");
                ((RunnerView)this.view).tree.quickResetAllChecks();
                if (sb != null) {
                    ((RunnerView)this.view).getPanel().statusBar.setBackground(((DatabaseFromConfig)sb.getDb()).getConfig().getServerColor());
                    ((RunnerView)this.view).getPanel().statusBar.setOpaque(false);
                }
            }
            this.updateExecuteButton();
        });
    }

    private String getColorBlob(String db, DatabaseFromConfig config) {
        Color c = config.getConfig().getServerColor();
        if (c != null) {
            return "<span bgcolor=" + ColorUtils.hexOfColor(c) + (ColorUtils.isDark(c) ? " color=white" : "") + ">&nbsp;&nbsp;&nbsp;Database: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b> " + db + "</b>&nbsp;&nbsp;&nbsp;</span>";
        }
        return db;
    }

    @Override
    public boolean preview(List<ServerDatabase> databases) {
        Optional<SQLScriptState> stateX = this.scriptReporter.getCurrentState();
        if (databases.size() == 0 || !stateX.isPresent()) {
            return true;
        }
        SQLScriptState state = stateX.get();
        if (state.isRunning()) {
            return false;
        }
        IScriptRunner sr = state.getScriptRunner();
        if (sr == null) {
            if (this.isStickyServer().booleanValue()) {
                state.setServers(databases.stream().map(Server::new).collect(Collectors.toList()));
            }
            return true;
        }
        state.setServers(null);
        if (this.backgroundExecute(sr::isAlive, false, "Checking db for liveness", "Check for live connection...", "Cancel").booleanValue()) {
            boolean preview = true;
            if (databases.size() > 1) {
                int result;
                int n = result = sr.openTransactions() == 0 ? 0 : JOptionPane.showConfirmDialog(this.mainFrame, "You're selecting multiple database but the window has an active transaction. This will lose your original connection, do you want to proceed?", "Changing servers", 0);
                if (result == 0) {
                    sr.closeConnection();
                    state.setScriptRunner(null);
                } else if (result == 1) {
                    preview = false;
                }
            } else {
                ServerDatabase db = databases.get(0);
                Database newServer = db.getDb();
                if (newServer instanceof DatabaseFromConfig) {
                    newServer = ((DatabaseFromConfig)newServer).getDb();
                }
                if (Objects.equals(sr.getDatabase(), newServer)) {
                    String database = this.getDatabase(sr);
                    if (!db.getDatabase().equals(database)) {
                        LOGGER.debug("Diff between db and arg db: {}, sr db:{}", (Object)db.getDatabase(), (Object)database);
                        try {
                            sr.changeDatabase(db.getDatabase());
                        }
                        catch (SQLException e) {
                            JOptionPane.showMessageDialog(this.mainFrame, String.format("Exception %s occured when changing database", e.getMessage()));
                        }
                    }
                } else {
                    int result;
                    int n = result = sr.openTransactions() == 0 ? 0 : JOptionPane.showConfirmDialog(this.mainFrame, "You're changing servers but the window has an active transaction. This will lose your original connection, do you want to proceed?", "Changing servers", 0);
                    if (result == 0) {
                        sr.closeConnection();
                        state.setScriptRunner(null);
                        if (this.isStickyServer().booleanValue()) {
                            state.setServers(databases.stream().map(Server::new).collect(Collectors.toList()));
                        }
                    } else if (result == 1) {
                        preview = false;
                    }
                }
            }
            return preview;
        }
        return true;
    }

    private <E> E backgroundExecute(ThrowingSupplier<E> supplier, E defaultValueIfCancel, String title, String label, String cancelButtonText) {
        ValueHolder v = new ValueHolder(defaultValueIfCancel);
        UIBackgroundRunner.execute((RootPaneContainer)this.mainFrame, () -> v.setValue(supplier.get()), (String)title, (String)label, (String)cancelButtonText);
        return v.getValue();
    }

    @Override
    public boolean previewEditorRemoval(TabContent tc, ITabEditor rx) {
        SQLScriptState state = this.scriptReporter.getCurrentState(tc);
        if (state == null) {
            return true;
        }
        IScriptRunner runner = state.getScriptRunner();
        if (state.isRunning() || state.getRecurringState() != null) {
            JOptionPane.showMessageDialog(this.mainFrame, "Can't close the tab because a query is running or there's one scheduled. Stop all tasks first");
            return false;
        }
        if (runner == null || runner.openTransactions() == 0) {
            return true;
        }
        JOptionPane.showMessageDialog(this.mainFrame, "Can't close the tab because you have some open transactions, rollback or commit them first");
        return false;
    }

    public void reCrypt() {
        if (RunnerPresenter.getConfig().isEncryptedData()) {
            DatabaseManager.decrypt();
        } else {
            char[] pass = this.pass("Please enter keyphrase for your password");
            if (pass == null || pass.length == 0) {
                return;
            }
            RunnerPresenter.getConfig().setKeypass(pass);
            DatabaseManager.encrypt(false);
        }
    }

    public void clearCurrentTabResults() {
        this.scriptReporter.getCurrentState().ifPresent(s -> s.getResultSetPresenter().clearPresentation(false));
        if (this.scriptReporter.isToggled()) {
            this.scriptReporter.toggle(false);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        int res;
        List tcs = this.editorManager.getDirtyTabContents().stream().filter(TabContent::isAFile).collect(Collectors.toList());
        if (tcs.size() > 0) {
            String files = "";
            files = tcs.stream().limit(10L).map(TabContent::getFileName).reduce((a, b) -> String.valueOf(a) + "\n" + b).get();
            int res2 = JOptionPane.showConfirmDialog(this.mainFrame, "There are " + tcs.size() + " changed files. " + (tcs.size() > 10 ? "Example(s):" : "") + "\n" + files + ". \nThe changes will be lost, do you want to exit anyway?", "Exit without saving", 0);
            if (res2 == 1 || res2 == -1 || res2 == 2) {
                return;
            }
        }
        int running = 0;
        int openTrans = 0;
        for (TabContent tc : new ArrayList<TabContent>(this.holder.historyView())) {
            IScriptRunner scriptRunner;
            SQLScriptState currentState = this.getForTab(tc);
            if (currentState == null) continue;
            if (currentState.isRunning()) {
                ++running;
            }
            if ((scriptRunner = currentState.getScriptRunner()) == null || currentState.isRunning() || scriptRunner.openTransactions() <= 0) continue;
            ++openTrans;
        }
        if (!(running <= 0 && openTrans <= 0 || (res = JOptionPane.showConfirmDialog(this.mainFrame, String.format("There are windows that are running (%d) or have open transactions (%d), do you wanna exit anyway?", running, openTrans), "Exit anyway", 0)) != 1 && res != -1 && res != 2)) {
            return;
        }
        try {
            this.editorManager.saveSettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        e.getWindow().dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
        InstanceActivationHandler.shutdown();
        System.exit(0);
    }

    private class ProgressWatcher
    extends ProgressReportedAdaptor {
        private final TabContent current;

        public ProgressWatcher(TabContent current) {
            this.current = current;
        }

        @Override
        public void reportStarted(SQLOptions options) {
            RunnerPresenter.this.enableDatabaseChanges(null);
            SwingUtilities.invokeLater(() -> RunnerPresenter.this.recreateContexts((DefaultListModel)((RunnerView)((RunnerPresenter)RunnerPresenter.this).view).getPanel().recentList.getModel()));
        }

        @Override
        public void reportFinished() {
            block6: {
                RunnerPresenter.this.enableDatabaseChanges(null);
                try {
                    try {
                        if (this.current.equals(RunnerPresenter.this.editorManager.currentTab())) {
                            RunnerPresenter.this.getDatabaseInBackground();
                        }
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(RunnerPresenter.this.mainFrame, "Exception occured while fetching db status:" + e.getMessage());
                        SwingUtilities.invokeLater(() -> RunnerPresenter.this.recreateContexts((DefaultListModel)((RunnerView)((RunnerPresenter)RunnerPresenter.this).view).getPanel().recentList.getModel()));
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(() -> RunnerPresenter.this.recreateContexts((DefaultListModel)((RunnerView)((RunnerPresenter)RunnerPresenter.this).view).getPanel().recentList.getModel()));
                    throw throwable;
                }
                SwingUtilities.invokeLater(() -> RunnerPresenter.this.recreateContexts((DefaultListModel)((RunnerView)((RunnerPresenter)RunnerPresenter.this).view).getPanel().recentList.getModel()));
            }
        }
    }
}

