/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view;

import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.core.TableRowUtilities;
import com.sigge.filerunner.view.results.FieldType;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.ResultBasicTransferable;
import com.sigge.filerunner.view.results.ResultTableHandler;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class DefaultTableTransferHandler
extends TransferHandler {
    @Override
    protected Transferable createTransferable(JComponent c) {
        String val;
        int[] cols;
        int counter;
        int[] rows;
        if (!(c instanceof JTable)) {
            return null;
        }
        JTable table = (JTable)c;
        if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()) {
            return null;
        }
        if (!table.getRowSelectionAllowed()) {
            int rowCount = table.getRowCount();
            rows = new int[rowCount];
            counter = 0;
            while (counter < rowCount) {
                rows[counter] = counter;
                ++counter;
            }
        } else {
            rows = table.getSelectedRows();
        }
        if (!table.getColumnSelectionAllowed()) {
            int colCount = table.getColumnCount();
            cols = new int[colCount];
            counter = 0;
            while (counter < colCount) {
                cols[counter] = counter;
                ++counter;
            }
        } else {
            cols = table.getSelectedColumns();
        }
        if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
            return null;
        }
        IResultSetTable rstm = null;
        if (table.getModel() instanceof IResultSetTable) {
            rstm = (IResultSetTable)((Object)table.getModel());
        }
        if (rows.length == 1 && cols.length == 1 && rstm != null && rstm.getFieldType(cols[0]) == FieldType.SQLXMLSTRING) {
            return ResultTableHandler.getSingleXMLField(table);
        }
        StringBuilder plainBuf = new StringBuilder(rows.length * 8);
        StringBuilder htmlBuf = new StringBuilder(rows.length * 13);
        htmlBuf.append("<html>\n<body>\n<table>\n");
        htmlBuf.append("<tr>\n");
        int col = 0;
        while (col < cols.length) {
            Object obj = table.getTableHeader().getColumnModel().getColumn(cols[col]).getHeaderValue();
            val = obj == null ? "" : obj.toString();
            htmlBuf.append("  <th>").append(val).append("</th>\n");
            ++col;
        }
        htmlBuf.append("</tr>\n");
        int row = 0;
        while (row < rows.length) {
            htmlBuf.append("<tr>\n");
            int col2 = 0;
            while (col2 < cols.length) {
                Object o;
                val = rstm != null ? StringUtils.isBlank(rstm.getValueForDisplay(table.convertRowIndexToModel(rows[row]), TableRowUtilities.convertColumnIndexToModel(table.getColumnModel(), cols[col2])), "") : ((o = table.getValueAt(rows[row], cols[col2])) == null ? "" : o.toString());
                plainBuf.append(val);
                if (col2 + 1 != cols.length) {
                    plainBuf.append("\t");
                }
                htmlBuf.append("  <td>").append(val).append("</td>\n");
                ++col2;
            }
            if (row + 1 != rows.length) {
                plainBuf.append("\n");
            }
            htmlBuf.append("</tr>\n");
            ++row;
        }
        htmlBuf.append("</table>\n</body>\n</html>");
        IResultSetTable rst = table.getModel() instanceof IResultSetTable ? ((IResultSetTable)((Object)table.getModel())).getSelectedSnapshot() : null;
        return new ResultBasicTransferable(plainBuf.toString(), rows.length > 1 || cols.length > 1 ? htmlBuf.toString() : plainBuf.toString(), rst);
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
        Transferable t;
        if ((action == 1 || action == 2) && (this.getSourceActions(comp) & action) != 0 && (t = this.createTransferable(comp)) != null) {
            try {
                clip.setContents(t, t instanceof ClipboardOwner ? (ClipboardOwner)((Object)t) : null);
                this.exportDone(comp, t, action);
                return;
            }
            catch (IllegalStateException ise) {
                this.exportDone(comp, t, 0);
                throw ise;
            }
        }
        this.exportDone(comp, null, 0);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    public static class ForwardedTransferHandler
    extends DefaultTableTransferHandler {
        private final JComponent component;

        public ForwardedTransferHandler(JComponent component) {
            this.component = component;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return super.createTransferable(this.component);
        }
    }
}

