/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.transform.parameter;

import com.sigge.filerunner.sql.transform.expression.BaseExpression;
import com.sigge.filerunner.sql.transform.expression.Expression;
import com.sigge.filerunner.sql.transform.expression.scalars.ConstantVisitor;
import com.sigge.filerunner.sql.transform.expression.scalars.NullExpression;
import com.sigge.filerunner.sql.transform.expression.scalars.StringConstant;
import com.sigge.filerunner.sql.transform.expression.scalars.VariableExpression;
import com.siggemannen.sql.antler.TSqlParser;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ParameterValue
extends BaseExpression {
    private String name;
    private final int position;
    private Expression value;
    private boolean output;
    private boolean defaultValue;
    private TerminalNode nameNode;
    TSqlParser.Execute_parameterContext paramContext;

    public ParameterValue(TSqlParser.Execute_statement_arg_unnamedContext pt, int position) {
        super((ParseTree)pt);
        this.position = position;
        this.parseValue(pt.value);
    }

    private void parseValue(TSqlParser.Execute_parameterContext paramValue) {
        if (paramValue != null) {
            this.output = paramValue.OUT() != null || paramValue.OUTPUT() != null;
            boolean bl = this.defaultValue = paramValue.DEFAULT() != null;
            if (!this.defaultValue) {
                TSqlParser.ConstantContext constant = paramValue.constant();
                TerminalNode localId = paramValue.LOCAL_ID();
                TSqlParser.IdContext id = paramValue.id();
                TerminalNode isNull = paramValue.NULL();
                if (constant != null) {
                    this.value = (Expression)new ConstantVisitor().visit((ParseTree)constant);
                } else if (localId != null) {
                    this.value = new VariableExpression(localId);
                } else if (id != null) {
                    TerminalNode finalNode;
                    TerminalNode tn;
                    TerminalNode simpleId = id.ID();
                    TerminalNode doubleQuoteId = id.DOUBLE_QUOTE_ID();
                    TerminalNode squareId = id.SQUARE_BRACKET_ID();
                    TSqlParser.KeywordContext keyword = id.keyword();
                    TerminalNode terminalNode = tn = keyword != null && keyword.getChildCount() == 1 && keyword.getChild(0) instanceof TerminalNode ? (TerminalNode)keyword.getChild(0) : null;
                    Object object = simpleId != null ? simpleId : (doubleQuoteId != null ? doubleQuoteId : (squareId != null ? squareId : (finalNode = tn != null ? squareId : null)));
                    if (finalNode != null) {
                        this.value = new StringConstant(finalNode);
                    }
                } else if (isNull != null) {
                    this.value = new NullExpression(isNull);
                }
            }
        }
    }

    public ParameterValue(TSqlParser.Execute_statement_arg_namedContext pt, int position) {
        super((ParseTree)pt);
        this.position = position;
        this.name = pt.LOCAL_ID() != null ? pt.LOCAL_ID().getText() : null;
        this.nameNode = pt.LOCAL_ID();
        this.parseValue(pt.value);
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public Expression getParameterValue() {
        return this.value;
    }

    public ParseTree getParamNameOrValueContext() {
        if (this.nameNode != null) {
            return this.nameNode.getParent();
        }
        if (this.value != null) {
            return this.paramContext;
        }
        return null;
    }

    public boolean isOutput() {
        return this.output;
    }

    public TerminalNode getNameNode() {
        return this.nameNode;
    }
}

