/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.transform.dml;

import com.sigge.filerunner.sql.transform.expression.BaseExpression;
import com.sigge.filerunner.sql.transform.expression.Expression;
import com.sigge.filerunner.sql.transform.expression.ExpressionVisitor;
import com.sigge.filerunner.sql.transform.expression.SQLName;
import com.siggemannen.sql.antler.TSqlParser;
import java.util.Optional;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;

public class SelectColumn
extends Expression {
    private boolean leftAssignment;
    private boolean hasAs;
    private String alias;
    private Expression column;
    private boolean allStar;
    private SQLName tableNameOrAlias;
    Token firstToken;

    public SelectColumn(SQLName columnName) {
        this.column = new BaseExpression(columnName.getTokenSource());
        this.firstToken = columnName.getStartToken().orElse(null);
    }

    @Override
    public Optional<Token> getStartToken() {
        return Optional.ofNullable(this.firstToken);
    }

    public SelectColumn(TSqlParser.Select_list_elemContext ctx) {
        this.firstToken = ctx.start;
        TSqlParser.AsteriskContext asterix = ctx.asterisk();
        TSqlParser.Expression_elemContext expEl = ctx.expression_elem();
        if (asterix != null) {
            this.parseAsterisk(asterix);
        } else if (expEl != null) {
            this.parseExpEl(expEl);
        }
    }

    public SelectColumn(TSqlParser.Output_dml_list_elemContext col) {
        this.firstToken = col.start;
        TSqlParser.As_column_aliasContext outputAlias = col.as_column_alias();
        if (outputAlias != null) {
            this.alias = outputAlias.column_alias().getText();
            this.hasAs = outputAlias.AS() != null;
        }
        TSqlParser.ExpressionContext exp = col.expression();
        TSqlParser.AsteriskContext asterisk = col.asterisk();
        if (exp != null) {
            this.column = (Expression)exp.accept((ParseTreeVisitor)new ExpressionVisitor());
        } else if (asterisk != null) {
            this.parseAsterisk(asterisk);
        }
    }

    public SelectColumn(TSqlParser.IdContext id) {
        this.firstToken = id.start;
        this.column = (Expression)id.accept((ParseTreeVisitor)new ExpressionVisitor());
    }

    private SelectColumn() {
    }

    public static SelectColumn createStar() {
        SelectColumn sc = new SelectColumn();
        sc.allStar = true;
        return sc;
    }

    private void parseExpEl(TSqlParser.Expression_elemContext expEl) {
        if (expEl.leftAlias != null) {
            this.alias = expEl.leftAlias.getText();
            this.column = (Expression)expEl.leftAssignment.accept((ParseTreeVisitor)new ExpressionVisitor());
            this.leftAssignment = true;
        } else {
            this.column = (Expression)expEl.expressionAs.accept((ParseTreeVisitor)new ExpressionVisitor());
            TSqlParser.As_column_aliasContext asAlias = expEl.as_column_alias();
            if (asAlias != null) {
                this.alias = asAlias.column_alias().getText();
                this.hasAs = asAlias.AS() != null;
            }
        }
    }

    private void parseAsterisk(TSqlParser.AsteriskContext asterix) {
        TSqlParser.Table_nameContext table_name = asterix.table_name();
        if (table_name != null) {
            this.tableNameOrAlias = new SQLName(table_name);
        }
        this.allStar = true;
    }

    public boolean isAllStar() {
        return this.allStar;
    }

    @Override
    public String toString() {
        return String.valueOf(this.tableNameOrAlias != null ? this.tableNameOrAlias + "." : "") + (this.getColumn() != null ? this.getColumn() : "*") + (this.alias != null ? " AS " + this.alias : "");
    }

    public SQLName getTableNameOrAlias() {
        return this.tableNameOrAlias;
    }

    public Expression getColumn() {
        return this.column;
    }

    public String getAlias() {
        return this.alias;
    }
}

