/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.run;

import com.google.common.collect.Streams;
import com.sigge.dbrunner.IProgressReporter;
import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.core.DoubleIndexedList;
import com.sigge.filerunner.core.ProgressReportedAdaptor;
import com.sigge.filerunner.sql.run.IClauseDebugTransformer;
import com.sigge.filerunner.sql.run.IDebugVariable;
import com.sigge.filerunner.sql.run.IDebuggingContext;
import com.sigge.filerunner.sql.run.IFrame;
import com.sigge.filerunner.sql.sqlserver.ClauseUtility;
import com.sigge.filerunner.sql.sqlserver.run.DebugVariable;
import com.sigge.filerunner.sql.sqlserver.run.Frame;
import com.sigge.filerunner.sql.transform.Clause;
import com.sigge.filerunner.sql.transform.declare.Declare;
import com.sigge.filerunner.sql.transform.declare.DeclareBlock;
import com.sigge.filerunner.sql.transform.declare.DeclareType;
import com.sigge.filerunner.view.results.ResultSetTableModel;
import java.io.StringReader;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.ParseTree;

public class SQLServerClauseTransformer
implements IClauseDebugTransformer {
    private final String tableName = "#t_" + UUID.randomUUID().toString().replace("-", "_");
    private final IScriptRunner runner;
    private boolean inited = false;
    private final IDebuggingContext debugContext;

    public SQLServerClauseTransformer(IScriptRunner runner, IDebuggingContext debugContext) {
        this.runner = runner;
        this.debugContext = debugContext;
    }

    private void init() throws Exception {
        if (this.inited) {
            return;
        }
        StringBuilder sb = new StringBuilder("CREATE TABLE ").append(this.tableName).append(" (ID INT NULL, NO_COUNT INT); INSERT INTO ").append(this.tableName).append("(ID, NO_COUNT) SELECT 1, CASE WHEN 512 & @@OPTIONS = 512 THEN 1 ELSE 0 END");
        this.runner.runScript(new StringReader(sb.toString()), new ArrayList<IProgressReporter>(), new SQLOptions());
        this.inited = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IFrame evaluate(Clause clause, IFrame frame) throws Exception {
        List<? extends IDebugVariable> variables;
        Object var;
        this.init();
        String text = ClauseUtility.getExpressionTree((ParseTree)clause.getContext()).toString();
        StringBuilder sb = new StringBuilder();
        StringBuilder output = new StringBuilder();
        final List<? extends IDebugVariable> extraVars = this.appendVariables(clause, frame);
        SQLOptions options = new SQLOptions();
        if (extraVars.size() > 0) {
            void var9_10;
            StringBuilder extras = new StringBuilder("ALTER TABLE ").append(this.tableName).append(" ADD ");
            boolean bl = false;
            while (var9_10 < extraVars.size()) {
                if (var9_10 > 0) {
                    extras.append(",");
                }
                var = extraVars.get((int)var9_10);
                extras.append("[").append(var.getName()).append("]").append(" ").append(var.getType()).append(" NULL");
                ++var9_10;
            }
            extras.append(";");
            this.runner.runScript(new StringReader(extras.toString()), new ArrayList<IProgressReporter>(), options);
        }
        if ((variables = frame.getVariables()).size() > 0) {
            void var9_13;
            for (IDebugVariable iDebugVariable : variables) {
                sb.append("DECLARE ").append(iDebugVariable.getName()).append(" ").append(iDebugVariable.getType()).append(";").append(System.lineSeparator());
            }
            sb.append("SELECT ");
            boolean bl = false;
            while (var9_13 < variables.size()) {
                var = variables.get((int)var9_13);
                if (var9_13 > 0) {
                    sb.append(",");
                }
                sb.append(var.getName()).append(" = ").append("[").append(var.getName()).append("]");
                ++var9_13;
            }
            sb.append(" FROM ").append(this.tableName).append(";").append(System.lineSeparator());
        }
        sb.append(text);
        if (variables.size() + extraVars.size() > 0) {
            void var9_16;
            sb.append(";").append("UPDATE ").append(this.tableName).append(" SET ");
            output.append("SELECT ");
            boolean bl = false;
            while (var9_16 < variables.size() + extraVars.size()) {
                var = var9_16 >= variables.size() ? extraVars.get((int)(var9_16 - variables.size())) : variables.get((int)var9_16);
                if (var9_16 > 0) {
                    output.append(",");
                    sb.append(",");
                }
                output.append("[").append(var.getName()).append("]");
                sb.append("[").append(var.getName()).append("] = ").append(var.getName());
                ++var9_16;
            }
            output.append(" FROM ").append(this.tableName).append(";").append(System.lineSeparator());
        }
        final SQLOptions sQLOptions = new SQLOptions();
        this.runner.runScript(new StringReader(sb.toString()), this.debugContext.getSQLReporters(), sQLOptions);
        if (output.length() > 0) {
            this.runner.runScript(new StringReader(output.toString()), Arrays.asList(new ProgressReportedAdaptor(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void reportScriptFinished(String command, Statement s, boolean result) {
                    loopcount = 0;
                    block9: while (true) {
                        while (true) lbl-1000:
                        // 5 sources

                        {
                            if (loopcount > 0) {
                                result = s.getMoreResults();
                            }
                            ++loopcount;
                            if (result) {
                                rs = s.getResultSet();
                                try {
                                    var7_8 = null;
                                    var8_11 = null;
                                    try {
                                        rstm = new ResultSetTableModel(rs, sQLOptions);
                                        try {
                                            dl = new DoubleIndexedList<IDebugVariable>(Streams.concat((Stream[])new Stream[]{variables.stream(), extraVars.stream()}).collect(Collectors.toList()), (Function<IDebugVariable, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$0(com.sigge.filerunner.sql.run.IDebugVariable ), (Lcom/sigge/filerunner/sql/run/IDebugVariable;)Ljava/lang/String;)(), false);
                                            i = 0;
                                            while (true) {
                                                if (i >= rstm.getColumnCount()) ** GOTO lbl-1000
                                                column = rstm.getColumnName(i);
                                                dl.get(column).setValue(rstm.getValueAt(0, i));
                                                ++i;
                                            }
                                        }
                                        finally {
                                            if (rstm == null) continue block9;
                                            rstm.close();
                                        }
                                    }
                                    catch (Throwable var8_12) {
                                        if (var7_8 == null) {
                                            var7_8 = var8_12;
                                        } else if (var7_8 != var8_12) {
                                            var7_8.addSuppressed(var8_12);
                                        }
                                        throw var7_8;
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                continue;
                            }
                            updateCount = s.getUpdateCount();
                            if (updateCount != -1) {
                                s.clearWarnings();
                                continue;
                            }
                            break;
                        }
                        break;
                    }
                    catch (Exception var6_7) {
                        // empty catch block
                    }
                }

                @Override
                public void reportScriptFailure(String command, Statement s, Exception e, boolean result) {
                }

                private static /* synthetic */ String lambda$0(IDebugVariable f) {
                    return f.getName();
                }
            }), options);
        }
        Frame frame2 = new Frame(frame.getScope(), clause, frame);
        frame2.vars.addAll(variables);
        frame2.vars.addAll(extraVars);
        return frame2;
    }

    private List<? extends IDebugVariable> appendVariables(Clause clause, IFrame frame) {
        ArrayList<DebugVariable> variables = new ArrayList<DebugVariable>();
        if (clause instanceof Declare) {
            Declare dec = (Declare)clause;
            for (DeclareBlock d : dec.block) {
                if (d.variableToken == null || d.type == null || d.declareType == DeclareType.TABLE) continue;
                DebugVariable db = new DebugVariable(d.getVariable(), d.type);
                variables.add(db);
            }
        }
        return variables;
    }
}

