/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.queryplan;

import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.sql.sqlserver.queryplan.QueryPlanStats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryPlanStatHandler {
    private final Map<Integer, List<QueryPlanStats>> mapList = new HashMap<Integer, List<QueryPlanStats>>();

    public QueryPlanStatHandler(List<QueryPlanStats> stats) {
        for (QueryPlanStats qp : stats) {
            Integer nodeId = qp.getNodeId();
            if (nodeId == null) break;
            this.mapList.computeIfAbsent(nodeId, n -> new ArrayList()).add(qp);
        }
    }

    public List<QueryPlanStats> getListStats(Integer nodeId) {
        return this.mapList.getOrDefault(nodeId, Collections.EMPTY_LIST);
    }

    public String getStatsFromId(Integer nodeId) {
        List<QueryPlanStats> l = this.getListStats(nodeId);
        Long rowCount = 0L;
        Long estimatedCount = 0L;
        Long elapsedTime = Long.MAX_VALUE;
        for (QueryPlanStats s : l) {
            Long elapsed;
            Long rows = s.getRow_count();
            Long estimated = s.getEstimate_row_count();
            if (rows != null) {
                rowCount = rowCount + rows;
            }
            if (estimated != null) {
                estimatedCount = estimatedCount + estimated;
            }
            if ((elapsed = s.getElapsed_time_ms()) == null || elapsed >= elapsedTime) continue;
            elapsedTime = elapsed;
        }
        StringBuilder sb = new StringBuilder();
        if (!elapsedTime.equals(Long.MAX_VALUE)) {
            sb.append("\n").append(DateUtils.getDuration(elapsedTime.intValue()));
        }
        if (l.size() > 0) {
            sb.append("\n").append("Rows: ").append(rowCount).append(" of ").append(estimatedCount);
        }
        return sb.toString();
    }
}

