/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.queryplan;

import com.sigge.filerunner.sql.sqlserver.queryplan.Attribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class Node
implements Serializable {
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final List<Node> nodes = new ArrayList<Node>();
    private final List<Node> transientNodes = new ArrayList<Node>();
    private String name;
    private String value;

    public Node() {
    }

    public Node(String name) {
        this.name = name;
    }

    public Node(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public void addNodes(Collection<Node> node) {
        this.nodes.addAll(node);
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public String getAttributeValue(String attributeName) {
        for (Attribute a : this.attributes) {
            if (!a.getName().equals(attributeName)) continue;
            return a.getValue();
        }
        return null;
    }

    public Optional<Node> getNode(String nodeName) {
        for (Node n : this.nodes) {
            if (!n.getName().equals(nodeName)) continue;
            return Optional.of(n);
        }
        return Optional.empty();
    }

    public List<Node> getNodes(String nodeName) {
        ArrayList<Node> retNodes = new ArrayList<Node>();
        for (Node n : this.nodes) {
            if (!n.getName().equals(nodeName)) continue;
            retNodes.add(n);
        }
        return retNodes;
    }

    public Optional<Node> getFirstNode(String ... nodes) {
        String[] stringArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            String node = stringArray[n2];
            Optional<Node> n3 = this.getNode(node);
            if (n3.isPresent()) {
                return n3;
            }
            ++n2;
        }
        return Optional.empty();
    }

    public Optional<Node> getTransientNode(String nodeName) {
        for (Node n : this.transientNodes) {
            if (!n.getName().equals(nodeName)) continue;
            return Optional.of(n);
        }
        return Optional.empty();
    }

    public NodeTraverser getTraversalNode(String nodeName) {
        return new NodeTraverser(this.getTransientNode(nodeName));
    }

    public Optional<Node> getFirstTransientNode(String ... nodeNames) {
        String[] stringArray = nodeNames;
        int n = nodeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String nodeName = stringArray[n2];
            Optional<Node> v = this.getTransientNode(nodeName);
            if (v.isPresent()) {
                return v;
            }
            ++n2;
        }
        return Optional.empty();
    }

    public Node copyWithAttributes() {
        Node nx = new Node(this.name, this.value);
        nx.attributes.addAll(new ArrayList<Attribute>(this.attributes));
        nx.transientNodes.addAll(new ArrayList<Node>(this.nodes));
        return nx;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return "[Name=" + this.name + ", value=" + this.value + ", nodes=" + (this.transientNodes.size() > 0 ? this.transientNodes : this.nodes) + ", attributes=" + this.attributes + "]";
    }

    public List<Node> getTransientNodes() {
        return this.transientNodes;
    }

    public static class NodeTraverser {
        private Optional<Node> currentNode;

        public NodeTraverser(Optional<Node> startNode) {
            this.currentNode = startNode;
        }

        public NodeTraverser getNode(String ... nodeNames) {
            String[] stringArray = nodeNames;
            int n = nodeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeName = stringArray[n2];
                if (this.currentNode.isPresent()) {
                    this.currentNode = this.currentNode.get().getNode(nodeName);
                }
                ++n2;
            }
            return this;
        }

        public void ifExists(Consumer<Node> consumer) {
            this.currentNode.ifPresent(consumer);
        }

        public Optional<Node> getNode() {
            return this.currentNode;
        }
    }
}

