/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.schedule.view;

import com.sigge.filerunner.sql.sqlserver.jobs.schedule.IScheduleBinder;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.MonthlySchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.RelativeFrequency;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.SQLServerSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.TimePeriod;
import com.siggemannen.binding.Binder;
import com.siggemannen.binding.ValueHolder;
import com.siggemannen.core.ListUtils;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MonthlySchedulePanel
extends JPanel
implements IScheduleBinder {
    private SQLServerSchedule schedule;
    private Binder.Presenter<Object> monthlyType;
    private Binder.Presenter<TimePeriod> monthlyDayBinder;

    public MonthlySchedulePanel() {
        super(new FlowLayout());
        List<TimePeriod> listOfDays = Arrays.asList(TimePeriod.MONDAY, TimePeriod.TUESDAY, TimePeriod.WEDNESDAY, TimePeriod.THURSDAY, TimePeriod.FRIDAY, TimePeriod.SATURDAY, TimePeriod.SUNDAY);
        this.add(new JLabel("On: "));
        JComboBox monthlyTypes = new JComboBox();
        this.add(monthlyTypes);
        JLabel labelDay = new JLabel(" day");
        JComboBox monthlyDay = new JComboBox();
        this.monthlyDayBinder = Binder.bindToCombo(monthlyDay, (List)ListUtils.append(listOfDays, (Object[])new TimePeriod[]{TimePeriod.DAY, TimePeriod.WEEK_DAY, TimePeriod.WEEKEND_DAY})).addValueChangedListener(v -> {
            if (this.schedule != null) {
                this.schedule.getRecurringSchedule().getMonthySchedule().setTimeOfMonth((TimePeriod)((Object)v));
            }
        }, true);
        JPanel monthlySubSubType = new JPanel();
        this.add(monthlySubSubType);
        ArrayList values = new ArrayList();
        values.addAll(Arrays.stream(RelativeFrequency.values()).collect(Collectors.toList()));
        values.addAll(IntStream.range(1, 32).mapToObj(ex -> ex).collect(Collectors.toList()));
        this.monthlyType = Binder.bindToCombo(monthlyTypes, values).addValueChangedListener(value -> {
            monthlySubSubType.removeAll();
            if (this.schedule != null) {
                this.schedule.getRecurringSchedule().getMonthySchedule().setRecurrencyType(value);
                if (value instanceof Integer) {
                    this.schedule.getRecurringSchedule().getMonthySchedule().setTimeOfMonth(TimePeriod.DAY);
                }
            }
            if (value instanceof RelativeFrequency) {
                monthlySubSubType.add(monthlyDay);
            } else {
                monthlySubSubType.add(labelDay);
            }
            monthlySubSubType.revalidate();
        }, true);
    }

    @Override
    public void bind(SQLServerSchedule initial) {
        this.schedule = initial;
        MonthlySchedule monthySchedule = initial.getRecurringSchedule().getMonthySchedule();
        if (monthySchedule == null) {
            monthySchedule = new MonthlySchedule();
            initial.getRecurringSchedule().setMonthySchedule(monthySchedule);
            monthySchedule.setTimeOfMonth(TimePeriod.DAY);
            monthySchedule.setRecurrencyType(1);
        }
        this.monthlyDayBinder.setObject((Object)new ValueHolder((Object)(monthySchedule.getTimeOfMonth() != null ? monthySchedule.getTimeOfMonth() : TimePeriod.DAY)));
        this.monthlyType.setObject((Object)new ValueHolder(monthySchedule.getRecurrencyType() != null ? monthySchedule.getRecurrencyType() : Integer.valueOf(1)));
    }
}

