/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.schedule;

import com.sigge.filerunner.core.ICopyable;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.DailyRecurringTimeSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.OneTimeSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.RecurringSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.RelativeFrequency;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.ScheduleType;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.TimePeriod;
import com.sigge.filerunner.view.jobs.ICommand;
import com.sigge.filerunner.view.jobs.IJobSchedule;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.stream.Collectors;

public class SQLServerSchedule
implements IJobSchedule,
ICopyable<SQLServerSchedule> {
    private boolean enabled = true;
    private ScheduleType scheduleType;
    private OneTimeSchedule oneTimeSchedule;
    private RecurringSchedule recurringSchedule;
    private int scheduleId;
    private String scheduleName;
    private String scheduleGUID;

    @Override
    public SQLServerSchedule createCopy() {
        SQLServerSchedule copy = new SQLServerSchedule();
        copy.enabled = this.enabled;
        copy.scheduleType = this.scheduleType;
        copy.oneTimeSchedule = this.oneTimeSchedule != null ? this.oneTimeSchedule.createCopy() : null;
        copy.recurringSchedule = this.recurringSchedule != null ? this.recurringSchedule.createCopy() : null;
        copy.scheduleId = this.scheduleId;
        copy.scheduleName = this.scheduleName;
        copy.scheduleGUID = this.scheduleGUID;
        return copy;
    }

    public int getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(int scheduleId) {
        this.scheduleId = scheduleId;
    }

    public String getScheduleName() {
        return this.scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public OneTimeSchedule getOneTimeSchedule() {
        return this.oneTimeSchedule;
    }

    public void setOneTimeSchedule(OneTimeSchedule oneTimeSchedule) {
        this.oneTimeSchedule = oneTimeSchedule;
    }

    public RecurringSchedule getRecurringSchedule() {
        return this.recurringSchedule;
    }

    public void setRecurringSchedule(RecurringSchedule recurringSchedule) {
        this.recurringSchedule = recurringSchedule;
    }

    @Override
    public void execute(ICommand command) {
    }

    @Override
    public boolean supports(ICommand command) {
        return false;
    }

    @Override
    public String getScheduleString() {
        StringBuilder sb = new StringBuilder();
        if (this.scheduleType != ScheduleType.FLUENT) {
            sb.append((Object)this.scheduleType);
        }
        if (this.scheduleType == ScheduleType.ONE_TIME) {
            sb.append(" at: ").append(this.oneTimeSchedule.getDate()).append(" ").append(this.oneTimeSchedule.getTime());
        } else if (this.scheduleType == ScheduleType.FLUENT) {
            sb.append("Every: ").append(this.recurringSchedule.getEveryNth()).append(" ").append((Object)this.recurringSchedule.getScheduleType());
            switch (this.recurringSchedule.getScheduleType()) {
                case DAY: {
                    break;
                }
                case WEEK: {
                    if (this.recurringSchedule.getWeeklySchedule().getTimePeriod() instanceof TimePeriod) {
                        sb.append(" ON ").append(this.recurringSchedule.getWeeklySchedule().getTimePeriod());
                        break;
                    }
                    sb.append(" ON ").append(String.join((CharSequence)",", this.recurringSchedule.getWeeklySchedule().getWeekDays().stream().map(Enum::toString).collect(Collectors.toList())));
                    break;
                }
                case MONTH: {
                    sb.append(" ON ").append(this.recurringSchedule.getMonthySchedule().getRecurrencyType()).append(" ").append((Object)this.recurringSchedule.getMonthySchedule().getTimeOfMonth());
                    break;
                }
            }
            switch (this.recurringSchedule.getDailySubType()) {
                case EVERY_NTH: {
                    DailyRecurringTimeSchedule dailyRecurringTimeSchedule = this.recurringSchedule.getDailyRecurringTimeSchedule();
                    sb.append(" every ").append(dailyRecurringTimeSchedule.getEveryNth()).append(" ").append((Object)dailyRecurringTimeSchedule.getEveryNthType()).append(" between: ").append(dailyRecurringTimeSchedule.getStart()).append(" and ").append(dailyRecurringTimeSchedule.getEnd());
                    break;
                }
                case ONE_TIME: {
                    sb.append(" at ").append(this.recurringSchedule.getDailyOneTimeSchedule().getTime());
                }
            }
        }
        return sb.toString();
    }

    @Override
    public LocalDateTime getNextRun() {
        return null;
    }

    @Override
    public LocalDateTime getLastRun() {
        return null;
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public void setScheduleType(ScheduleType scheduleType) {
        this.scheduleType = scheduleType;
    }

    public String getScheduleGUID() {
        return this.scheduleGUID;
    }

    public void setScheduleGUID(String scheduleGUID) {
        this.scheduleGUID = scheduleGUID;
    }

    public ScheduleToSQL getSQLValues() {
        ScheduleToSQL sql = new ScheduleToSQL();
        switch (this.scheduleType) {
            case ON_IDLE: {
                sql.freq_type = 128;
                break;
            }
            case ON_START: {
                sql.freq_type = 64;
                break;
            }
            case ONE_TIME: {
                sql.freq_type = 1;
                sql.active_start_date = SQLServerSchedule.getIntFromDate(this.oneTimeSchedule.getDate());
                sql.active_start_time = SQLServerSchedule.getIntFromTime(this.oneTimeSchedule.getTime());
                break;
            }
            case FLUENT: {
                switch (this.recurringSchedule.getScheduleType()) {
                    case DAY: {
                        sql.freq_type = 4;
                        sql.freq_interval = this.recurringSchedule.getEveryNth();
                        break;
                    }
                    case WEEK: {
                        sql.freq_type = 8;
                        sql.freq_interval = this.recurringSchedule.getWeeklySchedule().getFreqInterval();
                        sql.freq_recurrence_factor = this.recurringSchedule.getEveryNth();
                        break;
                    }
                    case MONTH: {
                        sql.freq_type = this.recurringSchedule.getMonthySchedule().getRecurrencyType() instanceof RelativeFrequency ? 32 : 16;
                        sql.freq_recurrence_factor = this.recurringSchedule.getEveryNth();
                        if (sql.freq_type == 16) {
                            sql.freq_interval = (Integer)this.recurringSchedule.getMonthySchedule().getRecurrencyType();
                            break;
                        }
                        sql.freq_relative_interval = ((RelativeFrequency)((Object)this.recurringSchedule.getMonthySchedule().getRecurrencyType())).getFromRelativeFrequency();
                        sql.freq_interval = Arrays.asList(TimePeriod.SUNDAY, TimePeriod.MONDAY, TimePeriod.TUESDAY, TimePeriod.WEDNESDAY, TimePeriod.THURSDAY, TimePeriod.FRIDAY, TimePeriod.SATURDAY, TimePeriod.DAY, TimePeriod.WEEK, TimePeriod.WEEKEND_DAY).indexOf((Object)this.recurringSchedule.getMonthySchedule().getTimeOfMonth()) + 1;
                        break;
                    }
                }
                sql.active_start_date = SQLServerSchedule.getIntFromDate(this.recurringSchedule.getStartDate());
                sql.active_end_date = this.recurringSchedule.isEnding() ? SQLServerSchedule.getIntFromDate(this.recurringSchedule.getEndDate()) : 99991231;
                switch (this.recurringSchedule.getDailySubType()) {
                    case ONE_TIME: {
                        sql.freq_subday_type = 1;
                        sql.active_start_time = SQLServerSchedule.getIntFromTime(this.recurringSchedule.getDailyOneTimeSchedule().getTime());
                        break;
                    }
                    case EVERY_NTH: {
                        switch (this.recurringSchedule.getDailyRecurringTimeSchedule().getEveryNthType()) {
                            case SECOND: {
                                sql.freq_subday_type = 2;
                                break;
                            }
                            case MINUTE: {
                                sql.freq_subday_type = 4;
                                break;
                            }
                            case HOUR: {
                                sql.freq_subday_type = 8;
                                break;
                            }
                        }
                        sql.freq_subday_interval = this.recurringSchedule.getDailyRecurringTimeSchedule().getEveryNth();
                        sql.active_start_time = SQLServerSchedule.getIntFromTime(this.recurringSchedule.getDailyRecurringTimeSchedule().getStart());
                        sql.active_end_time = SQLServerSchedule.getIntFromTime(this.recurringSchedule.getDailyRecurringTimeSchedule().getEnd());
                    }
                }
                break;
            }
        }
        return sql;
    }

    public static LocalTime getTimeFromInt(int time) {
        return LocalTime.of(time / 100 / 100, time / 100 % 100, time % 100);
    }

    public static LocalDate getDateFromInt(int date) {
        return LocalDate.of(date / 100 / 100, date / 100 % 100, date % 100);
    }

    public static int getIntFromDate(LocalDate ld) {
        return ld.getYear() * 10000 + ld.getMonthValue() * 100 + ld.getDayOfMonth();
    }

    public static int getIntFromTime(LocalTime lt) {
        return lt.getHour() * 10000 + lt.getMinute() * 100 + lt.getSecond();
    }

    public static class ScheduleToSQL {
        public Integer freq_type = 0;
        public Integer freq_interval = 1;
        public Integer freq_subday_type = 0;
        public Integer freq_subday_interval = 0;
        public Integer freq_relative_interval = 0;
        public Integer freq_recurrence_factor = 1;
        public Integer active_start_date = 0;
        public Integer active_end_date = 99991231;
        public Integer active_start_time = 0;
        public Integer active_end_time = 235959;
    }
}

