/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.commands;

import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.sql.SQLBuilder;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.sqlserver.SQLScriptBuilder;
import com.sigge.filerunner.sql.sqlserver.jobs.CommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.ICommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerJob;
import com.sigge.filerunner.sql.sqlserver.jobs.commands.AJobCommand;
import com.sigge.filerunner.sql.sqlserver.jobs.schedule.SQLServerSchedule;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.SQLServerJobStep;
import com.sigge.filerunner.view.activity.SQLRunner;
import com.sigge.filerunner.view.jobs.IJobObject;
import com.sigge.filerunner.view.jobs.IJobStep;
import com.siggemannen.functional.throwing.ThrowingBiConsumer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class SaveCommand
extends AJobCommand {
    private static final String SAVE_JOB_COMMAND = SaveCommand.readQueryString("sqlserver_job_save.sql");
    private static final String SAVE_JOBSTEP_COMMAND = SaveCommand.readQueryString("sqlserver_jobstep_save.sql");
    private static final String SAVE_JOB_END_COMMAND = SaveCommand.readQueryString("sqlserver_job_end.sql");
    private static final String SCHEDULE_START = SaveCommand.readQueryString("sqlserver_schedule_start.sql");
    private static final String SCHEDULE_END = SaveCommand.readQueryString("sqlserver_schedule_end.sql");
    private static final String SCHEDULE_ADD = SaveCommand.readQueryString("sqlserver_schedule_add.sql");
    private static final String SCHEDULE_UPDATE = SaveCommand.readQueryString("sqlserver_schedule_update.sql");
    private static final String SCHEDULE_DETACH = SaveCommand.readQueryString("sqlserver_schedule_detach.sql");
    private static final String SCHEDULE_ATTACH = SaveCommand.readQueryString("sqlserver_schedule_attach.sql");

    public ICommandResult<IJobObject> execute(Database serverDatabase, IJobObject objects) {
        return this.execute(serverDatabase, Arrays.asList(objects));
    }

    /*
     * WARNING - void declaration
     */
    public ICommandResult<IJobObject> execute(Database serverDatabase, List<IJobObject> objects) {
        CommandResult result = new CommandResult();
        for (IJobObject job : objects) {
            void var8_20;
            SQLServerSchedule schedule;
            void var8_18;
            SQLOptions options;
            SQLRunner runner;
            Iterator<IJobStep> iterator;
            SQLServerJob sqlServerJob = (SQLServerJob)job;
            SQLBuilder sb = new SQLBuilder();
            sb.append(SAVE_JOB_COMMAND);
            for (IJobStep iJobStep : sqlServerJob.getSteps()) {
                sb.append(SAVE_JOBSTEP_COMMAND);
            }
            sb.append(SAVE_JOB_END_COMMAND);
            try {
                Throwable throwable = null;
                iterator = null;
                try {
                    runner = new SQLRunner(new ServerDatabase(serverDatabase, "msdb"), sb.build());
                    try {
                        options = new SQLOptions.Builder().parseOnly(false).rollbackAllUncommitedTransactions(true).prepareStatement((ThrowingBiConsumer<Integer, PreparedStatement>)((ThrowingBiConsumer)(statementId, ps) -> {
                            int param = 1;
                            ps.setString(param++, sqlServerJob.getNativeId());
                            int i = 0;
                            while (i < 2) {
                                ps.setString(param++, sqlServerJob.getName());
                                ps.setBoolean(param++, sqlServerJob.isEnabled());
                                ps.setInt(param++, sqlServerJob.getStartStepId());
                                ++i;
                            }
                            int maxStepId = 0;
                            for (IJobStep jstep : sqlServerJob.getSteps()) {
                                SQLServerJobStep step = (SQLServerJobStep)jstep;
                                step.normalize();
                                maxStepId = step.getStepNumber() > maxStepId ? step.getStepNumber() : maxStepId;
                                param = this.setParameter(sqlServerJob, (PreparedStatement)ps, param, step, false);
                            }
                            for (SQLServerJobStep step : sqlServerJob.getJobStepsRemoved().stream().sorted(Comparator.comparing(SQLServerJobStep::getStepNumber)).collect(Collectors.toList())) {
                                if (step.getStepNumber() <= maxStepId) continue;
                                param = this.setParameter(sqlServerJob, (PreparedStatement)ps, param, step, true);
                            }
                        })).build();
                        runner.runQuery((rs, count) -> {
                            try {
                                if (rs.next()) {
                                    String jobUID = rs.getString("jobId");
                                    int returnValue = rs.getInt("retval");
                                    if (rs.wasNull()) {
                                        result.addFailureResult(job, "Retval null, something wrong when fetching result", null);
                                    } else if (returnValue != 0) {
                                        result.addFailureResult(job, "Job save failed with error code:" + returnValue, null);
                                    } else {
                                        sqlServerJob.setNativeId(jobUID);
                                        result.addOkResult(job);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                result.addFailureResult(job, "Failed while fetching job save status", ex);
                            }
                        }, ex -> {
                            ex.printStackTrace();
                            result.addFailureResult(job, "Failed while executing job save", (Exception)ex);
                        }, options);
                    }
                    finally {
                        if (runner != null) {
                            runner.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    void var8_14;
                    if (throwable == null) {
                        Throwable throwable3 = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw var8_14;
                }
            }
            catch (Exception exception) {
                result.addFailureResult(job, "Failed while setting up job runner", exception);
            }
            sb = new SQLBuilder();
            if (sqlServerJob.getSchedules().size() <= 0 && sqlServerJob.getSchedules_removed().size() <= 0) continue;
            sb.append(SCHEDULE_START);
            boolean bl = false;
            while (var8_18 < sqlServerJob.getSchedules().size()) {
                schedule = (SQLServerSchedule)sqlServerJob.getSchedules().get((int)var8_18);
                this.setParameters(sb, sqlServerJob, schedule);
                sb.append(new SQLScriptBuilder(SCHEDULE_ATTACH).addRaw("@schedule_job_id").addRaw("@schedule_id").build());
                ++var8_18;
            }
            boolean bl2 = false;
            while (var8_20 < sqlServerJob.getSchedules_removed().size()) {
                schedule = sqlServerJob.getSchedules_removed().get((int)var8_20);
                sb.append(new SQLScriptBuilder(SCHEDULE_DETACH).add(sqlServerJob.getNativeId()).add(schedule.getScheduleId()).build());
                ++var8_20;
            }
            sb.append(SCHEDULE_END);
            try {
                Throwable throwable = null;
                iterator = null;
                try {
                    runner = new SQLRunner(new ServerDatabase(serverDatabase, "msdb"), sb.build());
                    try {
                        options = new SQLOptions.Builder().parseOnly(false).rollbackAllUncommitedTransactions(true).build();
                        runner.runQuery((rs, count) -> {
                            try {
                                if (rs.next()) {
                                    int returnValue = rs.getInt("retval");
                                    if (rs.wasNull()) {
                                        result.addFailureResult(job, "Retval null, something wrong when fetching result", null);
                                    } else if (returnValue != 0) {
                                        result.addFailureResult(job, "Job save failed with error code:" + returnValue, null);
                                    } else {
                                        result.addOkResult(job);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                result.addFailureResult(job, "Failed while fetching job schedule status", ex);
                            }
                        }, ex -> {
                            ex.printStackTrace();
                            result.addFailureResult(job, "Failed while executing job schedule save", (Exception)ex);
                        }, options);
                    }
                    finally {
                        if (runner != null) {
                            runner.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    void var8_24;
                    if (throwable == null) {
                        Throwable throwable5 = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw var8_24;
                }
            }
            catch (Exception exception) {
                result.addFailureResult(job, "Failed while setting up job schedule runner", exception);
            }
        }
        return result;
    }

    private void setParameters(SQLBuilder sb, SQLServerJob sqlServerJob, SQLServerSchedule schedule) {
        SQLScriptBuilder builder = new SQLScriptBuilder(schedule.getScheduleGUID() != null ? SCHEDULE_UPDATE : SCHEDULE_ADD);
        builder.add(sqlServerJob.getNativeId()).add(schedule.getScheduleGUID() == null ? null : Integer.valueOf(schedule.getScheduleId())).add(schedule.getScheduleName()).add(schedule.isEnabled());
        SQLServerSchedule.ScheduleToSQL sql_values = schedule.getSQLValues();
        builder.add(sql_values.freq_type).add(sql_values.freq_interval).add(sql_values.freq_subday_type).add(sql_values.freq_subday_interval).add(sql_values.freq_relative_interval).add(sql_values.freq_recurrence_factor).add(sql_values.active_start_date).add(sql_values.active_end_date).add(sql_values.active_start_time).add(sql_values.active_end_time);
        sb.append(builder.build());
    }

    private int setParameter(SQLServerJob sqlServerJob, PreparedStatement ps, int param, SQLServerJobStep step, boolean deleted) throws SQLException {
        ps.setInt(param++, step.getStepNumber());
        ps.setInt(param++, deleted ? 0 : (sqlServerJob.isStepRemapped() ? 1 : (step.getStepId() != null ? 3 : 2)));
        int i = 0;
        while (i < 2) {
            ps.setString(param++, step.getStepName());
            ps.setInt(param++, step.getOnSuccess().getType().getType());
            ps.setInt(param++, step.getOnSuccess().getStepTo());
            ps.setInt(param++, step.getOnFailure().getType().getType());
            ps.setInt(param++, step.getOnFailure().getStepTo());
            ps.setInt(param++, step.getRetryAttempts());
            ps.setInt(param++, step.getRetryInterval());
            ps.setString(param++, step.getSubsystem().getName());
            ps.setString(param++, step.getCommand());
            ps.setInt(param++, step.getFlags());
            ps.setString(param++, step.getDatabase());
            ps.setString(param++, step.getUserName());
            ps.setString(param++, step.getOutputFileName());
            ++i;
        }
        return param;
    }
}

