/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.commands;

import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.sqlserver.SQLServerDatabase;
import com.sigge.filerunner.core.DateUtils;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.ResultsetConsumer;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.sqlserver.jobs.CommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.ICommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerAgentJobServer;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerJob;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerJobHistory;
import com.sigge.filerunner.sql.sqlserver.jobs.commands.AJobCommand;
import com.sigge.filerunner.sql.sqlserver.jobs.steps.SQLServerJobResult;
import com.sigge.filerunner.view.activity.SQLRunner;
import com.sigge.filerunner.view.jobs.Cleanupable;
import com.sigge.filerunner.view.jobs.IJob;
import com.sigge.filerunner.view.jobs.IJobObject;
import com.sigge.filerunner.view.jobs.JobResultType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadCommand
extends AJobCommand
implements Cleanupable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadCommand.class);
    private final DateFormat FORMAT_WITH_TIME = new SimpleDateFormat("yyyyMMdd HHmmss");
    private static final String LOAD_JOB_COMMAND = LoadCommand.readQueryString("sqlserver_job_list.sql");
    private final SQLServerAgentJobServer server;
    private volatile SQLRunner runner;
    private final Database serverDatabase;
    private boolean executing = false;
    private volatile boolean cleaning = false;

    public LoadCommand(SQLServerAgentJobServer server, Database serverDatabase) {
        this.server = server;
        this.serverDatabase = serverDatabase;
        this.createRunner();
    }

    private void createRunner() {
        this.runner = new SQLRunner(new ServerDatabase(this.serverDatabase, "msdb"), LOAD_JOB_COMMAND);
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public synchronized ICommandResult<IJobObject> execute(final Consumer<List<IJob>> jobsConsumer) {
        this.executing = true;
        try {
            CommandResult result;
            block6: {
                if (this.runner == null) {
                    this.createRunner();
                }
                result = new CommandResult();
                try {
                    this.runner.runQuery(new ResultsetConsumer(){
                        private List<IJob> jobs;

                        @Override
                        public void consume0(ResultSet rs, int count) throws Throwable {
                            block5: {
                                try {
                                    if (count == 1) {
                                        this.jobs = LoadCommand.this.getJobs(LoadCommand.this.server, rs);
                                    } else if (count == 2) {
                                        LoadCommand.this.enrich(rs, this.jobs);
                                        jobsConsumer.accept(this.jobs);
                                    }
                                }
                                catch (Exception ex) {
                                    if (!LoadCommand.this.logException(ex, LOAD_JOB_COMMAND, true)) break block5;
                                    LOGGER.error("Error while getting data", (Throwable)ex);
                                }
                            }
                        }
                    }, ex -> {
                        if (this.logException((Exception)ex, LOAD_JOB_COMMAND, false)) {
                            LOGGER.error("Error while executing runner", (Throwable)ex);
                        }
                    });
                }
                catch (Exception ex2) {
                    if (!this.logException(ex2, LOAD_JOB_COMMAND, false)) break block6;
                    LOGGER.error("Error while setting up runner", (Throwable)ex2);
                }
            }
            CommandResult commandResult = result;
            return commandResult;
        }
        finally {
            this.executing = false;
        }
    }

    private void enrich(ResultSet rs, List<IJob> jobs) throws Exception {
        HashMap messageMap = new HashMap();
        jobs.forEach(c -> {
            SQLServerJob j = (SQLServerJob)c;
            messageMap.put(j.getNativeId(), j);
        });
        boolean hascurrentDate = false;
        int i = 0;
        while (i < rs.getMetaData().getColumnCount()) {
            String columnName = rs.getMetaData().getColumnName(i + 1);
            if (columnName.equalsIgnoreCase("currentDate")) {
                hascurrentDate = true;
                break;
            }
            ++i;
        }
        while (rs.next()) {
            Timestamp currentExecuting;
            String jobId = rs.getString("job_id");
            SQLServerJob matchingJob = (SQLServerJob)messageMap.get(jobId);
            if (matchingJob == null) continue;
            String message = rs.getString("message");
            Timestamp tsLastRun = rs.getTimestamp("start_execution_date");
            Timestamp tsLastStopped = rs.getTimestamp("stop_execution_date");
            Timestamp timestamp = currentExecuting = hascurrentDate ? rs.getTimestamp("currentDate") : null;
            if (!matchingJob.getLastRun().isPresent()) continue;
            SQLServerJobHistory history = (SQLServerJobHistory)matchingJob.getLastRun().get();
            if (tsLastRun != null && StringUtils.isNotEmpty(message) && history.getResult() != null && history.getLastRun() != null && tsLastRun.toLocalDateTime().equals(history.getLastRun())) {
                ((SQLServerJobResult)history.getResult()).setMessage(message);
            }
            history.setLastRunFinished(tsLastStopped != null ? tsLastStopped.toLocalDateTime() : null);
            if (tsLastRun != null) {
                history.setLastRun(tsLastRun.toLocalDateTime());
            }
            history.setExecutionDurationInMs(DateUtils.getDuration(tsLastRun != null ? tsLastRun.toLocalDateTime() : null, tsLastStopped != null ? tsLastStopped.toLocalDateTime() : (currentExecuting != null ? currentExecuting.toLocalDateTime() : null)));
        }
    }

    private List<IJob> getJobs(SQLServerAgentJobServer server, ResultSet rs) throws Exception {
        ArrayList<IJob> jobs = new ArrayList<IJob>();
        while (rs.next()) {
            SQLServerJob job = new SQLServerJob(server);
            jobs.add(job);
            String jobId = rs.getString("job_id");
            job.setId(String.valueOf(SQLServerDatabase.PROVIDER_NAME) + "_" + server.getId() + "_" + jobId);
            job.setNativeId(jobId);
            job.setName(rs.getString("name"));
            job.setEnabled(rs.getInt("enabled") == 1);
            this.getLastRunFromJob(rs, job);
        }
        return jobs;
    }

    public static Timestamp getStampFromDateAndTime(ResultSet rs, String nameColumn, String timeColumn) {
        return LoadCommand.getStampFromDateAndTime(rs, nameColumn, timeColumn, new SimpleDateFormat("yyyyMMdd HHmmss"));
    }

    private static Timestamp getStampFromDateAndTime(ResultSet rs, String nameColumn, String timeColumn, DateFormat format) {
        try {
            Timestamp lastExec = null;
            Integer lastRunDate = rs.getInt(nameColumn);
            if (rs.wasNull() || lastRunDate.equals(0)) {
                lastRunDate = null;
            }
            Integer lastRunTime = rs.getInt(timeColumn);
            if (rs.wasNull()) {
                lastRunTime = 0;
            }
            if (lastRunDate != null && lastRunTime != null) {
                String dateTime = lastRunDate + " " + DateUtils.lpad("" + lastRunTime, 6);
                try {
                    Date date = format.parse(dateTime);
                    lastExec = Timestamp.from(date.toInstant());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return lastExec;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void getLastRunFromJob(ResultSet rs, SQLServerJob job) throws SQLException {
        SQLServerJobHistory history = new SQLServerJobHistory();
        Timestamp lastExec = LoadCommand.getStampFromDateAndTime(rs, "last_run_date", "last_run_time", this.FORMAT_WITH_TIME);
        Timestamp nextExec = LoadCommand.getStampFromDateAndTime(rs, "next_run_date", "next_run_time", this.FORMAT_WITH_TIME);
        history.setLastRun(lastExec != null ? lastExec.toLocalDateTime() : null);
        history.setNextRun(nextExec != null ? nextExec.toLocalDateTime() : null);
        SQLServerJobResult result = new SQLServerJobResult();
        result.setMessage("");
        JobResultType type = JobResultType.UNKNOWN;
        int currentStatus = rs.getInt("current_execution_status");
        if (currentStatus == 4) {
            switch (rs.getInt("last_run_outcome")) {
                case 0: {
                    type = rs.wasNull() ? JobResultType.NEVER_STARTED : JobResultType.FAILURE;
                    break;
                }
                case 1: {
                    type = JobResultType.SUCCESS;
                    break;
                }
                case 3: {
                    type = JobResultType.CANCELLED;
                    break;
                }
                default: {
                    type = JobResultType.UNKNOWN;
                    break;
                }
            }
        } else {
            type = JobResultType.RUNNING;
        }
        result.setResult(type);
        history.setResult(result);
        job.setLastRun(history);
    }

    @Override
    public void cleanup() {
        if (this.cleaning) {
            return;
        }
        this.cleaning = true;
        if (this.runner != null) {
            try {
                try {
                    this.runner.close();
                }
                catch (Exception exception) {
                    this.runner = null;
                }
            }
            finally {
                this.runner = null;
            }
        }
    }
}

