/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver.jobs.commands;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.sql.SQLBuilder;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.sql.sqlserver.SQLScriptBuilder;
import com.sigge.filerunner.sql.sqlserver.jobs.CommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.ICommandResult;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerJob;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerJobLog;
import com.sigge.filerunner.sql.sqlserver.jobs.commands.AJobCommand;
import com.sigge.filerunner.sql.sqlserver.jobs.commands.LoadCommand;
import com.sigge.filerunner.view.activity.SQLRunner;
import com.sigge.filerunner.view.jobs.IJobLogRecord;
import com.sigge.filerunner.view.jobs.IJobObject;
import com.sigge.filerunner.view.jobs.JobHistoryFilter;
import com.sigge.filerunner.view.jobs.JobHistoryParams;
import com.sigge.filerunner.view.jobs.JobResultType;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryCommand
extends AJobCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryCommand.class);
    private static final String LOAD_START = HistoryCommand.readQueryString("sqlserver_jobhistory_list_start.sql");
    private static final String LOAD_MAIN_QUERY = HistoryCommand.readQueryString("sqlserver_jobhistory_list.sql");

    public synchronized ICommandResult<IJobObject> execute(Database serverDatabase, List<IJobObject> history, JobHistoryParams params) {
        CommandResult result = new CommandResult();
        JobHistoryFilter filter = params.getFilter();
        Consumer<List<IJobLogRecord>> consumer = params.getCallback();
        SQLBuilder builder = new SQLBuilder(LOAD_START);
        int i2 = 0;
        while (i2 < history.size()) {
            builder.append(new SQLScriptBuilder(LOAD_MAIN_QUERY).add(((SQLServerJob)history.get(i2)).getNativeId()).build());
            ++i2;
        }
        try {
            Throwable i2 = null;
            Object var9_12 = null;
            try (SQLRunner runner = new SQLRunner(new ServerDatabase(serverDatabase, "msdb"), builder.build());){
                ArrayList historyRows = new ArrayList();
                runner.runQuery((rs, count) -> {
                    try {
                        if (count > history.size()) {
                            return;
                        }
                        SQLServerJob job = (SQLServerJob)history.get(count - 1);
                        SQLServerJobLog log = null;
                        while (rs.next()) {
                            int instanceId = rs.getInt("instance_id");
                            String jobId = rs.getString("job_id");
                            int stepId = rs.getInt("step_id");
                            String stepName = rs.getString("step_name");
                            String message = rs.getString("message");
                            int runStatus = rs.getInt("run_status");
                            int runDurationHHMMSS = rs.getInt("run_duration");
                            int runDuration = runDurationHHMMSS / 10000 * 3600 + runDurationHHMMSS % 10000 / 100 * 60 + runDurationHHMMSS % 100;
                            SQLServerJobLog logRecord = new SQLServerJobLog();
                            logRecord.setServer(job.getJobServer());
                            logRecord.setObject(job);
                            logRecord.setStepId(stepId);
                            logRecord.setStepName(stepName);
                            logRecord.setMessage(message);
                            Timestamp date = LoadCommand.getStampFromDateAndTime(rs, "run_date", "run_time");
                            logRecord.setLogDate(date == null ? null : date.toLocalDateTime());
                            logRecord.setDuration((long)runDuration * 1000L);
                            logRecord.setInstanceId(instanceId);
                            JobResultType jobresult = JobResultType.UNKNOWN;
                            switch (runStatus) {
                                case 0: {
                                    jobresult = JobResultType.FAILURE;
                                    break;
                                }
                                case 1: {
                                    jobresult = JobResultType.SUCCESS;
                                    break;
                                }
                                case 2: {
                                    jobresult = JobResultType.RUNNING;
                                    break;
                                }
                                case 3: {
                                    jobresult = JobResultType.CANCELLED;
                                    break;
                                }
                                case 4: {
                                    jobresult = JobResultType.RUNNING;
                                    break;
                                }
                            }
                            logRecord.setResult(jobresult);
                            if (stepId == 0) {
                                historyRows.add(logRecord);
                                log = logRecord;
                                continue;
                            }
                            if (log != null && jobId.equals(((SQLServerJob)log.getObject()).getNativeId())) {
                                log.getDetails().add(logRecord);
                                continue;
                            }
                            historyRows.add(logRecord);
                            log = null;
                        }
                        result.addOkResult((IJobObject)history.get(count - 1));
                    }
                    catch (Exception ex) {
                        result.addFailureResult((IJobObject)history.get(count - 1), "Failed while fetching job deleted status", ex);
                    }
                    consumer.accept(historyRows);
                }, ex -> result.addFailureResult((IJobObject)history.get(0), "Failed while executing job stop", (Exception)ex));
            }
            catch (Throwable throwable) {
                if (i2 == null) {
                    i2 = throwable;
                } else if (i2 != throwable) {
                    i2.addSuppressed(throwable);
                }
                throw i2;
            }
        }
        catch (Exception ex2) {
            result.addFailureResult(history.get(0), "Failed while setting up job runner", ex2);
        }
        return result;
    }
}

