/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.completion.domain.SQLSubObject;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.IServerContext;
import com.sigge.filerunner.sql.sqlserver.ClauseUtility;
import com.sigge.filerunner.sql.sqlserver.CreateColumn;
import com.sigge.filerunner.sql.sqlserver.CreateOrDeclareTableVisitor;
import com.sigge.filerunner.sql.sqlserver.CreateTable;
import com.sigge.filerunner.sql.sqlserver.SelectColumnsHolder;
import com.sigge.filerunner.sql.sqlserver.parser.Function;
import com.sigge.filerunner.sql.sqlserver.parser.Procedure;
import com.sigge.filerunner.sql.sqlserver.parser.Trigger;
import com.sigge.filerunner.sql.sqlserver.parser.View;
import com.sigge.filerunner.sql.transform.Clause;
import com.sigge.filerunner.sql.transform.Parameterized;
import com.sigge.filerunner.sql.transform.SQLFile;
import com.sigge.filerunner.sql.transform.Scope;
import com.sigge.filerunner.sql.transform.Statements;
import com.sigge.filerunner.sql.transform.declare.Declare;
import com.sigge.filerunner.sql.transform.declare.DeclareBlock;
import com.sigge.filerunner.sql.transform.dml.CTE;
import com.sigge.filerunner.sql.transform.dml.Cursor;
import com.sigge.filerunner.sql.transform.dml.DeleteQuery;
import com.sigge.filerunner.sql.transform.dml.InsertQuery;
import com.sigge.filerunner.sql.transform.dml.InsertSource;
import com.sigge.filerunner.sql.transform.dml.MergeQuery;
import com.sigge.filerunner.sql.transform.dml.SelectQuery;
import com.sigge.filerunner.sql.transform.dml.UnionExpression;
import com.sigge.filerunner.sql.transform.dml.UpdateQuery;
import com.sigge.filerunner.sql.transform.dml.WithCTE;
import com.sigge.filerunner.sql.transform.expression.Expression;
import com.sigge.filerunner.sql.transform.expression.SQLName;
import com.sigge.filerunner.sql.transform.expression.scalars.FunctionCall;
import com.sigge.filerunner.sql.transform.expression.scalars.VariableExpression;
import com.sigge.filerunner.sql.transform.parameter.ParameterBlock;
import com.sigge.filerunner.sql.transform.select.source.Alias;
import com.sigge.filerunner.sql.transform.select.source.DerivedTable;
import com.sigge.filerunner.sql.transform.select.source.JoinPart;
import com.sigge.filerunner.sql.transform.select.source.Source;
import com.sigge.filerunner.sql.transform.select.source.SourceType;
import com.sigge.filerunner.sql.transform.select.source.Table;
import com.sigge.filerunner.sql.transform.select.source.TableSource;
import com.sigge.filerunner.sql.transform.select.source.TableValues;
import com.sigge.filerunner.sql.transform.select.source.TableVariable;
import com.sigge.filerunner.sql.transform.select.source.join.JoinExpression;
import com.sigge.filerunner.sql.transform.select.source.join.MergeJoin;
import com.siggemannen.core.MapBuilder;
import com.siggemannen.core.Tuple;
import com.siggemannen.sql.antler.TSqlParser;
import com.siggemannen.sql.antler.TSqlParserBaseVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;

public class SQLServerSQLService {
    public static List<SQLObject> getDeclaredObjects(DatabaseContext dbcontext, SQLFile parseTree, int position) {
        Scope c = SQLServerSQLService.findCursorScope(parseTree, position);
        if (c == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList cl = new ArrayList();
        cl.addAll(ClauseUtility.getClauses(c, position, true, true, TSqlParser.Create_viewContext.class, TSqlParser.Create_or_alter_procedureContext.class, TSqlParser.Create_or_alter_functionContext.class).stream().map(Tuple::second).collect(Collectors.toList()));
        int id = Integer.MIN_VALUE;
        ArrayList<SQLObject> objects = new ArrayList<SQLObject>();
        for (ParserRuleContext cx : cl) {
            View v;
            SQLObject so;
            Statements pc;
            if (cx instanceof TSqlParser.Create_or_alter_procedureContext) {
                pc = new Procedure((TSqlParser.Create_or_alter_procedureContext)cx);
                if ((so = SQLServerSQLService.getObjectFromProc(dbcontext, (Parameterized)((Object)pc), SQLObjectType.STORED_PROCEDURE, id++)) == null) continue;
                objects.add(so);
                continue;
            }
            if (cx instanceof TSqlParser.Create_or_alter_functionContext) {
                pc = new Function((TSqlParser.Create_or_alter_functionContext)cx);
                so = SQLServerSQLService.getObjectFromProc(dbcontext, (Parameterized)((Object)pc), ((Function)pc).getType(), id++);
                if (so == null) continue;
                objects.add(so);
                continue;
            }
            if (!(cx instanceof TSqlParser.Create_viewContext) || (v = new View((TSqlParser.Create_viewContext)cx)).getName().getName() == null) continue;
            so = new SQLObject(dbcontext, id, SQLServerSQLService.getNormalizedIdentifier(dbcontext, v.getName().getName()), "U", SQLObjectType.TABLE, v.getName().getSchemaName() != null ? SQLServerSQLService.getNormalizedIdentifier(dbcontext, v.getName().getSchemaName()) : "", false);
            objects.add(so);
        }
        return objects;
    }

    private static SQLObject getObjectFromProc(DatabaseContext dbcontext, Parameterized t, SQLObjectType type, int id) {
        SQLName objectName = t.getName();
        if (objectName != null && objectName.getName() != null) {
            SQLObject so = new SQLObject(dbcontext, id, SQLServerSQLService.getNormalizedIdentifier(dbcontext, objectName.getName()), "", type, objectName.getSchemaName() != null ? SQLServerSQLService.getNormalizedIdentifier(dbcontext, objectName.getSchemaName()) : "", false);
            for (ParameterBlock cs : t.getParameters()) {
                if (cs == null || cs.getVariable() == null) continue;
                SQLSubObject sub = new SQLSubObject(SQLServerSQLService.getNormalizedIdentifier(dbcontext, cs.getVariable()), cs.type);
                so.addParameter(sub);
                if (cs.getDefaultValue() == null) continue;
                MapBuilder customProperties = new MapBuilder();
                customProperties.appendIfTrue((Object)"DEFAULT", (Object)cs.getDefaultValue()).appendIfNotNull((Object)"PARAMETER_OUTPUT", (Object)cs.isOutput());
                sub.setCustomProperties(customProperties.build());
            }
            return so;
        }
        return null;
    }

    public static List<SQLObject> getDeclaredTables(IServerContext serverContext, DatabaseContext dbcontext, SQLFile parseTree, int position) {
        List<SQLObject> objs;
        Trigger tr;
        CreateTable t;
        Scope c = SQLServerSQLService.findCursorScope(parseTree, position);
        if (c == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList cl = new ArrayList();
        cl.addAll(ClauseUtility.getClauses(c, position, true, true, TSqlParser.Create_tableContext.class).stream().map(Tuple::second).collect(Collectors.toList()));
        cl.addAll(ClauseUtility.getClauses(c, position, false, true, TSqlParser.Declare_statementContext.class, TSqlParser.Func_body_returns_tableContext.class).stream().map(Tuple::second).collect(Collectors.toList()));
        int id = Integer.MIN_VALUE;
        ArrayList<SQLObject> objects = new ArrayList<SQLObject>();
        for (ParserRuleContext cx : cl) {
            if (!(cx instanceof TSqlParser.Create_tableContext) && !(cx instanceof TSqlParser.Declare_statementContext) && !(cx instanceof TSqlParser.Func_body_returns_tableContext)) continue;
            List tl = (List)cx.accept((ParseTreeVisitor)new CreateOrDeclareTableVisitor(serverContext, dbcontext));
            Iterator<Object> iterator = tl.iterator();
            while (iterator.hasNext()) {
                t = (CreateTable)iterator.next();
                SQLObject sQLObject = SQLServerSQLService.getObjectFromCreateTable(dbcontext, t, id++);
                if (sQLObject == null) continue;
                objects.add(sQLObject);
            }
        }
        if (c instanceof Procedure) {
            List<ParameterBlock> pb = ((Procedure)c).getParameters();
            for (ParameterBlock b : pb) {
                List tl = (List)b.ctx.accept((ParseTreeVisitor)new CreateOrDeclareTableVisitor(serverContext, dbcontext));
                for (CreateTable t2 : tl) {
                    SQLObject so = SQLServerSQLService.getObjectFromCreateTable(dbcontext, t2, id++);
                    if (so == null) continue;
                    objects.add(so);
                }
            }
        }
        if (c instanceof Trigger && (tr = (Trigger)c).getType() == Trigger.TriggerType.DML && tr.getTriggerTarget() != null && tr.getAction().size() > 0 && (objs = serverContext.getByName(tr.getTriggerTarget().fullName(), dbcontext, SQLObjectType.TABLE)).size() > 0) {
            SQLObject ob = objs.get(0);
            for (Trigger.TriggerActionType action : tr.getAction()) {
                for (String string : action.getActionNames()) {
                    objects.add(new SQLObject(ob, true, string));
                }
            }
        }
        for (Clause s : ClauseUtility.getClauses(c, position, true, true, TSqlParser.Query_specificationContext.class, TSqlParser.Select_statement_standaloneContext.class, TSqlParser.Query_expressionContext.class).stream().map(Tuple::first).collect(Collectors.toList())) {
            SelectQuery sq;
            if (!(s instanceof SelectQuery) || (sq = (SelectQuery)s).getInto() == null) continue;
            t = new CreateTable();
            t.name = sq.getInto().getName();
            t.selectIntoQuery = sq;
            if (t.name == null) continue;
            objects.add(SQLServerSQLService.getObjectFromCreateTable(dbcontext, t, id++));
        }
        return objects;
    }

    private static SQLObject getObjectFromCreateTable(DatabaseContext dbcontext, CreateTable t, int id) {
        if (t.name != null && t.name.getName() != null) {
            SQLObject so = new SQLObject(dbcontext, id, SQLServerSQLService.getNormalizedIdentifier(dbcontext, t.name.getName()), "U", SQLObjectType.TABLE, t.name.getSchemaName() != null ? SQLServerSQLService.getNormalizedIdentifier(dbcontext, t.name.getSchemaName()) : "", false);
            for (CreateColumn cs : t.columns) {
                if (cs == null) continue;
                if (cs.getName() != null) {
                    SQLSubObject sub = new SQLSubObject(SQLServerSQLService.getNormalizedIdentifier(dbcontext, cs.getName().fullName()), cs.getType());
                    so.addColumn(sub);
                    MapBuilder customProperties = new MapBuilder();
                    if (cs.getComputedDef() != null) {
                        customProperties.appendIfTrue((Object)"COLUMN_PERSISTED", (Object)cs.isPersisted()).appendIfNotNull((Object)"COLUMN_COMPUTED", (Object)cs.getComputedDef());
                    }
                    if (cs.getNullable() != null && cs.getNullable().booleanValue()) {
                        customProperties.append((Object)"COLUMN_NULLABLE", (Object)true);
                    }
                    customProperties.appendIfTrue((Object)"COLUMN_IDENTITY", (Object)cs.isIdentity());
                    if (customProperties.size() <= 0) continue;
                    sub.setCustomProperties(customProperties.build());
                    continue;
                }
                if (cs.getSubObject() == null) continue;
                so.addColumn(cs.getSubObject());
            }
            if (t.selectIntoQuery != null) {
                if (so.getCustomProperties() == null) {
                    so.setCustomProperties(new HashMap<String, Object>());
                }
                so.getCustomProperties().put("query", t.selectIntoQuery);
            }
            return so;
        }
        return null;
    }

    private static String getNormalizedIdentifier(DatabaseContext dbcontext, String name) {
        return dbcontext != null ? dbcontext.getNormalizedIdentifier(name) : name;
    }

    public static Tuple<String, Integer> getParameterNumberForExec(TSqlParser.Execute_statement_argContext prx, int pos) {
        int temp = -1;
        int paramNumber = -1;
        String paramName = null;
        for (TSqlParser.Execute_statement_arg_named_or_unnamedContext pr : prx.execute_statement_arg_named_or_unnamed()) {
            ++temp;
            if (!ClauseUtility.contextWithinBounds((ParserRuleContext)pr, pos)) continue;
            paramNumber = temp;
            TSqlParser.Execute_statement_arg_namedContext named = pr.execute_statement_arg_named();
            TSqlParser.Execute_statement_arg_unnamedContext unnamed = pr.execute_statement_arg_unnamed();
            if (named != null) {
                paramName = named.name != null ? named.name.getText() : null;
                break;
            }
            if (unnamed == null) break;
            paramNumber = temp;
            break;
        }
        return Tuple.of(paramName, (Object)paramNumber);
    }

    public static List<TerminalNode> getVariableOccurences(SQLFile parseTree, final int position, final String name, final boolean all) {
        Scope c = SQLServerSQLService.findCursorScope(parseTree, position);
        if (c == null) {
            return Collections.EMPTY_LIST;
        }
        return (List)c.getContext().accept((ParseTreeVisitor)new TSqlParserBaseVisitor<List<TerminalNode>>(){
            final List<TerminalNode> params = new ArrayList<TerminalNode>();

            public List<TerminalNode> visitTerminal(TerminalNode node) {
                Token symbol = node.getSymbol();
                if (symbol != null && (all || symbol.getStopIndex() < position - 1) && symbol.getType() == 951 && node.getText().equalsIgnoreCase(name) && !(node.getParent().getPayload() instanceof TSqlParser.Execute_statement_arg_namedContext)) {
                    this.params.add(node);
                }
                return this.params;
            }
        });
    }

    public static List<DeclareBlock> getDeclaredVariables(SQLFile parseTree, int position) {
        Scope c = SQLServerSQLService.findCursorScope(parseTree, position);
        ArrayList<DeclareBlock> params = new ArrayList<DeclareBlock>();
        if (c == null) {
            return params;
        }
        if (c instanceof Parameterized) {
            Parameterized p = (Parameterized)((Object)c);
            ParserRuleContext prc = null;
            for (ParameterBlock pp : p.getParameters()) {
                prc = pp.ctx;
            }
            if (prc != null && ClauseUtility.matchesParam(prc, position)) {
                params.addAll(p.getParameters().stream().filter(f -> ClauseUtility.matchesParam(f.ctx, position)).collect(Collectors.toList()));
            }
        }
        ClauseUtility.walk(c, (cl, parent, level) -> {
            if (cl == null || !ClauseUtility.matchesParam2(cl.getContext(), position)) {
                return false;
            }
            if (cl instanceof Declare) {
                Declare db = (Declare)cl;
                for (DeclareBlock d : db.block) {
                    if (d.variableToken == null || d.variableToken.getStopIndex() >= position || d.variableToken.getStartIndex() >= position) continue;
                    params.add(d);
                }
            }
            return true;
        });
        return params;
    }

    public Optional<SelectColumnsHolder> createHolder(SelectQuery query) {
        SQLSelectListener w = new SQLSelectListener();
        w.parseSelectQuery(query, query.getCte());
        if (w.holder != null) {
            for (UnionExpression union : query.getUnionExpressions()) {
                if (union.getQuery() == null) continue;
                SQLSelectListener listener = new SQLSelectListener();
                listener.parseSelectQuery(union.getQuery(), query.getCte());
                if (listener.holder == null) continue;
                w.holder.addUnion(listener.holder);
            }
            return Optional.of(w.holder);
        }
        return Optional.empty();
    }

    public static Scope findCursorScope(SQLFile file, int position) {
        WalkerHolder s = new WalkerHolder();
        AtomicInteger ai = new AtomicInteger(-1);
        AtomicInteger endPosition = new AtomicInteger(-1);
        ClauseUtility.walk(file, (clause, parent, level) -> {
            if (!(clause instanceof Scope)) {
                return false;
            }
            int start = clause.getContext().start.getStartIndex();
            if (start <= position && (endPosition.get() == -1 || endPosition.get() >= position)) {
                s.h = (Scope)clause;
                ai.set((int)level);
                if (endPosition.get() > position) {
                    endPosition.set(clause.getContext().stop.getStopIndex());
                }
            } else if (ai.get() >= 0) {
                return false;
            }
            return true;
        });
        if (s.h == null) {
            return file;
        }
        return (Scope)s.h;
    }

    private SelectColumnsHolder getHolderFromSQ(SelectQuery cxx, int position) {
        SQLSelectListener w = new SQLSelectListener();
        if (cxx.getUnionExpressions().size() > 0) {
            int i = 0;
            while (i < cxx.getUnionExpressions().size()) {
                UnionExpression union = cxx.getUnionExpressions().get(i);
                if (ClauseUtility.contextBeforeBounds(union.getTreeAsContext(), position)) {
                    cxx = union.getQuery();
                }
                ++i;
            }
        }
        w.parseSelectQuery(cxx, cxx.getCte());
        for (UnionExpression union : cxx.getUnionExpressions()) {
            if (union.getQuery() == null) continue;
            SQLSelectListener listener = new SQLSelectListener();
            listener.parseSelectQuery(union.getQuery(), cxx.getCte());
            if (listener.holder == null) continue;
            w.holder.addUnion(listener.holder);
        }
        if (w.holder != null) {
            return w.holder;
        }
        return null;
    }

    public SelectColumnsHolder getHolderAtPosition(SQLFile parseTree, int position) {
        Clause cx = ClauseUtility.findNearestStatement(position - 1, parseTree);
        if (cx == null) {
            return null;
        }
        return this.getHolderAtPosition(cx, position);
    }

    public SelectColumnsHolder getHolderAtPosition(Clause cx, int position) {
        SQLSelectListener w = new SQLSelectListener();
        if (cx instanceof SelectQuery) {
            return this.getHolderFromSQ((SelectQuery)cx, position);
        }
        if (cx instanceof View) {
            View cx2 = (View)cx;
            if (cx2.getQuery() == null) {
                return null;
            }
            return this.getHolderFromSQ(cx2.getQuery(), position);
        }
        if (cx instanceof InsertQuery) {
            w.parseInsertQuery((InsertQuery)cx);
            if (w.holder != null) {
                return w.holder;
            }
        } else if (cx instanceof DeleteQuery) {
            w.parseDeleteQuery((DeleteQuery)cx);
            if (w.holder != null) {
                return w.holder;
            }
        } else if (cx instanceof UpdateQuery) {
            w.parseUpdateQuery((UpdateQuery)cx);
            if (w.holder != null) {
                return w.holder;
            }
        } else if (cx instanceof MergeQuery) {
            w.parseMergeQuery((MergeQuery)cx);
            if (w.holder != null) {
                return w.holder;
            }
        } else if (cx instanceof Cursor) {
            w.parseCursor((Cursor)cx);
            if (w.holder != null) {
                return w.holder;
            }
        }
        return null;
    }

    private class SQLSelectListener {
        private SelectColumnsHolder holder;

        private SQLSelectListener() {
        }

        private SelectColumnsHolder parseSelectQuery(SelectQuery sq, WithCTE cte) {
            this.holder = new SelectColumnsHolder();
            this.holder.setContext(sq.getContext());
            this.holder.setWhere(sq.getWhere());
            this.holder.setHaving(sq.getHaving());
            this.holder.setGroupBy(sq.getGroupByItems());
            this.holder.setOrderBy(sq.getOrderBy());
            this.setCTEs(this.holder, cte);
            if (sq.getSelectToken() != null) {
                this.holder.selectListFrom = sq.getSelectToken().getStopIndex() + 1;
                if (sq.getFromToken() != null) {
                    this.holder.selectListTo = sq.getFromToken().getStartIndex() - 1;
                } else if (sq.getWhereToken() != null) {
                    this.holder.selectListTo = sq.getWhereToken().getStartIndex() - 1;
                } else if (sq.getGroupToken() != null) {
                    this.holder.selectListTo = sq.getGroupToken().getStartIndex() - 1;
                } else if (sq.getElements() != null && sq.getElements().size() > 0) {
                    this.holder.selectListTo = sq.getElements().get(0).getParent().getStart().getStopIndex();
                }
                if (sq.getWhereToken() != null && sq.getWhere() != null) {
                    this.holder.whereListFrom = sq.getWhereToken().getStopIndex();
                    this.holder.whereListTo = sq.getContext().getStop().getStopIndex();
                }
                if (sq.getHavingToken() != null && sq.getHaving() != null) {
                    if (this.holder.whereListTo > 0) {
                        this.holder.whereListTo = sq.getHavingToken().getStartIndex() - 1;
                    }
                    this.holder.havingListFrom = sq.getHavingToken().getStopIndex();
                    this.holder.havingListTo = sq.getHavingContext().getStop().getStopIndex();
                }
                if (sq.getGroupToken() != null && this.holder.whereListTo > 0) {
                    this.holder.whereListTo = sq.getGroupToken().getStartIndex() - 1;
                }
            }
            this.holder.cols.addAll(sq.getColumns());
            if (sq.getFrom() != null) {
                TableSource source = sq.getFrom().getSource();
                Source x = source.getTableSourceItem();
                this.processSource(this.holder, x, null);
                for (JoinPart jp : source.getJoins()) {
                    if (jp == null) continue;
                    this.processSource(this.holder, jp.getJoinSource(), jp.getJoin());
                }
            } else {
                Source x = new Source();
                this.processSource(this.holder, x, null);
            }
            return this.holder;
        }

        private void parseInsertQuery(InsertQuery sq) {
            SelectColumnsHolder holder = new SelectColumnsHolder();
            holder.setContext(sq.getContext());
            this.setCTEs(holder, sq.getCte());
            InsertSource source = sq.getSource();
            if (source != null) {
                DerivedTable dt = source.getDerivedTable();
                if (dt != null && dt.getTableExpression() instanceof SelectQuery) {
                    SQLSelectListener listener = new SQLSelectListener();
                    SelectQuery tableExpression = (SelectQuery)dt.getTableExpression();
                    holder = listener.parseSelectQuery(tableExpression, sq.getCte());
                    for (UnionExpression union : tableExpression.getUnionExpressions()) {
                        if (union.getQuery() == null) continue;
                        listener = new SQLSelectListener();
                        listener.parseSelectQuery(union.getQuery(), null);
                        if (listener.holder == null) continue;
                        holder.addUnion(listener.holder);
                    }
                } else if (dt != null && dt.getTableExpression() instanceof TableValues) {
                    SQLSelectListener listener = new SQLSelectListener();
                    holder = new SelectColumnsHolder();
                    listener.processSource(holder, new Source(dt), null);
                } else if (source.getQuery() != null) {
                    SQLSelectListener listener = new SQLSelectListener();
                    holder = listener.parseSelectQuery(source.getQuery(), sq.getCte());
                    for (UnionExpression union : source.getQuery().getUnionExpressions()) {
                        if (union.getQuery() == null) continue;
                        listener = new SQLSelectListener();
                        listener.parseSelectQuery(union.getQuery(), sq.getCte());
                        if (listener.holder == null) continue;
                        holder.addUnion(listener.holder);
                    }
                }
            }
            this.holder = holder;
        }

        private void parseCursor(Cursor cur) {
            SelectColumnsHolder holder = new SelectColumnsHolder();
            holder.setContext(cur.getContext());
            if (cur.getSelectQuery() != null) {
                SelectQuery sq = cur.getSelectQuery();
                this.setCTEs(holder, sq.getCte());
                SQLSelectListener listener = new SQLSelectListener();
                this.holder = holder = listener.parseSelectQuery(sq, sq.getCte());
            }
        }

        private void setCTEs(SelectColumnsHolder holder, WithCTE cte) {
            if (cte != null) {
                for (CTE x : cte.getCtes()) {
                    SelectColumnsHolder h = new SelectColumnsHolder();
                    h.name = x.getCteName().getName();
                    h.setCTE(true);
                    if (x.getColumns().size() > 0) {
                        h.tableSourceColumnAliases.addAll(x.getColumns());
                    } else if (x.getQuery() != null && x.getQuery().getColumns() != null) {
                        h.cols.addAll(x.getQuery().getColumns());
                    }
                    h.context = (ParserRuleContext)x.getTree();
                    SQLSelectListener w = new SQLSelectListener();
                    w.parseSelectQuery(x.getQuery(), x.getQuery().getCte());
                    if (w.holder != null) {
                        w.holder.getFroms().forEach(h::addFrom);
                    }
                    holder.addFrom(h);
                }
            }
        }

        private void parseDeleteQuery(DeleteQuery sq) {
            this.holder = new SelectColumnsHolder();
            this.holder.setContext(sq.getContext());
            this.setCTEs(this.holder, sq.getCte());
            if (sq.getFrom() != null) {
                TableSource source = sq.getFrom().getSource();
                Source x = source.getTableSourceItem();
                this.processSource(this.holder, x, null);
                for (JoinPart jp : source.getJoins()) {
                    if (jp == null) continue;
                    this.processSource(this.holder, jp.getJoinSource(), jp.getJoin());
                }
            } else if (sq.getDeleteTarget() != null) {
                SQLName table = sq.getDeleteTarget().getTable();
                ParseTree tree = sq.getDeleteTarget().getTree();
                VariableExpression variable = sq.getDeleteTarget().getTableVariable();
                Alias alias = sq.getDeleteTarget().getAlias();
                if (table != null) {
                    this.processSource(this.holder, new Source(new Table(table, tree), alias), null);
                } else if (variable != null) {
                    this.processSource(this.holder, new Source(new TableVariable(variable.getToken()), alias), null);
                }
            }
        }

        private void parseUpdateQuery(UpdateQuery sq) {
            this.holder = new SelectColumnsHolder();
            this.holder.setContext(sq.getContext());
            this.setCTEs(this.holder, sq.getCte());
            sq.getUpdateToken();
            if (sq.getFrom() != null) {
                TableSource source = sq.getFrom().getSource();
                Source x = source.getTableSourceItem();
                this.processSource(this.holder, x, null);
                for (JoinPart jp : source.getJoins()) {
                    if (jp == null) continue;
                    this.processSource(this.holder, jp.getJoinSource(), jp.getJoin());
                }
            } else if (sq.getUpdateTarget() != null) {
                SQLName table = sq.getUpdateTarget().getTable();
                ParseTree tree = sq.getUpdateTarget().getTree();
                VariableExpression variable = sq.getUpdateTarget().getTableVariable();
                Alias alias = sq.getUpdateTarget().getAlias();
                if (table != null) {
                    this.processSource(this.holder, new Source(new Table(table, tree), alias), null);
                } else if (variable != null) {
                    this.processSource(this.holder, new Source(new TableVariable(variable.getToken()), alias), null);
                }
            }
        }

        private void parseMergeQuery(MergeQuery sq) {
            this.holder = new SelectColumnsHolder();
            this.holder.setContext(sq.getContext());
            this.setCTEs(this.holder, sq.getCte());
            TableSource ts = null;
            if (sq.getTarget() != null) {
                Source item;
                SQLName table = sq.getTarget().getTable();
                ParseTree tree = sq.getTarget().getTree();
                VariableExpression variable = sq.getTarget().getTableVariable();
                Alias alias = sq.getAlias();
                if (table != null) {
                    item = new Source(new Table(table, tree), alias);
                    ts = new TableSource(tree, item);
                    this.processSource(this.holder, item, null);
                } else if (variable != null) {
                    item = new Source(new TableVariable(variable.getToken()), alias);
                    ts = new TableSource(tree, item);
                    this.processSource(this.holder, item, null);
                }
            }
            if (sq.getFrom() != null) {
                TableSource source = sq.getFrom().getSource();
                Source x = source.getTableSourceItem();
                this.processSource(this.holder, x, sq.getMergeUsing() != null ? new MergeJoin((ParseTree)sq.getMergeUsing(), ts, sq.getCondition()) : null);
                for (JoinPart jp : source.getJoins()) {
                    if (jp == null) continue;
                    this.processSource(this.holder, jp.getJoinSource(), jp.getJoin());
                }
            }
        }

        private void processSource(SelectColumnsHolder holder, Source x, JoinExpression join) {
            if (x == null) {
                return;
            }
            Expression sourceExpression = x.getSource();
            ParseTree tree = x.getTree();
            if (sourceExpression instanceof Table) {
                SelectColumnsHolder h = new SelectColumnsHolder();
                h.join = join;
                h.source = x;
                h.context = (ParserRuleContext)tree;
                holder.addFrom(h);
                Table table = (Table)sourceExpression;
                h.fullName = table.getName().fullName();
                h.name = table.getName().getName();
                if (x.getAlias() != null) {
                    h.alias = x.getAlias().getAlias().getName();
                }
                h.tableSourceColumnAliases = x.getColumnAliases();
            } else if (x.getSourceType() == SourceType.EMPTY) {
                SelectColumnsHolder h = new SelectColumnsHolder();
                h.join = join;
                h.source = x;
                h.context = (ParserRuleContext)tree;
                holder.addFrom(h);
            } else if (sourceExpression instanceof TableVariable) {
                SelectColumnsHolder h = new SelectColumnsHolder();
                h.join = join;
                h.source = x;
                if (tree instanceof ParserRuleContext) {
                    h.context = (ParserRuleContext)tree;
                } else if (tree.getParent() instanceof ParserRuleContext) {
                    h.context = (ParserRuleContext)tree.getParent();
                }
                holder.addFrom(h);
                TableVariable table = (TableVariable)sourceExpression;
                h.name = table.getName().getName();
                h.fullName = table.getName().fullName();
                if (x.getAlias() != null) {
                    h.alias = x.getAlias().getAlias().getName();
                }
                h.tableSourceColumnAliases = x.getColumnAliases();
            } else if (x.getSourceType() == SourceType.UNPIVOT) {
                SelectColumnsHolder h = new SelectColumnsHolder();
                h.join = join;
                h.source = x;
                h.context = (ParserRuleContext)tree;
                holder.addFrom(h);
                if (x.getAlias() != null) {
                    h.alias = x.getAlias().getAlias().getName();
                }
                h.tableSourceColumnAliases = x.getColumnAliases();
            } else if (x.getSourceType() == SourceType.PIVOT) {
                SelectColumnsHolder h = new SelectColumnsHolder();
                h.join = join;
                h.source = x;
                h.context = (ParserRuleContext)tree;
                holder.addFrom(h);
                if (x.getAlias() != null) {
                    h.alias = x.getAlias().getAlias().getName();
                }
                h.tableSourceColumnAliases = x.getColumnAliases();
            } else if (sourceExpression instanceof DerivedTable) {
                DerivedTable dt = (DerivedTable)sourceExpression;
                if (dt.getTableExpression() instanceof SelectQuery) {
                    SelectQuery sql = (SelectQuery)dt.getTableExpression();
                    SQLSelectListener sl = new SQLSelectListener();
                    sl.parseSelectQuery(sql, sql.getCte());
                    holder.addFrom(sl.holder);
                    sl.holder.join = join;
                    sl.holder.source = x;
                    sl.holder.context = (ParserRuleContext)tree;
                    if (x.getAlias() != null) {
                        sl.holder.alias = x.getAlias().getAlias().getName();
                    }
                    sl.holder.tableSourceColumnAliases = x.getColumnAliases();
                    for (UnionExpression union : sql.getUnionExpressions()) {
                        if (union.getQuery() == null) continue;
                        sl = new SQLSelectListener();
                        sl.parseSelectQuery(union.getQuery(), null);
                        if (sl.holder == null) continue;
                        holder.addUnion(sl.holder);
                    }
                } else if (dt.getTableExpression() instanceof TableValues) {
                    SelectColumnsHolder h = new SelectColumnsHolder();
                    h.join = join;
                    h.context = (ParserRuleContext)tree;
                    holder.addFrom(h);
                    TableValues fc = (TableValues)dt.getTableExpression();
                    h.source = x;
                    if (x.getAlias() != null) {
                        h.alias = x.getAlias().getAlias().getName();
                    }
                    h.tableSourceColumnAliases = x.getColumnAliases();
                }
            } else if (sourceExpression instanceof FunctionCall) {
                SelectColumnsHolder h = new SelectColumnsHolder();
                h.join = join;
                h.source = x;
                holder.addFrom(h);
                h.context = (ParserRuleContext)tree;
                FunctionCall fc = (FunctionCall)sourceExpression;
                SQLName name = fc.getName();
                if (name != null) {
                    h.name = name.getName();
                    h.fullName = name.fullName();
                }
                if (x.getAlias() != null) {
                    h.alias = x.getAlias().getAlias().getName();
                }
                h.tableSourceColumnAliases = x.getColumnAliases();
            } else {
                SelectColumnsHolder h = new SelectColumnsHolder();
                h.join = join;
                h.source = x;
                holder.addFrom(h);
                h.context = (ParserRuleContext)tree;
                if (x.getAlias() != null) {
                    h.alias = x.getAlias().getAlias().getName();
                }
                h.tableSourceColumnAliases = x.getColumnAliases();
            }
        }
    }

    private static class WalkerHolder<H> {
        private H h;

        private WalkerHolder() {
        }
    }
}

