/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.completion.domain.SQLSubObject;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.IServerContext;
import com.sigge.filerunner.sql.sqlserver.ColumnDefinitionVisitor;
import com.sigge.filerunner.sql.sqlserver.CreateColumn;
import com.sigge.filerunner.sql.sqlserver.CreateTable;
import com.sigge.filerunner.sql.sqlserver.MaterializedVisitor;
import com.sigge.filerunner.sql.sqlserver.SQLServerDatabaseContext;
import com.sigge.filerunner.sql.transform.declare.Declare;
import com.sigge.filerunner.sql.transform.declare.DeclareBlock;
import com.sigge.filerunner.sql.transform.declare.DeclareParser;
import com.sigge.filerunner.sql.transform.expression.SQLName;
import com.sigge.filerunner.sql.transform.parameter.ParameterParser;
import com.siggemannen.sql.antler.TSqlParser;
import com.siggemannen.sql.antler.TSqlParserBaseVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;

public class CreateOrDeclareTableVisitor
extends TSqlParserBaseVisitor<List<CreateTable>> {
    private final String defaultSchema;
    private final DatabaseContext dbcontext;
    private final IServerContext server;

    public CreateOrDeclareTableVisitor(IServerContext server, DatabaseContext dbcontext) {
        this.server = server;
        this.dbcontext = dbcontext;
        this.defaultSchema = dbcontext != null ? dbcontext.getSchema() : null;
    }

    public List<CreateTable> visitCreate_table(TSqlParser.Create_tableContext ctx) {
        TSqlParser.Column_def_table_constraintsContext tdd;
        CreateTable t = new CreateTable();
        if (ctx.table_name() != null) {
            t.name = new SQLName(ctx.table_name());
            if (t.name.getSchemaName() == null && StringUtils.isNotEmpty(this.defaultSchema)) {
                t.name.setSchemaName(this.defaultSchema);
            }
        }
        if ((tdd = ctx.column_def_table_constraints()) != null) {
            this.getDefinition(tdd, t);
        }
        return Arrays.asList(t);
    }

    private void getDefinition(TSqlParser.Column_def_table_constraintsContext ctx, CreateTable t) {
        ctx.column_def_table_constraint().forEach(l -> {
            CreateColumn cc = (CreateColumn)l.accept((ParseTreeVisitor)new TSqlParserBaseVisitor<CreateColumn>(){

                public CreateColumn visitColumn_def_table_constraint(TSqlParser.Column_def_table_constraintContext ctx) {
                    if (ctx.column_definition() != null) {
                        return (CreateColumn)ctx.column_definition().accept((ParseTreeVisitor)new ColumnDefinitionVisitor());
                    }
                    if (ctx.materialized_column_definition() != null) {
                        return (CreateColumn)ctx.materialized_column_definition().accept((ParseTreeVisitor)new MaterializedVisitor());
                    }
                    return null;
                }
            });
            if (cc != null) {
                createTable.columns.add(cc);
            }
        });
    }

    public List<CreateTable> visitProcedure_param(TSqlParser.Procedure_paramContext param) {
        ArrayList<CreateTable> c = new ArrayList<CreateTable>();
        ParameterParser.parse(param).flatMap(this::fromDeclareBlock).ifPresent(c::add);
        return c;
    }

    public List<CreateTable> visitDeclare_statement(TSqlParser.Declare_statementContext ctx) {
        ArrayList<CreateTable> tables = new ArrayList<CreateTable>();
        Optional<Declare> x = DeclareParser.parse(ctx);
        if (!x.isPresent()) {
            return tables;
        }
        for (DeclareBlock db : x.get().block) {
            SQLName sqlname;
            Token name = db.variableToken;
            if (name == null) continue;
            CreateTable t = new CreateTable();
            t.name = sqlname = new SQLName(name);
            TSqlParser.Table_type_definitionContext tdd = ctx.table_type_definition();
            if (tdd != null && tdd.column_def_table_constraints() != null) {
                this.getDefinition(tdd.column_def_table_constraints(), t);
                tables.add(t);
                continue;
            }
            this.fromDeclareBlock(db).ifPresent(tables::add);
        }
        return tables;
    }

    private Optional<CreateTable> fromDeclareBlock(DeclareBlock db) {
        List<SQLObject> q;
        SQLName sqlname;
        Token name = db.variableToken;
        if (name == null) {
            return Optional.empty();
        }
        CreateTable t = new CreateTable();
        t.name = sqlname = new SQLName(name);
        String type = db.type;
        if (StringUtils.isNotEmpty(type) && this.server != null && !this.isDefaultType(type) && (q = this.server.getByName(type, this.dbcontext, SQLObjectType.TABLE_TYPE)).size() > 0) {
            SQLObject so = q.get(0);
            for (SQLSubObject sub : so.getColumns()) {
                t.columns.add(new CreateColumn(sub));
            }
            return Optional.of(t);
        }
        return Optional.empty();
    }

    private boolean isDefaultType(String type) {
        String normalizedIdentifier;
        if (type.contains("(")) {
            return true;
        }
        String string = normalizedIdentifier = this.dbcontext != null ? this.dbcontext.getNormalizedIdentifier(type.toUpperCase()) : type.toUpperCase();
        if (this.dbcontext instanceof SQLServerDatabaseContext) {
            return ((SQLServerDatabaseContext)this.dbcontext).getBuiltInTypes().contains(normalizedIdentifier);
        }
        return SQLServerDatabaseContext.getDefaultTypeSet().contains(normalizedIdentifier);
    }

    public List<CreateTable> visitFunc_body_returns_table(TSqlParser.Func_body_returns_tableContext ctx) {
        SQLName sqlname;
        Token name;
        CreateTable t = new CreateTable();
        Token token = name = ctx.LOCAL_ID() != null ? ctx.LOCAL_ID().getSymbol() : null;
        if (name == null) {
            return Arrays.asList(t);
        }
        t.name = sqlname = new SQLName(name);
        TSqlParser.Table_type_definitionContext tdd = ctx.table_type_definition();
        if (tdd != null && tdd.column_def_table_constraints() != null) {
            this.getDefinition(tdd.column_def_table_constraints(), t);
        }
        return Arrays.asList(t);
    }
}

