/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.sqlserver;

import com.sigge.filerunner.completion.domain.SQLIndex;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLSubObject;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.DatabaseContext;
import com.siggemannen.core.MapBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

class ContextUtils {
    public static final int TAB_SIZE = 8;

    ContextUtils() {
    }

    static String quoteIfNeeded(String quote) {
        if (!quote.matches("[A-Za-z_#][A-Za-z0-9_#@$]*") || quote.matches("[0-9]+")) {
            return ContextUtils.quotePart(quote);
        }
        return quote;
    }

    static String quotePart(String part) {
        return "[" + part.replaceAll("\\]", "\\]\\]") + "]";
    }

    static String getObject(SQLObject object, DatabaseContext context) {
        String lineSep = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(context.getQuotedName(object)).append(" (").append(lineSep);
        int maxTabs = StringUtils.maxLength(object.getColumns().stream().map(c -> ContextUtils.quoteIfNeeded(c.getName())));
        int maxTabsType = StringUtils.maxLength(object.getColumns().stream().map(c -> ContextUtils.getType(c)));
        int tabify = maxTabs / 8 + 1;
        int typeIfy = maxTabsType / 8 + 1;
        int col = 0;
        while (col < object.getColumns().size()) {
            if (col > 0) {
                sb.append(lineSep).append(",");
            }
            sb.append("\t");
            SQLSubObject column = object.getColumns().get(col);
            sb.append(StringUtils.tabify(ContextUtils.quoteIfNeeded(column.getName()), tabify, 8));
            Map customProperties = column.getCustomProperties().orElse(null);
            boolean persisted = false;
            String computedDef = null;
            if (customProperties != null) {
                computedDef = (String)customProperties.get("COLUMN_COMPUTED");
                persisted = customProperties.getOrDefault("COLUMN_PERSISTED", false);
            }
            if (computedDef == null) {
                sb.append(StringUtils.tabify(ContextUtils.getType(column), typeIfy, 8));
            } else {
                sb.append("AS ").append(computedDef);
                if (persisted) {
                    sb.append(" PERSISTED");
                }
            }
            if (customProperties != null) {
                Boolean identity;
                String defaultC;
                String collation = (String)customProperties.get("COLUMN_COLLATION");
                if (collation != null) {
                    sb.append(" COLLATE ").append(collation);
                }
                Boolean nullable = customProperties.getOrDefault("COLUMN_NULLABLE", false);
                if (persisted || computedDef == null) {
                    if (nullable.booleanValue()) {
                        sb.append(" NULL");
                    } else {
                        sb.append(" NOT NULL");
                    }
                }
                if ((defaultC = (String)customProperties.get("COLUMN_CONSTRAINT")) != null) {
                    sb.append(" DEFAULT ").append(defaultC);
                }
                if ((identity = customProperties.getOrDefault("COLUMN_IDENTITY", false)).booleanValue()) {
                    sb.append(" IDENTITY");
                }
            }
            ++col;
        }
        String fileGroupForTable = "PRIMARY";
        String partitionSchemeForTable = null;
        String partitionColumnForTable = "";
        int i = 0;
        while (i < object.getIndexes().size()) {
            SQLIndex six = object.getIndexes().get(i);
            Map props = six.getCustomProperties();
            if (props == null) {
                props = Collections.EMPTY_MAP;
            }
            String fGroup = (String)props.get("fGroup");
            String partitionScheme = (String)props.get("partitionScheme");
            if (six.isClustered() || (Integer)props.get("index_id") == 0) {
                fileGroupForTable = fGroup;
                partitionSchemeForTable = partitionScheme;
                List partitionColumns = (List)props.get("partitionColumns");
                if (partitionColumns != null) {
                    Collections.sort(partitionColumns, Comparator.comparing(pk -> (Integer)pk.getCustomProperties().get().get("partition_ordinal")));
                    int j = 0;
                    while (j < partitionColumns.size()) {
                        SQLSubObject colz = (SQLSubObject)partitionColumns.get(j);
                        if (j > 0) {
                            partitionColumnForTable = String.valueOf(partitionColumnForTable) + ",";
                        }
                        partitionColumnForTable = String.valueOf(partitionColumnForTable) + ContextUtils.quoteIfNeeded(colz.getName());
                        ++j;
                    }
                }
            }
            if (six.isPrimary()) {
                sb.append(lineSep).append(",");
                sb.append("\tCONSTRAINT ").append(ContextUtils.quoteIfNeeded(six.getName())).append(" PRIMARY KEY ").append(six.isClustered() ? "CLUSTERED" : "NONCLUSTERED").append("(");
                int j = 0;
                while (j < six.getColumns().size()) {
                    sb.append(lineSep);
                    SQLSubObject col2 = six.getColumns().get(j);
                    if (j > 0) {
                        sb.append(",");
                    }
                    sb.append("\t").append(ContextUtils.quoteIfNeeded(col2.getName()));
                    ++j;
                }
                partitionScheme = (String)props.get("partitionScheme");
                String partitionCols = "";
                if (partitionScheme != null) {
                    List partitionColumns = (List)props.get("partitionColumns");
                    int j2 = 0;
                    while (j2 < partitionColumns.size()) {
                        SQLSubObject colz = (SQLSubObject)partitionColumns.get(j2);
                        if (j2 > 0) {
                            partitionCols = String.valueOf(partitionCols) + ",";
                        }
                        partitionCols = String.valueOf(partitionCols) + ContextUtils.quoteIfNeeded(colz.getName());
                        ++j2;
                    }
                }
                sb.append(")");
                String s = ContextUtils.getIndexOptions(six);
                if (s != null) {
                    sb.append(s);
                }
                if (partitionScheme != null || fGroup != null) {
                    sb.append(" ON ").append(partitionScheme != null ? String.valueOf(ContextUtils.quotePart(partitionScheme)) + "(" + partitionCols + ")" : ContextUtils.quotePart(fGroup));
                }
            }
            ++i;
        }
        sb.append(lineSep).append(")");
        if (partitionSchemeForTable != null || fileGroupForTable != null) {
            sb.append(" ON ").append(partitionSchemeForTable != null ? String.valueOf(ContextUtils.quotePart(partitionSchemeForTable)) + "(" + partitionColumnForTable + ")" : ContextUtils.quotePart(fileGroupForTable));
        }
        ContextUtils.getIndexes(sb, object, true, context);
        return sb.toString();
    }

    private static <T> T getValue(SQLIndex six, String value) {
        Map<String, Object> customProperties = six.getCustomProperties();
        if (customProperties == null) {
            return null;
        }
        Object o = customProperties.get(value);
        return (T)o;
    }

    private static String getIndexOptions(SQLIndex six) {
        Integer compression;
        Map indexProps = new MapBuilder((Object)"padded", (Object)"PAD_INDEX").append((Object)"allowRowLocks", (Object)"ALLOW_ROW_LOCKS").append((Object)"allowPageLocks", (Object)"ALLOW_PAGE_LOCKS").append((Object)"compression", (Object)"DATA_COMPRESSION").append((Object)"fillFactor", (Object)"FILLFACTOR").build();
        ArrayList<String> strings = new ArrayList<String>();
        Map<String, Object> customProperties = six.getCustomProperties();
        Integer type = customProperties != null ? (Integer)customProperties.get("type") : 0;
        String pre = "";
        if (type.equals(4)) {
            String scheme = (String)customProperties.get("scheme");
            Integer bounding_box_xmin = (Integer)customProperties.get("bounding_box_xmin");
            Integer bounding_box_ymin = (Integer)customProperties.get("bounding_box_ymin");
            Integer bounding_box_xmax = (Integer)customProperties.get("bounding_box_xmax");
            Integer bounding_box_ymax = (Integer)customProperties.get("bounding_box_ymax");
            String level_1_grid_desc = (String)customProperties.get("level_1_grid_desc");
            String level_2_grid_desc = (String)customProperties.get("level_2_grid_desc");
            String level_3_grid_desc = (String)customProperties.get("level_3_grid_desc");
            String level_4_grid_desc = (String)customProperties.get("level_4_grid_desc");
            Integer cells_per_object = (Integer)customProperties.get("cells_per_object");
            pre = "USING " + scheme;
            if (bounding_box_ymin != null) {
                strings.add("BOUNDING_BOX = (" + bounding_box_xmin + "," + bounding_box_ymin + ", " + bounding_box_xmax + "," + bounding_box_ymax + ")");
            }
            if (level_1_grid_desc != null) {
                strings.add("GRIDS = (LEVEL_1 = " + level_1_grid_desc + ", LEVEL_2 = " + level_2_grid_desc + ", LEVEL_3 = " + level_3_grid_desc + ", LEVEL_4 = " + level_4_grid_desc + ")");
            }
            if (cells_per_object != null) {
                strings.add("CELLS_PER_OBJECT = " + cells_per_object);
            }
        }
        if (!type.equals(5) && !type.equals(6)) {
            Integer ff;
            Boolean p = (Boolean)ContextUtils.getValue(six, "padded");
            if (p != null && p.booleanValue()) {
                strings.add(String.valueOf((String)indexProps.get("padded")) + " = ON");
            }
            if ((p = (Boolean)ContextUtils.getValue(six, "allowRowLocks")) != null) {
                strings.add(String.valueOf((String)indexProps.get("allowRowLocks")) + " = " + (p != false ? "ON" : "OFF"));
            }
            if ((p = (Boolean)ContextUtils.getValue(six, "allowPageLocks")) != null) {
                strings.add(String.valueOf((String)indexProps.get("allowPageLocks")) + " = " + (p != false ? "ON" : "OFF"));
            }
            if ((ff = (Integer)ContextUtils.getValue(six, "fillFactor")) != null && !ff.equals(0)) {
                strings.add("FILLFACTOR = " + ff);
            }
        }
        if ((compression = (Integer)ContextUtils.getValue(six, "compression")) != null && compression > 0) {
            String dc = "DATA_COMPRESSION = ";
            switch (compression) {
                case 1: {
                    dc = String.valueOf(dc) + "ROW";
                    break;
                }
                case 2: {
                    dc = String.valueOf(dc) + "PAGE";
                    break;
                }
                case 3: {
                    dc = String.valueOf(dc) + "COLUMNSTORE";
                    break;
                }
                case 4: {
                    dc = String.valueOf(dc) + "COLUMNSTORE_ARCHIVE";
                    break;
                }
                default: {
                    dc = String.valueOf(dc) + "UNKNOWN??";
                }
            }
            strings.add(dc);
        }
        if (strings.size() > 0) {
            StringBuilder ss = new StringBuilder(pre).append(" WITH (");
            int i = 0;
            while (i < strings.size()) {
                if (i > 0) {
                    ss.append(", ");
                }
                ss.append((String)strings.get(i));
                ++i;
            }
            ss.append(")");
            return ss.toString();
        }
        return null;
    }

    public static StringBuilder getIndexes(StringBuilder sb, SQLObject object, boolean excludeMainIndex, DatabaseContext context) {
        String lineSep = System.lineSeparator();
        int i = 0;
        while (i < object.getIndexes().size()) {
            SQLIndex six = object.getIndexes().get(i);
            if (!six.isPrimary() && (Integer)six.getCustomProperties().get("index_id") != 0) {
                int type;
                String fGroup = (String)six.getCustomProperties().get("fGroup");
                sb.append(lineSep).append(lineSep);
                sb.append("CREATE");
                if (six.isUnique()) {
                    sb.append(" UNIQUE");
                }
                if ((type = ((Integer)six.getCustomProperties().get("type")).intValue()) == 4) {
                    sb.append(" SPATIAL ");
                } else {
                    sb.append(six.isClustered() ? " CLUSTERED" : " NONCLUSTERED");
                }
                if (type == 5 || type == 6) {
                    sb.append(" COLUMNSTORE");
                }
                sb.append(" INDEX ").append(ContextUtils.quoteIfNeeded(six.getName())).append(" ON ").append(context.getQuotedName(object));
                if (type != 5) {
                    sb.append(" ( ");
                    int z = 0;
                    while (z < six.getColumns().size()) {
                        SQLSubObject col = six.getColumns().get(z);
                        sb.append(lineSep);
                        if (z > 0) {
                            sb.append(",");
                        }
                        sb.append("\t").append(ContextUtils.quoteIfNeeded(col.getName()));
                        if (((Boolean)col.getCustomProperties().map(f -> f.get("descending")).orElse(false)).booleanValue()) {
                            sb.append(" DESC");
                        }
                        ++z;
                    }
                    sb.append(lineSep).append(")");
                }
                int inc = 0;
                while (inc < six.getIncludeColumns().size()) {
                    if (inc == 0) {
                        sb.append("\tINCLUDE (").append(lineSep);
                    } else {
                        sb.append(lineSep).append(",");
                    }
                    sb.append("\t").append(ContextUtils.quoteIfNeeded(six.getIncludeColumns().get(inc).getName()));
                    if (inc + 1 == six.getIncludeColumns().size()) {
                        sb.append(lineSep).append(")");
                    }
                    ++inc;
                }
                sb.append(six.getCustomProperties().get("filter") != null ? " WHERE " + six.getCustomProperties().get("filter") : "");
                String options = ContextUtils.getIndexOptions(six);
                if (options != null) {
                    sb.append(options);
                }
                String partitionScheme = (String)six.getCustomProperties().get("partitionScheme");
                String partitionCols = "";
                if (partitionScheme != null) {
                    List partitionColumns = (List)six.getCustomProperties().get("partitionColumns");
                    int j = 0;
                    while (j < partitionColumns.size()) {
                        SQLSubObject colz = (SQLSubObject)partitionColumns.get(j);
                        if (j > 0) {
                            partitionCols = String.valueOf(partitionCols) + ",";
                        }
                        partitionCols = String.valueOf(partitionCols) + ContextUtils.quoteIfNeeded(colz.getName());
                        ++j;
                    }
                }
                sb.append(" ON ").append(partitionScheme != null ? String.valueOf(ContextUtils.quotePart(partitionScheme)) + "(" + partitionCols + ")" : ContextUtils.quotePart(fGroup));
            }
            ++i;
        }
        return sb;
    }

    private static String getType(SQLSubObject column) {
        Map customs = column.getCustomProperties().orElse(null);
        if (customs == null) {
            return column.getType();
        }
        StringBuilder sb = new StringBuilder();
        String computed = (String)customs.get("COLUMN_COMPUTED");
        if (computed != null && computed.length() > 0) {
            sb.append(" AS ");
            sb.append(computed);
            Boolean persisted = (Boolean)customs.get("COLUMN_PERSISTED");
            if (persisted != null && persisted.booleanValue()) {
                sb.append(" PERSISTED");
            }
        } else {
            String part = (String)customs.get("COLUMNTYPE_NAME");
            sb.append(ContextUtils.quoteIfNeeded(part));
            String part2 = (String)customs.get("COLUMNTYPE");
            if (part2.length() > 0) {
                sb.append(part2);
            }
        }
        return sb.toString();
    }
}

