/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql.edit;

import com.sigge.filerunner.sql.sqlserver.SelectColumnsHolder;
import com.sigge.filerunner.sql.transform.dml.BaseTarget;
import com.sigge.filerunner.sql.transform.dml.Execute;
import com.sigge.filerunner.sql.transform.dml.MergeInsert;
import com.sigge.filerunner.sql.transform.expression.SQLName;
import com.sigge.filerunner.sql.transform.select.source.TableValues;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class InsertHolder {
    private final SelectColumnsHolder holder;
    private final BaseTarget target;
    private final SelectColumns selectColumns;
    private final InsertType insertType;
    private final List<SQLName> insertColumns;

    public InsertHolder(SelectColumnsHolder holder, BaseTarget target, SelectColumns selectColumns, List<SQLName> insertColumns, InsertType insertType) {
        this.holder = holder;
        this.target = target;
        this.selectColumns = selectColumns;
        this.insertColumns = insertColumns;
        this.insertType = insertType;
    }

    public SelectColumnsHolder getHolder() {
        return this.holder;
    }

    public List<SQLName> getInsertColumns() {
        return this.insertColumns;
    }

    public InsertType getInsertType() {
        return this.insertType;
    }

    public BaseTarget getTarget() {
        return this.target;
    }

    public SelectColumns getSelectColumns() {
        return this.selectColumns;
    }

    public static enum InsertType {
        NORMAL,
        OUTPUT_INSERT,
        OUTPUT_INSERT_MERGE_MATCHED,
        OUTPUT_INSERT_NOT_MATCHED;

    }

    public static enum SelectColumnType {
        NORMAL,
        DEFAULT_VALUES,
        EXEC,
        VALUES;

    }

    public static class SelectColumns {
        private final List<String> columns;
        private final Optional<Execute> exec;
        private final SelectColumnType type;
        private final Optional<TableValues> tableValues;
        public static final SelectColumns DEFAULT_VALUES = new SelectColumns((List<String>)Collections.EMPTY_LIST, null, null, SelectColumnType.DEFAULT_VALUES);

        private SelectColumns(List<String> columns, Execute exec, TableValues tv, SelectColumnType type) {
            this.columns = columns;
            this.exec = Optional.ofNullable(exec);
            this.type = type;
            this.tableValues = Optional.ofNullable(tv);
        }

        public SelectColumns(List<String> columns, Execute exec, TableValues tv, boolean defaultValues) {
            this(columns, exec, tv, exec != null ? SelectColumnType.EXEC : (tv != null ? SelectColumnType.EXEC : (defaultValues ? SelectColumnType.DEFAULT_VALUES : SelectColumnType.NORMAL)));
        }

        public SelectColumns(List<String> columns) {
            this(columns, null, null, SelectColumnType.NORMAL);
        }

        public SelectColumns(Execute exec) {
            this((List<String>)Collections.EMPTY_LIST, exec, null, SelectColumnType.EXEC);
        }

        public static SelectColumns fromMergeInsert(MergeInsert mergeInsert) {
            if (mergeInsert.isDefaultValues()) {
                return DEFAULT_VALUES;
            }
            return new SelectColumns(mergeInsert.getTableExpression());
        }

        public SelectColumns(TableValues tableValues) {
            this((List<String>)Collections.EMPTY_LIST, null, tableValues, SelectColumnType.VALUES);
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public Optional<Execute> getExec() {
            return this.exec;
        }

        public SelectColumnType getType() {
            return this.type;
        }

        public Optional<TableValues> getTableValues() {
            return this.tableValues;
        }
    }
}

