/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.sql.DatabaseFromConfig;
import com.sigge.filerunner.view.core.ILabel;

public class ServerDatabase
implements ILabel {
    private final Database db;
    private final String database;

    public ServerDatabase(Database db, String database) {
        this.db = db;
        this.database = database;
    }

    public String getId() {
        return String.valueOf(this.db.getUniqueProviderName()) + "/" + this.database;
    }

    public Database getDb() {
        return this.db;
    }

    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.db.getLabel()) + "/" + this.database;
    }

    public boolean matches(int serverId, String database) {
        if (!this.database.equals(database)) {
            return false;
        }
        if (!(this.db instanceof DatabaseFromConfig)) {
            return false;
        }
        return ((DatabaseFromConfig)this.db).getConfig().getId() == serverId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.database == null ? 0 : this.database.hashCode());
        result = 31 * result + (this.db == null ? 0 : this.db.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerDatabase)) {
            return false;
        }
        ServerDatabase other = (ServerDatabase)obj;
        if (this.database == null ? other.database != null : !this.database.equals(other.database)) {
            return false;
        }
        return !(this.db == null ? other.db != null : !this.db.equals(other.db));
    }

    public String toString() {
        return this.db == null ? this.database : this.getId();
    }
}

