/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql;

import com.sigge.dbrunner.table.ScriptOptions;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.export.ExportAction;
import com.sigge.filerunner.export.inserts.IScripter;
import com.sigge.filerunner.sql.IOutput;
import com.sigge.filerunner.sql.OutputFormat;
import java.io.File;

public class OutputBuilder {
    private static final IOutput TEXT_OUTPUT = () -> OutputFormat.TEXT;
    private static final IOutput TABLE_OUTPUT = () -> OutputFormat.TABLE;
    private static final IOutput NEW_WINDOW_OUTPUT = () -> OutputFormat.NEW_WINDOW;
    private static final IOutput CLIPBOARD_OUTPUT = () -> OutputFormat.CLIPBOARD;

    public static FileOutput toFile(ExportAction iex, File f, Object preferences) {
        return new FileOutput(f, iex, preferences);
    }

    public static ScriptOutput toScriptOutput(IScripter scripter, IOutput actualOutput, ScriptOptions options) {
        return new ScriptOutput(scripter, actualOutput, options);
    }

    public static IOutput toNewWindow() {
        return NEW_WINDOW_OUTPUT;
    }

    public static IOutput toClipboard() {
        return CLIPBOARD_OUTPUT;
    }

    public static IOutput toTable() {
        return TABLE_OUTPUT;
    }

    public static IOutput toText() {
        return TEXT_OUTPUT;
    }

    public static class FileOutput
    implements IOutput {
        private final File file;
        private final ExportAction iex;
        private final Object preferences;
        private int filesExported = 0;
        private int lastInt = 0;

        FileOutput(File f, ExportAction iex, Object preferences) {
            this.file = f;
            this.iex = iex;
            this.preferences = preferences;
        }

        @Override
        public OutputFormat getFormat() {
            return OutputFormat.FILE;
        }

        public File getFile() {
            return this.file;
        }

        public ExportAction getExporter() {
            return this.iex;
        }

        public Object getPreferences() {
            return this.preferences;
        }

        public void addExported() {
            ++this.filesExported;
        }

        public int getFilesExported() {
            return this.filesExported;
        }

        public File generateNextFile() {
            if (this.filesExported == 0) {
                return this.file;
            }
            File orig = this.file;
            while (orig.exists()) {
                String ext = FileUtils.getExtension(orig);
                if (ext == null) {
                    ext = "";
                }
                ++this.lastInt;
                orig = new File(String.valueOf(FileUtils.getFileWithoutExtension(orig)) + this.lastInt + ext);
            }
            return orig;
        }
    }

    public static class ScriptOutput
    implements IOutput {
        private final ScriptOptions preferences;
        private final IOutput actualOutput;
        private final IScripter scripter;

        ScriptOutput(IScripter scripter, IOutput actualOutput, ScriptOptions preferences) {
            this.scripter = scripter;
            this.actualOutput = actualOutput;
            this.preferences = preferences;
        }

        @Override
        public OutputFormat getFormat() {
            return OutputFormat.SCRIPT;
        }

        public ScriptOptions getPreferences() {
            return this.preferences;
        }

        public IOutput getActualOutput() {
            return this.actualOutput;
        }

        public IScripter getScripter() {
            return this.scripter;
        }
    }
}

