/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.sql;

import com.sigge.filerunner.completion.domain.EntityName;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.completion.domain.SQLSubObject;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.sql.CancellableCallback;
import com.sigge.filerunner.sql.ServerDatabase;
import java.io.Closeable;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public interface DatabaseContext
extends Closeable {
    public static final String COLUMN_IDENTITY = "COLUMN_IDENTITY";

    public ServerDatabase getDatabase();

    public void initContext() throws Exception;

    public List<SQLObject> getObjects();

    public List<SQLObject> getSchemas();

    public List<SQLObject> getDatabases();

    public List<SQLObject> getObjects(EntityName var1, boolean var2, SQLObjectType ... var3);

    public void getObjectDefinition(SQLObject var1, Consumer<String> var2, Consumer<Exception> var3);

    default public Optional<String> getObjectDefinition(SQLObject object, Consumer<Exception> onError) {
        return Optional.empty();
    }

    public boolean isLoaded(CancellableCallback var1);

    public boolean isRunning();

    default public char getParameterListStart(SQLObject so) {
        return '(';
    }

    default public char getParameterListEnd(SQLObject so) {
        return ')';
    }

    default public String getQuotedName(SQLObject object) {
        return String.valueOf(!StringUtils.isEmpty(object.getSchemaName()) ? String.valueOf(this.getQuotedIdentifier(object.getSchemaName())) + "." : "") + this.getQuotedIdentifier(object.getName());
    }

    default public String getQuotedIdentifier(String identifier) {
        if (DatabaseContext.quoteIfNeeded(identifier)) {
            return "\"" + identifier.replace("\"", "\"\"") + "\"";
        }
        return identifier;
    }

    public static boolean quoteIfNeeded(String quote) {
        return !quote.matches("[A-Za-z_#][A-Za-z0-9_#@$]*") || quote.matches("[0-9]+");
    }

    default public boolean needsSchema(SQLObject object) {
        return true;
    }

    default public String getSelectQuery(SQLObject so, int rowNumber) {
        return "SELECT\t*" + System.lineSeparator() + "FROM\t" + so.getContext().getQuotedName(so) + " limit " + rowNumber + ";";
    }

    default public String getNormalizedIdentifier(String identifier) {
        return identifier;
    }

    default public boolean isSameIdentifier(String name, String name2) {
        return name.equalsIgnoreCase(name2);
    }

    default public boolean isSameIdentifier(String name, SQLObject object) {
        if (object.getFullName() != null && this.isSameIdentifier(object.getFullName(), name)) {
            return true;
        }
        return !this.needsSchema(object) && object.getName() != null && this.isSameIdentifier(object.getName(), name);
    }

    default public void addObjectUsage(SQLObject object, Optional<SQLSubObject> sub) {
    }

    public String getSchema();
}

