/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.recent;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.core.DocumentListenerAdapter;
import com.sigge.filerunner.core.FilterHelper;
import com.sigge.filerunner.core.StoreItem;
import com.sigge.filerunner.recent.ItemStorer;
import com.sigge.filerunner.recent.Recent;
import com.sigge.filerunner.recent.RecentCellRenderer;
import com.sigge.filerunner.recent.RecentFilesPanel;
import com.sigge.filerunner.recent.RecentFilter;
import com.sigge.filerunner.recent.RecentModel;
import com.sigge.filerunner.view.MainPanel;
import com.sigge.filerunner.view.core.ComponentUtils;
import com.sigge.filerunner.view.core.JListUtils;
import com.sigge.filerunner.view.core.VTableCellRenderer;
import com.sigge.filerunner.view.menu.RecentMenuHandler;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.IView;
import com.siggemannen.view.ListTableElementModel;
import com.siggemannen.view.UIBackgroundRunner;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.swingx.JXTable;
import org.oxbow.swingbits.table.filter.PredicateFactory;
import org.oxbow.swingbits.table.filter.TableRowFilterSupport;

@Singleton
public class RecentPresenter
extends APresenter<Recent, RecentModel, RecentFilesPanel> {
    private final JFrame mainFrame;
    private boolean presenting;
    private final ItemStorer<File, RecentFilter> storer;
    private ListTableElementModel<StoreItem<File>, String> tm;
    private boolean changing = false;

    @Inject
    public RecentPresenter(RecentMenuHandler recentMenuHandler, @Named(value="mainFrame") JFrame mainFrame, final Consumer<File> fileConsumer, RecentModel model, RecentFilesPanel view) {
        super((AModel)model, (IView)view);
        this.mainFrame = mainFrame;
        this.storer = recentMenuHandler.getStorer();
        this.tm = new ListTableElementModel<StoreItem<File>, String>(Arrays.asList("Date", "File")){

            public Object getValueAt(int row, int column) {
                switch (column) {
                    case 0: {
                        return ((StoreItem)this.dataVector.get(row)).getTime();
                    }
                    case 1: {
                        return ((StoreItem)this.dataVector.get(row)).getItem();
                    }
                }
                throw new RuntimeException("Column " + column + " doesn't exist");
            }

            public boolean isCellEditable(int row, int column) {
                return false;
            }

            public void setValueAt(Object aValue, int row, int column) {
            }
        };
        final JXTable jt = view.getTable();
        jt.setModel(this.tm);
        jt.setFillsViewportHeight(true);
        jt.setAutoResizeMode(3);
        jt.setHorizontalScrollEnabled(true);
        jt.setCellSelectionEnabled(false);
        jt.setRowSelectionAllowed(true);
        jt.setSelectionMode(2);
        jt.setColumnControlVisible(false);
        TableRowFilterSupport.forTable((JTable)jt).searchable(true).predicator((a, b, c) -> {
            switch (a) {
                case 0: {
                    return PredicateFactory.createDatePredicator((String)b, (String)c);
                }
                case 1: {
                    return PredicateFactory.createToStringPredicator((String)b, (String)c);
                }
            }
            return null;
        }).apply();
        jt.getColumnModel().getColumn(1).setCellRenderer(new RecentCellRenderer());
        jt.getColumnModel().getColumn(0).setCellRenderer(new VTableCellRenderer());
        jt.getColumnModel().getColumn(0).setPreferredWidth(50);
        jt.getColumnModel().getColumn(1).setPreferredWidth(300);
        jt.addMouseMotionListener((MouseMotionListener)new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (jt.columnAtPoint(e.getPoint()) == 0) {
                    jt.setCursor(Cursor.getPredefinedCursor(0));
                } else {
                    jt.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        });
        final TableRowSorter<TableModel> tb = new TableRowSorter<TableModel>(jt.getModel());
        jt.setRowSorter(tb);
        jt.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        tb.setRowFilter(new TextFilter(view.getSearchField()));
        ComponentUtils.removeKeyFromMap(jt.getInputMap(1), KeyStroke.getKeyStroke(10, 0));
        jt.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    File file;
                    int row = jt.rowAtPoint(e.getPoint());
                    int col = jt.columnAtPoint(e.getPoint());
                    if (col == 0 && e.getClickCount() >= 2) {
                        col = 1;
                    }
                    if (col == 1 && row > -1 && (file = (File)RecentPresenter.this.tm.getValueAt(tb.convertRowIndexToModel(row), col)) != null) {
                        fileConsumer.accept(file);
                    }
                }
            }
        });
        BoundedRangeModel scrollModel = view.tableScroll.getVerticalScrollBar().getModel();
        scrollModel.addChangeListener(e -> {
            if (!scrollModel.getValueIsAdjusting() && scrollModel.getValue() + scrollModel.getExtent() >= scrollModel.getMaximum() & scrollModel.getValue() > 0) {
                this.tm.insertRows(this.storer.listItems(this.getFilter()));
            }
        });
        view.getSearchField().getDocument().addDocumentListener((DocumentListener)((Object)new DocumentListenerAdapter(tb::sort)));
        JListUtils.bindArrowsToFilter(view.getSearchField(), (JComponent)jt, () -> fileConsumer.accept((File)((StoreItem)this.tm.getValueAt(tb.convertRowIndexToModel(jt.getSelectedRow()))).getItem()));
        view.closeButton.addActionListener(l -> this.closePresenter());
    }

    public void present() {
        if (this.presenting) {
            this.closePresenter();
            return;
        }
        this.presenting = true;
        this.storer.resetItems();
        this.tm.setRows(this.storer.listItems());
        ((RecentFilesPanel)this.view).getSearchField().setText("");
        JXTable jt = ((RecentFilesPanel)this.view).getTable();
        if (this.tm.getRowCount() > 0) {
            jt.setRowSelectionInterval(0, 0);
        }
        jt.packAll();
        ((RecentFilesPanel)this.view).setPreferredSize(new Dimension(this.mainFrame.getContentPane().getSize()));
        Component mainComponent = this.getMainComponent();
        ComponentUtils.wrapPanelsIntoASplitPane(mainComponent, (Component)this.view, "historyWindow", true);
        ((RecentFilesPanel)this.view).getSearchField().requestFocusInWindow();
        this.setObject(new Recent());
    }

    private RecentFilter getFilter() {
        if (((RecentModel)this.model).from.getValue() != null && !Objects.equal((Object)((RecentModel)this.model).from.getValue(), (Object)LocalDate.now())) {
            return RecentFilter.byDateRange((LocalDate)((RecentModel)this.model).from.getValue(), (LocalDate)((RecentModel)this.model).to.getValue()).freetext((String)((RecentModel)this.model).filter.getValue());
        }
        return RecentFilter.create().freetext((String)((RecentModel)this.model).filter.getValue());
    }

    private void closePresenter() {
        this.presenting = false;
        Component mainComponent = this.getMainComponent();
        ComponentUtils.unwrapPanelsFromASplitPane(mainComponent);
    }

    private Component getMainComponent() {
        return ((MainPanel)((Object)this.mainFrame.getContentPane().getComponent(0))).getMainComponent();
    }

    protected void initBindings() {
        this.bind(((RecentFilesPanel)this.view).fromDate).to(((RecentModel)this.model).from);
        this.bind(((RecentFilesPanel)this.view).toDate).to(((RecentModel)this.model).to);
        ((RecentModel)this.model).from.addListener(this::search);
        ((RecentModel)this.model).to.addListener(this::search);
        this.bind(((RecentFilesPanel)this.view).getSearchField()).to(((RecentModel)this.model).filter);
        ((RecentFilesPanel)this.view).todayLink.addActionListener(l -> {
            this.changing = true;
            ((RecentModel)this.model).from.setValue((Object)LocalDate.now());
            ((RecentModel)this.model).to.setValue((Object)LocalDate.now());
            this.changing = false;
            this.search();
        });
        ((RecentFilesPanel)this.view).yesterdayLink.addActionListener(l -> {
            this.changing = true;
            ((RecentModel)this.model).from.setValue((Object)LocalDate.now().minus(1L, ChronoUnit.DAYS));
            ((RecentModel)this.model).to.setValue((Object)LocalDate.now().minus(1L, ChronoUnit.DAYS));
            this.changing = false;
            this.search();
        });
        ((RecentFilesPanel)this.view).thisWeekLink.addActionListener(l -> {
            this.changing = true;
            ((RecentModel)this.model).from.setValue((Object)LocalDate.now().minus(7L, ChronoUnit.DAYS));
            ((RecentModel)this.model).to.setValue((Object)LocalDate.now());
            this.changing = false;
            this.search();
        });
        ((RecentFilesPanel)this.view).thisMonthLink.addActionListener(l -> {
            this.changing = true;
            ((RecentModel)this.model).from.setValue((Object)LocalDate.now().withDayOfMonth(1));
            ((RecentModel)this.model).to.setValue((Object)LocalDate.now());
            this.changing = false;
            this.search();
        });
    }

    private void search() {
        if (this.changing) {
            return;
        }
        UIBackgroundRunner.execute((RootPaneContainer)this.mainFrame, () -> {
            this.storer.resetItems();
            this.tm.insertAndReplaceRows(this.storer.listItems(this.getFilter()));
        });
    }

    private class TextFilter
    extends RowFilter<ListTableElementModel<StoreItem<File>, String>, Integer> {
        private final JTextField jt;

        TextFilter(JTextField jt) {
            this.jt = jt;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends ListTableElementModel<StoreItem<File>, String>, ? extends Integer> entry) {
            return this.jt.getText().isEmpty() || ((File)((StoreItem)entry.getModel().getValueAt(entry.getIdentifier().intValue())).getItem()).getAbsolutePath().matches(FilterHelper.getRegexFromString2(this.jt.getText()));
        }
    }
}

