/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.recent;

import com.sigge.filerunner.core.StoreItem;
import com.sigge.filerunner.recent.ItemStorer;
import com.sigge.filerunner.recent.RecentFilter;
import com.sigge.filerunner.sql.SQLBuilder;
import com.siggemannen.core.ThreadUtils;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecentItemStorer
implements ItemStorer<File, RecentFilter> {
    private static final String SQL_INSERT = new SQLBuilder("insert into recent_items ").append("(").append("file, file_year, file_month, file_day, file_hour, file_minute, file_second, file_nano, row_id").append(")").append("values(?,?,?,?,?,?,?,?,?);").build();
    private final String database;
    private static final Logger LOGGER = LoggerFactory.getLogger(RecentItemStorer.class);
    private long max_row_id = 0L;
    private long min_row_id = 0L;
    private long max_row_id_storage = 0L;
    private Boolean inited = null;

    public RecentItemStorer(String database) {
        this.database = database;
    }

    private void createTablesIfNeeded() throws SQLException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection c = this.newConnection();){
                if (c == null) {
                    return;
                }
                this.createTablesIfNeeded(c);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error while connecting", (Throwable)e);
            throw e;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean storeItems(List<StoreItem<File>> items) {
        PreparedStatement s;
        Connection conn;
        block28: {
            block27: {
                if (items.size() == 0) {
                    return true;
                }
                if (this.inited == null) {
                    try {
                        this.createTablesIfNeeded();
                        this.inited = true;
                    }
                    catch (SQLException e2) {
                        this.inited = false;
                    }
                }
                if (!this.inited.booleanValue()) {
                    return false;
                }
                Throwable e2 = null;
                Object var3_6 = null;
                conn = this.newConnection();
                s = conn.prepareStatement(SQL_INSERT);
                if (this.max_row_id_storage == 0L) {
                    this.max_row_id_storage = this.getMaxId(conn);
                }
                conn.setAutoCommit(false);
                int i = 0;
                while (i < items.size()) {
                    ++this.max_row_id_storage;
                    StoreItem<File> item = items.get(i);
                    s.setString(1, item.getItem().getAbsolutePath());
                    LocalDateTime ld = item.getTime();
                    s.setInt(2, ld.getYear());
                    s.setInt(3, ld.getMonth().getValue());
                    s.setInt(4, ld.getDayOfMonth());
                    s.setInt(5, ld.getHour());
                    s.setInt(6, ld.getMinute());
                    s.setInt(7, ld.getSecond());
                    s.setInt(8, ld.getNano());
                    s.setLong(9, this.max_row_id_storage);
                    s.addBatch();
                    if (i + 1 == items.size()) {
                        s.executeBatch();
                    }
                    ++i;
                }
                conn.commit();
                if (s == null) break block27;
                s.close();
            }
            if (conn == null) break block28;
            conn.close();
        }
        return true;
        {
            catch (Throwable e2) {
                try {
                    try {
                        try {
                            if (s != null) {
                                s.close();
                            }
                            throw e2;
                        }
                        catch (Throwable throwable) {
                            if (e2 == null) {
                                e2 = throwable;
                            } else if (e2 != throwable) {
                                e2.addSuppressed(throwable);
                            }
                            if (conn != null) {
                                conn.close();
                            }
                            throw e2;
                        }
                    }
                    catch (Throwable throwable) {
                        if (e2 == null) {
                            e2 = throwable;
                        } else if (e2 != throwable) {
                            e2.addSuppressed(throwable);
                        }
                        throw e2;
                    }
                }
                catch (Exception e2) {
                    LOGGER.error("Error while performing insert", (Throwable)e2);
                    return false;
                }
            }
        }
    }

    @Override
    public List<StoreItem<File>> listItems() {
        return this.listItems(RecentFilter.create());
    }

    @Override
    public List<StoreItem<File>> listItems(RecentFilter filter) {
        SQLBuilder sb = new SQLBuilder("SELECT row_id, file, file_year, file_month, file_day, file_hour, file_minute, file_second, file_nano FROM recent_items ri where 1 = 1 ");
        int index = 0;
        ArrayList<StoreItem<File>> rc = new ArrayList<StoreItem<File>>();
        ArrayList<ThrowingConsumer> r = new ArrayList<ThrowingConsumer>();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection conn = this.newConnection();){
                LocalDateTime ldt;
                int idx;
                LocalDate ld = filter.getDate();
                if (ld != null) {
                    idx = index;
                    sb.append("AND file_year = ? AND file_month = ? AND file_day = ?");
                    r.add(p -> p.setInt(idx + 1, ld.getYear()));
                    r.add(p -> p.setInt(idx + 2, ld.getMonthValue()));
                    r.add(p -> p.setInt(idx + 3, ld.getDayOfMonth()));
                    index += 3;
                }
                if (filter.getYear() != null) {
                    idx = index++;
                    sb.append("AND file_year >=?");
                    r.add(p -> p.setInt(idx + 1, LocalDate.now().getYear() + filter.getYear()));
                }
                if (this.min_row_id > 0L) {
                    sb.append("AND row_id < " + this.min_row_id);
                }
                this.appendDateFilter(sb, filter);
                if (filter.isOnlyLastFile()) {
                    sb.append("AND NOT EXISTS(SELECT 1 FROM recent_items ri2 WHERE ri2.row_id > ri.row_id AND ri2.file = ri.file)");
                }
                sb.append(" ORDER BY row_id DESC");
                if (filter.getMaxItems() > 0) {
                    sb.append(" LIMIT ").append(filter.getMaxItems());
                }
                String build = sb.build();
                PreparedStatement s = conn.prepareStatement(build);
                r.stream().forEachOrdered(l -> l.accept((Object)s));
                ResultSet rs = s.executeQuery();
                boolean res = rs.next();
                if (res) {
                    if (this.max_row_id == 0L) {
                        this.max_row_id = rs.getLong("row_id");
                    }
                    ldt = LocalDateTime.of(rs.getInt("file_year"), rs.getInt("file_month"), rs.getInt("file_day"), rs.getInt("file_hour"), rs.getInt("file_minute"), rs.getInt("file_second"), rs.getInt("file_nano"));
                    rc.add(new StoreItem<File>(new File(rs.getString("file")), ldt));
                }
                while (rs.next()) {
                    ldt = LocalDateTime.of(rs.getInt("file_year"), rs.getInt("file_month"), rs.getInt("file_day"), rs.getInt("file_hour"), rs.getInt("file_minute"), rs.getInt("file_second"), rs.getInt("file_nano"));
                    rc.add(new StoreItem<File>(new File(rs.getString("file")), ldt));
                    this.min_row_id = rs.getLong("row_id");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occured while fetching history", (Throwable)e);
        }
        return rc;
    }

    private long getMaxId(Connection c) throws SQLException {
        long maxId = 0L;
        Throwable throwable = null;
        Object var5_5 = null;
        try (Statement s = c.createStatement();){
            ResultSet rs = s.executeQuery("SELECT MAX(row_id) AS row_id FROM recent_items");
            rs.next();
            maxId = rs.getLong("row_id");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return maxId;
    }

    private void createTablesIfNeeded(Connection conn) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement s = conn.createStatement();){
                s.execute(new SQLBuilder("CREATE TABLE IF NOT EXISTS recent_items").append("(").append(" row_id INTEGER PRIMARY KEY, file TEXT, file_year integer, file_month integer, file_day integer").append(", file_hour integer, file_minute integer, file_second integer,").append("file_nano integer , context TEXT").append(")").build());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error while creating table", (Throwable)e);
        }
    }

    private Connection newConnection() {
        String url = "jdbc:sqlite:" + this.database;
        int i = 0;
        while (i++ < 3) {
            try {
                return DriverManager.getConnection(url);
            }
            catch (Exception e) {
                LOGGER.error("Error getting connection", (Throwable)e);
                ThreadUtils.sleep((int)100);
            }
        }
        return null;
    }

    private void appendDateFilter(SQLBuilder sb, RecentFilter filter) {
        LocalDate to;
        LocalDate from = filter.getFrom();
        if (from != null) {
            int year = from.getYear();
            int month = from.getMonthValue();
            int day = from.getDayOfMonth();
            sb.append(" AND file_year * 5000 + file_month * 100 + file_day >= ").append(year * 5000 + month * 100 + day);
        }
        if ((to = filter.getTo()) != null) {
            int year = to.getYear();
            int month = to.getMonthValue();
            int day = to.getDayOfMonth();
            sb.append(" AND file_year * 5000 + file_month * 100 + file_day <= ").append(year * 5000 + month * 100 + day);
        }
    }

    @Override
    public void resetItems() {
        this.min_row_id = 0L;
        this.max_row_id = 0L;
    }
}

