/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.recent;

import com.sigge.filerunner.core.StoreItem;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public interface ItemStorer<E, F> {
    public boolean storeItems(List<StoreItem<E>> var1);

    default public boolean storeItem(StoreItem<E> item) {
        return this.storeItems(Arrays.asList(item));
    }

    default public boolean deleteItem(StoreItem<E> item) {
        throw new UnsupportedOperationException("Delete not supported");
    }

    default public boolean store(List<E> items) {
        return this.storeItems(items.stream().map(i -> new StoreItem<Object>(i, 0)).collect(Collectors.toList()));
    }

    default public void updateItem(StoreItem item) {
        throw new UnsupportedOperationException("Update not supported");
    }

    public List<StoreItem<E>> listItems();

    public List<StoreItem<E>> listItems(F var1);

    public void resetItems();
}

