/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.excel;

import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnType;
import com.sigge.filerunner.imports.core.ColumnEditor;
import com.sigge.filerunner.imports.core.ColumnSelected;
import com.sigge.filerunner.imports.core.FileImporterModel;
import com.sigge.filerunner.imports.core.HeaderRenderer;
import com.sigge.filerunner.imports.core.IPreviewer;
import com.sigge.filerunner.imports.core.InvalidImportFileException;
import com.sigge.filerunner.imports.core.MainFrame;
import com.sigge.filerunner.imports.core.PreviewTableModel;
import com.sigge.filerunner.imports.core.PreviewTableRenderer;
import com.sigge.filerunner.imports.excel.ExcelCellUtil;
import com.sigge.filerunner.imports.excel.ExcelHelper;
import com.sigge.filerunner.imports.excel.ExcelImportSettings;
import com.sigge.filerunner.imports.excel.ExcelPreviewView;
import com.sigge.filerunner.imports.excel.ExcelTypeDetector;
import com.sigge.filerunner.imports.excel.SimpleCellType;
import com.sigge.filerunner.view.core.VTable;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.core.ListUtils;
import com.siggemannen.core.Tuple;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.jdesktop.swingx.table.TableColumnExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelPreviewer
implements IPreviewer {
    private final FileImporterModel model;
    private final MainFrame view;
    private final int ROWS_TO_PREVIEW = 200;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelPreviewer.class);

    public ExcelPreviewer(FileImporterModel model, MainFrame view) {
        this.model = model;
        this.view = view;
    }

    @Override
    public void preview(File f) {
        ExcelImportSettings eis = this.model.getSettings() instanceof ExcelImportSettings ? (ExcelImportSettings)this.model.getSettings() : new ExcelImportSettings();
        this.model.setSettings(eis);
        eis.addListener((a, b, c) -> {
            if (ListUtils.in((Object)a, (Object[])new String[]{"includeRowNumberColumn", "detectDataType"})) {
                return;
            }
            try {
                this.previewInternal(f, eis);
            }
            catch (Exception e) {
                LOGGER.error("Error while previewing file", (Throwable)e);
                JOptionPane.showMessageDialog(this.view, "Something when wrong when previewing: " + e.getMessage());
            }
        });
        this.view.setCursor(new Cursor(3));
        new BackgroundRunner(() -> {
            try {
                this.previewInternal(f, eis);
                return null;
            }
            finally {
                this.view.setCursor(null);
            }
        }, e -> {}, e -> {
            LOGGER.error("Error while previewing", (Throwable)e);
            JOptionPane.showMessageDialog(this.view, "Something when wrong when previewing: " + e.getMessage());
        }).execute();
    }

    private void previewInternal(File f, ExcelImportSettings eis) throws InvalidImportFileException {
        ExcelTypeDetector detector;
        ArrayList<String> columns;
        int maxCols;
        Vector headers;
        Vector data;
        block28: {
            data = new Vector();
            headers = new Vector();
            maxCols = 0;
            int currentRow = 0;
            int currentCol = 0;
            int sheetNr = 0;
            columns = new ArrayList<String>();
            detector = new ExcelTypeDetector();
            try {
                Throwable throwable = null;
                Object var12_15 = null;
                try (Workbook wb = ExcelHelper.readWorkbook(f);){
                    if (eis.getSheet() > wb.getNumberOfSheets()) {
                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.view, String.format("Document only contains %d sheets but you specified %d", wb.getNumberOfSheets(), eis.getSheet())));
                        return;
                    }
                    for (Sheet sheet : wb) {
                        if (++sheetNr != eis.getSheet()) continue;
                        int headerRow = 1 + eis.getSkipBeforeHeader();
                        int firstRealRow = 1 + headerRow + eis.getSkipAfterHeader();
                        for (Row row : sheet) {
                            currentCol = 0;
                            ++currentRow;
                            Vector<Tuple<SimpleCellType, String>> d = new Vector<Tuple<SimpleCellType, String>>();
                            int xrow = 0;
                            while (xrow < Math.min(eis.getMaxColumns(), row.getLastCellNum())) {
                                Cell cell = row.getCell(xrow, Row.MissingCellPolicy.RETURN_NULL_AND_BLANK);
                                ++currentCol;
                                try {
                                    Tuple<SimpleCellType, String> e;
                                    Tuple<SimpleCellType, String> tuple = e = cell != null ? ExcelCellUtil.getCellTypeAndValue(cell) : null;
                                    if (currentRow == headerRow) {
                                        columns.add(e == null ? "" : (String)e.second());
                                    } else if (currentRow >= firstRealRow) {
                                        d.add((Tuple<SimpleCellType, String>)(e != null ? e.second() : e));
                                        if (e != null) {
                                            detector.addCol(xrow, (SimpleCellType)((Object)e.first()), (String)e.second());
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    LOGGER.error("Error while previewing file", (Throwable)e);
                                    System.out.println(String.format("Exception occuring reading value at row %d and column %d", xrow, currentCol));
                                }
                                maxCols = Math.max(maxCols, currentCol);
                                ++xrow;
                            }
                            if (currentRow >= firstRealRow) {
                                data.add(d);
                            }
                            if (currentRow - firstRealRow + 1 < 200) continue;
                            break block28;
                        }
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e1) {
                LOGGER.error("Error while previewing file", (Throwable)e1);
            }
        }
        int snapshot = columns.size();
        int c = 0;
        while (c < maxCols - snapshot) {
            columns.add("");
            ++c;
        }
        headers.clear();
        int i = 0;
        while (i < maxCols) {
            headers.add(columns.get(i));
            ++i;
        }
        ColumnSelected cs = new ColumnSelected(maxCols);
        eis.setColumnsSelected(cs);
        ArrayList<Column> sc = new ArrayList<Column>();
        eis.setDbColumns(sc);
        ExcelPreviewView epv = new ExcelPreviewView();
        epv.getSheetSpinner().setValue(eis.getSheet());
        epv.skipRowsAfterHeader.setValue(eis.getSkipAfterHeader());
        epv.skipRowsBeforeHeader.setValue(eis.getSkipBeforeHeader());
        epv.includeRowNumberColumn.setSelected(eis.isIncludeRowNumberColumn());
        epv.getSheetSpinner().addChangeListener(l -> eis.setSheet((Integer)epv.getSheetSpinner().getValue()));
        epv.skipRowsBeforeHeader.addChangeListener(l -> eis.setSkipBeforeHeader((Integer)excelPreviewView.skipRowsBeforeHeader.getValue()));
        epv.skipRowsAfterHeader.addChangeListener(l -> eis.setSkipAfterHeader((Integer)excelPreviewView.skipRowsAfterHeader.getValue()));
        epv.includeRowNumberColumn.addActionListener(l -> eis.setIncludeRowNumberColumn(excelPreviewView.includeRowNumberColumn.isSelected()));
        epv.detectButton.addActionListener(al -> {
            TableModel m = epv.getGridTable().getModel();
            if (m instanceof PreviewTableModel) {
                PreviewTableModel pv = (PreviewTableModel)m;
                int i = 0;
                while (i < pv.getColumnCount()) {
                    epv.getGridTable().setValueAt(new Column("" + headers.get(i), this.getTypeFromCell(detector.getCellType(i))), 0, i);
                    ++i;
                }
            }
        });
        epv.resetTypes.addActionListener(al -> {
            TableModel m = epv.getGridTable().getModel();
            if (m instanceof PreviewTableModel) {
                PreviewTableModel pv = (PreviewTableModel)m;
                int answer = JOptionPane.showOptionDialog(this.view, "Do you want to reset all datatypes?", "Reset datatypes", 1, 1, null, new String[]{"Reset all", "Only reset autodetected", "Cancel"}, "Reset all");
                if (answer == 2) {
                    return;
                }
                int i = 0;
                while (i < pv.getColumnCount()) {
                    if (answer == 0) {
                        epv.getGridTable().setValueAt(ColumnType.TEXT, 0, i);
                    } else if (answer == 1) {
                        epv.getGridTable().setValueAt(ColumnType.TEXT, 0, i);
                    }
                    ++i;
                }
            }
        });
        epv.maxColumnsSpinner.addChangeListener(l -> eis.setMaxColumns((Integer)excelPreviewView.maxColumnsSpinner.getValue()));
        VTable gridTable = epv.getGridTable();
        if (maxCols > 6) {
            ((JTable)((Object)gridTable)).setAutoResizeMode(0);
        } else {
            ((JTable)((Object)gridTable)).setAutoResizeMode(4);
        }
        ((JTable)((Object)gridTable)).setModel(new PreviewTableModel(headers, data, sc));
        ColumnEditor cellEditor = new ColumnEditor();
        PreviewTableRenderer pv = new PreviewTableRenderer();
        int i2 = 0;
        while (i2 < maxCols) {
            TableColumnExt tc = (TableColumnExt)((JTable)((Object)gridTable)).getColumnModel().getColumn(i2);
            tc.setHeaderRenderer((TableCellRenderer)new HeaderRenderer(cs));
            tc.setToolTipText("" + headers.get(i2));
            tc.setCellRenderer((TableCellRenderer)pv);
            tc.setCellEditor((TableCellEditor)cellEditor);
            sc.add(new Column("" + headers.get(i2), ColumnType.TEXT));
            ++i2;
        }
        ((JTable)((Object)gridTable)).getTableHeader().addMouseListener(new MouseAdapter((JTable)((Object)gridTable), cs){
            private final /* synthetic */ JTable val$gridTable;
            private final /* synthetic */ ColumnSelected val$cs;
            {
                this.val$gridTable = jTable;
                this.val$cs = columnSelected;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = this.val$gridTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int modelColumn = this.val$gridTable.convertColumnIndexToModel(viewColumn);
                this.val$cs.toggle(modelColumn + 1);
                ((JTableHeader)e.getSource()).repaint();
            }
        });
        SwingUtilities.invokeLater(() -> {
            this.view.addPreviewPane(epv);
            this.view.setSize(this.view.getWidth(), 550);
            this.view.setPreferredSize(new Dimension(this.view.getWidth(), 550));
            this.view.revalidate();
            this.view.pack();
        });
    }

    private ColumnType getTypeFromCell(SimpleCellType cc) {
        switch (cc) {
            case BOOL: {
                return ColumnType.INT;
            }
            case DATE: {
                return ColumnType.DATETIME;
            }
            case FLOAT: {
                return ColumnType.FLOAT;
            }
            case INT: {
                return ColumnType.INT;
            }
        }
        return ColumnType.TEXT;
    }

    @Override
    public boolean accepts(File file) {
        return ExcelHelper.isExcelFile(file);
    }
}

