/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.csv;

import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.imports.core.FileImporterModel;
import com.sigge.filerunner.imports.core.IPreviewer;
import com.sigge.filerunner.imports.core.InvalidImportFileException;
import com.sigge.filerunner.imports.core.MainFrame;
import com.sigge.filerunner.imports.csv.CSVImportSettings;
import com.sigge.filerunner.imports.csv.CSVPreferenceHandler;
import java.io.File;

public class CSVPreviewer
implements IPreviewer {
    private final FileImporterModel model;
    private final MainFrame view;

    public CSVPreviewer(FileImporterModel model, MainFrame view) {
        this.model = model;
        this.view = view;
    }

    @Override
    public void preview(File f) throws InvalidImportFileException {
        if (!this.accepts(f)) {
            throw new InvalidImportFileException(InvalidImportFileException.Reason.UNSUPPORTED, "File " + f + " is not supported for csv, only .txt or .csv files are");
        }
        CSVPreferenceHandler cv = new CSVPreferenceHandler(this.model, this.view);
        CSVImportSettings csv = null;
        csv = !(this.model.getSettings() instanceof CSVImportSettings) ? new CSVImportSettings() : (CSVImportSettings)this.model.getSettings();
        cv.preview(csv);
        this.model.setSettings(csv);
    }

    @Override
    public boolean accepts(File file) {
        return file != null && file.exists() && file.isFile() && FileUtils.hasExtension(file, "txt", "csv");
    }
}

