/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import com.sigge.filerunner.imports.core.FileImporterModel;
import com.sigge.filerunner.imports.core.IPreviewer;
import com.sigge.filerunner.imports.core.MainFrame;
import com.sigge.filerunner.imports.csv.CSVPreviewer;
import com.sigge.filerunner.imports.excel.ExcelPreviewer;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class PreviewAction
extends AbstractAction {
    private final FileImporterModel model;
    private final MainFrame view;
    private boolean visible = false;
    private final List<IPreviewer> previewers = new ArrayList<IPreviewer>();

    public PreviewAction(FileImporterModel model, MainFrame view) {
        this.model = model;
        this.view = view;
        this.previewers.add(new ExcelPreviewer(model, view));
        this.previewers.add(new CSVPreviewer(model, view));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.view.previewButton.setText("Preview & Choose");
        if (this.visible) {
            this.view.previewPane.removeAll();
            this.view.previewPane.setVisible(false);
            this.view.getSplitPane().setDividerLocation(-1);
            this.view.setSize(this.view.getWidth(), 120);
            this.view.setPreferredSize(new Dimension(this.view.getWidth(), 120));
            this.view.getSplitPane().setEnabled(false);
            this.view.revalidate();
            this.view.getFrame().pack();
            this.visible = false;
        } else {
            this.visible = true;
            this.view.getSplitPane().setEnabled(true);
            this.preview();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void preview() {
        if (this.model.getFileName().length() > 0) {
            this.view.previewButton.setText("Hide preview");
            try {
                try {
                    this.view.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                    File f = new File(this.model.getFileName());
                    for (IPreviewer previewer : this.previewers) {
                        if (!previewer.accepts(f)) continue;
                        this.view.previewPane.setVisible(true);
                        previewer.preview(f);
                        this.view.getSplitPane().setDividerSize(0);
                        this.view.previewPane.revalidate();
                        break;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(this.view.getFrame(), "Couldn't preview excel file due to: " + e1.getMessage());
                    this.view.getFrame().setCursor(null);
                }
            }
            finally {
                this.view.getFrame().setCursor(null);
            }
        }
    }
}

