/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import com.sigge.filerunner.imports.core.ImportSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FileImporterModel {
    public static final String FILENAME = "fileName";
    public static final String TABLENAME = "tableName";
    public static final String MAX_COLUMNS = "maxColumns";
    public static final String SETTINGS = "settings";
    private String fileName = "";
    private String tableName = "";
    private int maxColumns;
    private ImportSettings settings = new ImportSettings();
    private final Map<String, List<FileModelListener>> modelMap = new HashMap<String, List<FileModelListener>>();

    public void addModelListener(String name, FileModelListener listener) {
        this.createOrGetListenerList(name).add(listener);
    }

    public void removeModelListener(String name, FileModelListener listener) {
        this.createOrGetListenerList(name).remove(listener);
    }

    private void fireProperty(String name, Object oldValue, Object newValue) {
        if (!Objects.equals(oldValue, newValue)) {
            this.createOrGetListenerList(name).forEach(l -> l.propertyChanged(name, newValue));
        }
    }

    private List<FileModelListener> createOrGetListenerList(String name) {
        return this.modelMap.computeIfAbsent(name, a -> new ArrayList());
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        String oldValue = this.fileName;
        this.fileName = fileName;
        this.fireProperty(FILENAME, oldValue, fileName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        String oldValue = this.tableName;
        this.tableName = tableName;
        this.fireProperty(TABLENAME, oldValue, tableName);
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    public void setMaxColumns(int maxColumns) {
        int oldValue = this.maxColumns;
        this.maxColumns = maxColumns;
        this.fireProperty(MAX_COLUMNS, oldValue, maxColumns);
    }

    public ImportSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ImportSettings settings) {
        ImportSettings oldValue = this.settings;
        this.settings = settings;
        this.fireProperty(SETTINGS, oldValue, settings);
    }

    public static interface FileModelListener {
        public void propertyChanged(String var1, Object var2);
    }
}

