/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.imports.core;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public final class DocumentSizeFilter
extends DocumentFilter {
    private final int maxSize;

    public DocumentSizeFilter(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (fb.getDocument().getLength() + text.length() <= this.maxSize) {
            super.replace(fb, offset, length, text, attrs);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
        if (fb.getDocument().getLength() + str.length() <= this.maxSize) {
            super.insertString(fb, offs, str, a);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

