/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.export.inserts;

import com.google.inject.Inject;
import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.table.ITableOperator;
import com.sigge.filerunner.export.inserts.IScripter;
import com.sigge.filerunner.sql.IOutput;
import com.sigge.filerunner.sql.OutputBuilder;
import com.sigge.filerunner.sql.OutputFormat;
import com.sigge.filerunner.view.IEditorManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Optional;

public class Scripter
implements IScripter {
    private final IEditorManager manager;

    @Inject
    Scripter(IEditorManager manager) {
        this.manager = manager;
    }

    @Override
    public Optional<File> script(OutputBuilder.ScriptOutput output, Database database, ResultSet rs) {
        FileOutputStream ios = null;
        IOutput actualOutput = output.getActualOutput();
        File f = null;
        try {
            switch (actualOutput.getFormat()) {
                case FILE: {
                    OutputBuilder.FileOutput fo = (OutputBuilder.FileOutput)actualOutput;
                    f = fo.getFile();
                    ios = new FileOutputStream(f);
                    break;
                }
                case NEW_WINDOW: 
                case CLIPBOARD: {
                    f = File.createTempFile("script_", ".sql");
                    ios = new FileOutputStream(f);
                }
            }
            if (ios == null) {
                return Optional.empty();
            }
            ITableOperator tableOperator = database.getDatabaseOperator().getTableOperator();
            long bytes = tableOperator.script(rs, (OutputStream)ios, output.getPreferences());
            ((OutputStream)ios).close();
            if (actualOutput.getFormat() == OutputFormat.NEW_WINDOW) {
                this.manager.openFiles(Arrays.asList(f));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.ofNullable(f);
    }
}

