/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.export.excel;

import com.sigge.filerunner.view.results.FieldType;
import com.sigge.filerunner.view.results.TimeStampWrapperHandler;
import com.siggemannen.core.MapBuilder;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import microsoft.sql.DateTimeOffset;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellUtil;

class ExcelHelper {
    ExcelHelper() {
    }

    static void setExcelValueFromResultSetColumn(FieldType fieldType, Object value, Cell cell, Workbook workbook) {
        if (value == null) {
            return;
        }
        switch (fieldType) {
            case SQLLONG: {
                cell.setCellValue((double)((Long)value).longValue());
                break;
            }
            case SQLINTEGER: 
            case SQLBOOLEAN: {
                cell.setCellValue((double)((Integer)value).intValue());
                break;
            }
            case SQLFLOAT: {
                cell.setCellValue(((Double)value).doubleValue());
                break;
            }
            case SQLDATE: {
                if (!TimeStampWrapperHandler.containsTimeInfo((Timestamp)value)) {
                    ExcelHelper.setDateWithoutTime(cell, (Timestamp)value, workbook);
                    break;
                }
                ExcelHelper.setDateWithTime(cell, (Timestamp)value, workbook);
                break;
            }
            case SQLDATEWITHZONE: {
                ExcelHelper.setDateWithTime(cell, ((DateTimeOffset)value).getTimestamp(), workbook);
                break;
            }
            case SQLGEOMETRY: {
                cell.setCellValue(value.toString());
                break;
            }
            case SQLSTRING: 
            case SQLXMLSTRING: {
                cell.setCellValue((String)value);
                break;
            }
            default: {
                throw new RuntimeException("Unknown SQL-type " + (Object)((Object)fieldType) + " detected while fetching column value");
            }
        }
    }

    private static void setDateWithTime(Cell cell, Date date, Workbook workbook) {
        short format = workbook.createDataFormat().getFormat("YYYY-MM-DD HH:MM:SS");
        CellUtil.setCellStyleProperties((Cell)cell, (Map)new MapBuilder().append((Object)"dataFormat", (Object)format).build());
        cell.setCellValue(date);
    }

    private static void setDateWithoutTime(Cell cell, Timestamp date, Workbook workbook) {
        short format = workbook.createDataFormat().getFormat("YYYY-MM-DD");
        CellUtil.setCellStyleProperties((Cell)cell, (Map)new MapBuilder().append((Object)"dataFormat", (Object)format).build());
        cell.setCellValue((Date)date);
    }
}

