/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.export;

import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.export.ExportResult;
import com.sigge.filerunner.export.IExporter;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.IIcon;
import com.sigge.filerunner.view.core.ILabel;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.siggemannen.binding.ValueHolder;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import com.siggemannen.view.ICompletionProgress;
import com.siggemannen.view.UIBackgroundRunner;
import com.siggemannen.view.UIOptionBuilderSupplier;
import com.siggemannen.view.UIOptionSupplier;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.RootPaneContainer;
import javax.swing.filechooser.FileNameExtensionFilter;

public abstract class ExportAction<T>
implements ILabel,
IIcon {
    IExporter<T> iexporter;
    protected final JFrame container;
    private final String name;

    public ExportAction(String actionName, IExporter<T> exporter, JFrame container) {
        this.name = actionName;
        this.iexporter = exporter;
        this.container = container;
    }

    @Override
    public String getLabel() {
        return this.name;
    }

    public void export(List<IResultSetTable> model, boolean selectionOnly, ThrowingConsumer<ExportResult> callback) {
        T preferences = this.getPreferences(model, selectionOnly);
        if (model.size() > 1 && this.isFilePerModel(model, selectionOnly)) {
            ArrayList<File> re = new ArrayList<File>();
            ThrowingConsumer cx = e -> {
                if (e.isSuccessful()) {
                    re.addAll(e.filesExported());
                }
            };
            for (IResultSetTable m : model) {
                String file = this.getFile(preferences);
                if (file == null) break;
                ValueHolder vh = new ValueHolder();
                UIOptionSupplier ui = (UIOptionSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)new UIOptionBuilderSupplier(() -> this.export(file, Arrays.asList(m), selectionOnly, preferences, (ICompletionProgress)vh.getValue()), cx).mainPanel((RootPaneContainer)this.container)).title("Exporting file", "Exporting files...", "Cancel export")).exceptionCallback(ex -> cx.accept((Object)new ExportResult((Exception)ex)))).dialogIcon(IconUtils.getIcon("flash.png").getImage())).completionProgress((Consumer)vh)).build();
                UIBackgroundRunner.execute((UIOptionSupplier)ui);
                if (!((ICompletionProgress)vh.getValue()).isCancelled()) {
                    JOptionPane.showMessageDialog(this.container.getContentPane(), "File " + file + " was exported");
                    continue;
                }
                JOptionPane.showMessageDialog(this.container.getContentPane(), "Export was cancelled");
            }
            if (re.size() > 0) {
                callback.accept((Object)new ExportResult(re));
            } else {
                callback.accept((Object)new ExportResult(""));
            }
            return;
        }
        String file = this.getFile(preferences);
        if (file != null) {
            ValueHolder vh = new ValueHolder();
            UIOptionSupplier ui = (UIOptionSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)new UIOptionBuilderSupplier(() -> this.export(file, model, selectionOnly, preferences, (ICompletionProgress)vh.getValue()), callback).mainPanel((RootPaneContainer)this.container)).title("Exporting file", "Exporting files...", "Cancel export")).exceptionCallback(ex -> callback.accept((Object)new ExportResult((Exception)ex)))).dialogIcon(IconUtils.getIcon("flash.png").getImage())).completionProgress((Consumer)vh)).build();
            UIBackgroundRunner.execute((UIOptionSupplier)ui);
        }
    }

    protected boolean isFilePerModel(List<IResultSetTable> model, boolean selectionOnly) {
        return false;
    }

    public T getPreferences(List<IResultSetTable> model, boolean selectionOnly) {
        return null;
    }

    public abstract String getFile(T var1);

    /*
     * Exception decompiling
     */
    public ExportResult export(String file, List<IResultSetTable> model, boolean selectionOnly, T preferences, ICompletionProgress progress) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getFileToExportTo(String preferredName, FileNameExtensionFilter ... ff) {
        File f = FileUtils.saveFile(this.container != null ? this.container.getRootPane() : null, preferredName, ff);
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public String getFileToExportTo(FileNameExtensionFilter ... ff) {
        File f = FileUtils.saveFile(this.container != null ? this.container.getRootPane() : null, null, ff);
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }
}

