/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core.executors;

import com.sigge.filerunner.core.executors.BackgroundExecutor;
import com.sigge.filerunner.core.executors.IBackgroundExecutor;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import com.siggemannen.functional.throwing.ThrowingSupplier;

public class RecurringExecutionContext {
    private volatile IBackgroundExecutor.ICancellationToken token;

    public <T> void execute(ThrowingSupplier<T> supplier, ThrowingConsumer<T> consumer) {
        this.cancel();
        BackgroundExecutor.EXECUTOR.execute(ct -> {
            this.token = ct;
            return supplier.get();
        }, result -> {
            if (this.token != null && !this.token.isCancelled()) {
                consumer.accept(result);
                this.token = null;
            }
        });
    }

    public synchronized void cancel() {
        if (this.token != null) {
            this.token.cancel();
        }
    }
}

