/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core.executors;

import com.sigge.filerunner.core.executors.IBackgroundExecutor;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import com.siggemannen.functional.throwing.ThrowingFunction;
import com.siggemannen.functional.throwing.ThrowingRunnable;
import com.siggemannen.functional.throwing.ThrowingSupplier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class BackgroundExecutor
implements IBackgroundExecutor {
    private ExecutorService service = Executors.newWorkStealingPool();
    private volatile boolean shutdown;
    public static BackgroundExecutor EXECUTOR = new BackgroundExecutor();

    BackgroundExecutor() {
    }

    @Override
    public void close() throws IOException {
        this.shutdown = true;
        this.service.shutdownNow();
    }

    ExecutorService getService() {
        return this.service;
    }

    @Override
    public void executeAndForget(ThrowingRunnable tr) {
        this.service.submit((Runnable)this.wrap(tr));
    }

    ThrowingRunnable wrap(ThrowingRunnable tr) {
        return () -> {
            if (this.shutdown) {
                return;
            }
            try {
                tr.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
    }

    <T> ThrowingSupplier<T> wrap(ThrowingSupplier<T> tr) {
        return () -> {
            if (this.shutdown) {
                return null;
            }
            try {
                return tr.get();
            }
            catch (Exception exception) {
                return null;
            }
        };
    }

    @Override
    public <T> void executeAndForget(ThrowingSupplier<T> tr) {
        this.service.submit(this.wrap(tr));
    }

    @Override
    public <T> void execute(ThrowingSupplier<T> supplier, ThrowingConsumer<T> consumer) {
        this.execute(ct -> supplier.get(), consumer);
    }

    @Override
    public <T> void execute(ThrowingFunction<IBackgroundExecutor.ICancellationToken, T> supplier, ThrowingConsumer<T> consumer) {
        CancellationToken ct = new CancellationToken();
        this.service.submit(() -> {
            try {
                if (ct.isCancelled() || this.shutdown) {
                    return;
                }
                Object value = supplier.apply((Object)ct);
                if (ct.isCancelled() || this.shutdown) {
                    return;
                }
                consumer.accept(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static class CancellationToken
    implements IBackgroundExecutor.ICancellationToken {
        private volatile boolean cancelled = false;
        List<ThrowingRunnable> listeners = new ArrayList<ThrowingRunnable>();

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.listeners.forEach(ThrowingRunnable::run);
        }

        @Override
        public void addListener(ThrowingRunnable cancelListener) {
            this.listeners.add(cancelListener);
        }

        @Override
        public void removeListener(ThrowingRunnable cancelListener) {
            this.listeners.remove(cancelListener);
        }
    }
}

