/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessUtils.class);

    public static void browseToFile(File f) {
        try {
            if (ProcessUtils.isOnWindows()) {
                Runtime.getRuntime().exec("explorer.exe /select," + ProcessUtils.getFixedFilePath(f));
                return;
            }
            if (ProcessUtils.isOnMac()) {
                ProcessUtils.runCommand("open", "-R", ProcessUtils.getFixedFilePath(f));
                return;
            }
            if (ProcessUtils.isOnLinux()) {
                if (ProcessUtils.runCommand("dolphin", ProcessUtils.getFixedFilePath(f), " --select")) {
                    return;
                }
                if (ProcessUtils.runCommand("nautilus", ProcessUtils.getFixedFilePath(f))) {
                    return;
                }
                if (ProcessUtils.runCommand("kde-open", ProcessUtils.getFixedFilePath(f.getParentFile()))) {
                    return;
                }
                if (ProcessUtils.runCommand("gnome-open", ProcessUtils.getFixedFilePath(f.getParentFile()))) {
                    return;
                }
                if (ProcessUtils.runCommand("xdg-open", ProcessUtils.getFixedFilePath(f.getParentFile()))) {
                    return;
                }
            }
            if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(f.getParentFile().toURI());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while browsing file " + f, (Throwable)e);
        }
    }

    private static String getFixedFilePath(File f) {
        return "\"" + f.getAbsolutePath() + "\"";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean runCommand(String ... command) {
        try {
            Process p = Runtime.getRuntime().exec(command);
            if (p == null) {
                return false;
            }
            try {
                if (p.exitValue() == 0) {
                    return false;
                }
                return false;
            }
            catch (IllegalThreadStateException itse) {
                return true;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isOnWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isOnMac() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    public static boolean isOnLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }
}

