/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;

public class LowLevelKeyListener
implements KeyListener {
    private boolean ctrlPressed;
    private boolean tabPressed;
    private boolean shiftPressed;
    private final List<LowLevelKeyEventListener> listeners = new ArrayList<LowLevelKeyEventListener>();

    public void addListener(LowLevelKeyEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LowLevelKeyEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        String keyText = KeyEvent.getKeyText(e.getKeyCode());
        if ("Ctrl".equals(keyText)) {
            this.ctrlPressed = true;
        } else if ("Shift".equals(keyText)) {
            this.shiftPressed = true;
        } else if ("Tab".equals(keyText)) {
            this.tabPressed = true;
        }
        if (!e.isControlDown() && this.ctrlPressed) {
            this.ctrlPressed = false;
        }
        this.listeners.stream().forEachOrdered(l -> {
            boolean bl = l.pressed(new LowLevelKeyPressedEvent(e.getComponent(), keyText, this.ctrlPressed, this.tabPressed, this.shiftPressed));
        });
    }

    @Override
    public void keyReleased(KeyEvent e) {
        String keyText = KeyEvent.getKeyText(e.getKeyCode());
        if ("Ctrl".equals(keyText)) {
            this.ctrlPressed = false;
        } else if ("Shift".equals(keyText)) {
            this.shiftPressed = false;
        } else if ("Tab".equals(keyText)) {
            this.tabPressed = false;
        }
        this.listeners.stream().forEachOrdered(l -> {
            boolean bl = l.released(new LowLevelKeyReleasedEvent(e.getComponent(), keyText, this.ctrlPressed, this.tabPressed, this.shiftPressed));
        });
    }

    private abstract class ALowLevelKeyEvent
    implements ILowLevelKeyEvent {
        protected boolean ctrlPressedInner;
        protected boolean tabPressedInner;
        protected boolean shiftPressedInner;

        private ALowLevelKeyEvent() {
        }

        @Override
        public boolean isCtrlPressed() {
            return this.ctrlPressedInner;
        }

        @Override
        public boolean isTabPressed() {
            return this.tabPressedInner;
        }

        @Override
        public boolean isShiftPressed() {
            return this.shiftPressedInner;
        }
    }

    private static interface ILowLevelKeyEvent {
        public boolean isCtrlPressed();

        public boolean isTabPressed();

        public boolean isShiftPressed();
    }

    public static interface ILowLevelKeyPressedEvent
    extends ILowLevelKeyEvent {
        public String keyPressed();
    }

    public static interface ILowLevelKeyReleasedEvent
    extends ILowLevelKeyEvent {
        public String keyReleased();
    }

    public static interface LowLevelKeyEventListener {
        public boolean released(ILowLevelKeyReleasedEvent var1);

        public boolean pressed(ILowLevelKeyPressedEvent var1);
    }

    private class LowLevelKeyPressedEvent
    extends ALowLevelKeyEvent
    implements ILowLevelKeyPressedEvent {
        private final String keyPressed;
        private final Component source;

        LowLevelKeyPressedEvent(Component source, String keyPressed, boolean ctrlPressed, boolean tabPressed, boolean shiftPressed) {
            this.source = source;
            this.keyPressed = keyPressed;
            this.ctrlPressedInner = ctrlPressed;
            this.tabPressedInner = tabPressed;
            this.shiftPressedInner = shiftPressed;
        }

        @Override
        public String keyPressed() {
            return this.keyPressed;
        }

        public String toString() {
            return String.format("Pressed, source: %s, pressed: %s, ctrl: %b tab: %b shift: %b", this.source, this.keyPressed, this.ctrlPressedInner, this.tabPressedInner, this.shiftPressedInner);
        }
    }

    private class LowLevelKeyReleasedEvent
    extends ALowLevelKeyEvent
    implements ILowLevelKeyReleasedEvent {
        private final String keyReleased;
        private final Component source;

        LowLevelKeyReleasedEvent(Component source, String keyReleased, boolean ctrlPressed, boolean tabPressed, boolean shiftPressed) {
            this.source = source;
            this.keyReleased = keyReleased;
            this.ctrlPressedInner = ctrlPressed;
            this.tabPressedInner = tabPressed;
            this.shiftPressedInner = shiftPressed;
        }

        @Override
        public String keyReleased() {
            return this.keyReleased;
        }

        public String toString() {
            return String.format("Released, source: %s: %s, ctrl: %b tab: %b shift: %b", this.source, this.keyReleased, this.ctrlPressedInner, this.tabPressedInner, this.shiftPressedInner);
        }
    }
}

