/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HighlightingFilter {
    private final Map<Character, List<Integer>> index = new HashMap<Character, List<Integer>>();
    private final int length;

    public HighlightingFilter(String filter) {
        filter = filter.replaceAll("\\s+", "").toLowerCase();
        this.length = filter.length();
        int i = 0;
        while (i < filter.length()) {
            this.index.computeIfAbsent(Character.valueOf(filter.charAt(i)), ArrayList::new).add(i);
            ++i;
        }
    }

    Set<Integer> process(String result) {
        List<Object> results = new ArrayList();
        int i = 0;
        while (i < result.length()) {
            Character c = Character.valueOf(result.charAt(i));
            List<Integer> lis = this.index.get(c);
            if (lis != null) {
                for (Integer ix : lis) {
                    if (ix == 0) {
                        LinkedHashSet<Integer> iz = new LinkedHashSet<Integer>();
                        iz.add(i);
                        results.add(iz);
                        continue;
                    }
                    int len = results.size();
                    int l = 0;
                    while (l < len) {
                        Set lix = (Set)results.get(l);
                        if (lix.size() == ix.intValue()) {
                            LinkedHashSet sex = new LinkedHashSet(lix);
                            results.add(sex);
                            lix.add(i);
                        }
                        ++l;
                    }
                }
            }
            ++i;
        }
        i = results.size() - 1;
        while (i >= 0) {
            if (((Set)results.get(i)).size() < this.length) {
                results.remove(i);
            }
            --i;
        }
        if (results.size() == 0) {
            return Collections.EMPTY_SET;
        }
        results = new LinkedHashSet(results).stream().collect(Collectors.toList());
        HashMap<Integer, Integer> islands = new HashMap<Integer, Integer>();
        int cnt = 0;
        while (cnt < results.size()) {
            Set list = (Set)results.get(cnt);
            int prevValue = -1;
            int sumDiffs = 0;
            for (Integer curr : list) {
                if (prevValue != -1 && curr - prevValue > 1) {
                    ++sumDiffs;
                }
                prevValue = curr;
            }
            islands.put(cnt, sumDiffs);
            ++cnt;
        }
        int idx = (Integer)islands.keySet().stream().sorted((k, v) -> ((Integer)islands.get(k)).compareTo((Integer)islands.get(v))).findFirst().get();
        return (Set)results.get(idx);
    }

    public String highlight(String value) {
        Set<Integer> result = this.process(value.toLowerCase());
        StringBuilder sb = new StringBuilder();
        int prev = -1;
        for (Integer val : result) {
            if (prev + 1 < val) {
                sb.append(value.substring(prev + 1, val));
            }
            prev = val;
            sb.append("<span color='#0033cc'>");
            sb.append("<b>");
            sb.append(value.charAt(val));
            sb.append("</b></span>");
        }
        if (prev + 1 < value.length()) {
            sb.append(value.substring(prev + 1, value.length()));
        }
        return sb.toString();
    }
}

