/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.sigge.filerunner.config.ColorTypeAdapter;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonFactory {
    public static final String DEFAULT_FILE_ENCODING = "UTF-8";
    private static final Logger LOGGER = LoggerFactory.getLogger(GsonFactory.class);

    public static Gson forReading() {
        return new GsonBuilder().registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter()).setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();
    }

    public static Gson forWriting() {
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter()).create();
    }

    public static <T> T read(String file, Type typeToken) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), DEFAULT_FILE_ENCODING);){
            return (T)GsonFactory.forReading().fromJson((Reader)reader, typeToken);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Type getType(final Class<?> rawClass, final Class<?> ... parameters) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                Type[] type = new Type[parameters.length];
                int i = 0;
                while (i < parameters.length) {
                    type[i] = parameters[i];
                    ++i;
                }
                return type;
            }

            @Override
            public Type getRawType() {
                return rawClass;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    public static <T> T read(String file, Class<?> rawClass, Class<?> ... parameters) throws Exception {
        return GsonFactory.read(file, GsonFactory.getType(rawClass, parameters));
    }

    public static <T> void write(String file, T object) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_FILE_ENCODING);){
                GsonFactory.forWriting().toJson(object, (Appendable)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save the file for some reason", (Throwable)e);
        }
    }
}

