/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class Encrypter {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final int ITERATION_COUNT = 65536;
    private static final int KEY_STRENGTH = 128;
    private static final String KEY_ALGO = "PBKDF2WithHmacSHA1";
    private static final String CIPHER_ALGO = "AES/CFB/NoPadding";
    private static final String KEY_SPEC_ALGO = "AES";
    private static final String VERSION_STRING = "v1";
    private static final InvalidKeyException IKE = new InvalidKeyException("Invalid key");

    public static String encrypt(String passphrase, String data) throws Exception {
        return Encrypter.encrypt(passphrase.toCharArray(), data);
    }

    public static String encrypt(char[] passphrase, String data) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(KEY_ALGO);
        byte[] salt = Encrypter.salt();
        PBEKeySpec spec = new PBEKeySpec(passphrase, salt, 65536, 128);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec key = new SecretKeySpec(tmp.getEncoded(), KEY_SPEC_ALGO);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGO);
        cipher.init(1, key);
        cipher.update(VERSION_STRING.getBytes(DEFAULT_ENCODING));
        byte[] bytes = cipher.doFinal(data.getBytes(DEFAULT_ENCODING));
        byte[] iv = cipher.getIV();
        StringBuilder sb = new StringBuilder();
        sb.append(VERSION_STRING).append(":");
        sb.append(Base64.getEncoder().encodeToString(iv)).append(":");
        sb.append(Base64.getEncoder().encodeToString(salt)).append(":");
        sb.append(Base64.getEncoder().encodeToString(bytes));
        return sb.toString();
    }

    public static String decrypt(String decodeStr, String password) throws Exception {
        return Encrypter.decrypt(decodeStr, password.toCharArray());
    }

    public static String decrypt(String decodeStr, char[] password) throws Exception {
        if (!decodeStr.contains(":")) {
            throw IKE;
        }
        String[] data = decodeStr.split(":");
        if (data.length != 4) {
            throw IKE;
        }
        String version = data[0];
        if (version == null || version.length() < 2 || version.length() > 100) {
            throw IKE;
        }
        byte[] iv = Base64.getDecoder().decode(data[1]);
        byte[] salt = Base64.getDecoder().decode(data[2]);
        byte[] dataPart = Base64.getDecoder().decode(data[3]);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGO);
        PBEKeySpec spec = new PBEKeySpec(password, salt, 65536, 128);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(KEY_ALGO);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec key = new SecretKeySpec(tmp.getEncoded(), KEY_SPEC_ALGO);
        IvParameterSpec ivp = new IvParameterSpec(iv);
        cipher.init(2, (Key)key, ivp);
        byte[] decryptedBytes = cipher.doFinal(dataPart);
        String decryptedText = new String(decryptedBytes, DEFAULT_ENCODING);
        if (decryptedText.length() <= version.length()) {
            throw IKE;
        }
        String versionKey = decryptedText.substring(0, version.length());
        if (!version.equals(versionKey)) {
            throw IKE;
        }
        return decryptedText.substring(version.length());
    }

    private static byte[] salt() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_SPEC_ALGO);
        SecureRandom secureRandom = new SecureRandom();
        int keyBitSize = 256;
        keyGenerator.init(keyBitSize, secureRandom);
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }
}

