/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import com.sigge.filerunner.view.IconUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.KeyStroke;

public class ButtonUtils {
    public static <E extends AbstractButton> E createToolbarButton(Supplier<E> supplier, String text, String icon, boolean smallIcons, final Runnable action, KeyStroke ... strokes) {
        AbstractButton button = (AbstractButton)supplier.get();
        button.setText(text);
        AbstractAction buttonAction = new AbstractAction(text, icon == null ? null : (smallIcons ? IconUtils.getSmallIcon(icon) : IconUtils.getIcon(icon))){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (action != null) {
                    action.run();
                }
            }
        };
        button.setAction(buttonAction);
        if (smallIcons) {
            button.setHorizontalTextPosition(4);
        } else {
            button.setVerticalTextPosition(3);
        }
        button.setFocusable(false);
        KeyStroke[] keyStrokeArray = strokes;
        int n = strokes.length;
        int n2 = 0;
        while (n2 < n) {
            KeyStroke stroke = keyStrokeArray[n2];
            button.getInputMap(2).put(stroke, text);
            ++n2;
        }
        button.getActionMap().put(text, buttonAction);
        return (E)button;
    }

    public static boolean isRightClick(MouseEvent e) {
        return e.getButton() == 3 || System.getProperty("os.name").contains("Mac OS X") && (e.getModifiers() & 0x10) != 0 && (e.getModifiers() & 2) != 0;
    }

    public static void insertMouseListener(Component component, int index, MouseListener l) {
        MouseListener listener;
        MouseListener[] listeners = component.getMouseListeners();
        int i = 0;
        while (i < listeners.length) {
            listener = listeners[i];
            component.removeMouseListener(listener);
            ++i;
        }
        i = 0;
        while (i < listeners.length) {
            listener = listeners[i];
            if (index == i) {
                component.addMouseListener(l);
            }
            component.addMouseListener(listener);
            ++i;
        }
        if (index > listeners.length - 1) {
            component.addMouseListener(l);
        }
    }
}

