/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion.domain;

import com.google.gson.Gson;
import com.sigge.dbrunner.Database;
import com.sigge.filerunner.completion.domain.IServerConfigHandler;
import com.sigge.filerunner.completion.domain.SQLObjectUsage;
import com.sigge.filerunner.completion.domain.ServerConfigStorage;
import com.sigge.filerunner.completion.domain.ServerContextStorage;
import com.sigge.filerunner.core.GsonFactory;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.DatabaseFromConfig;
import com.sigge.filerunner.sql.ServerDatabase;
import com.siggemannen.backgroundrunner.AccumulatedBackgroundRunner;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConfig
implements IServerConfigHandler {
    private final ServerConfigStorage STORAGE;
    private static final String SETTING_FILE_ENCODING = "UTF-8";
    private static final Gson GSON_WRITER = GsonFactory.forWriting();
    private final String fileName;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerConfig.class);

    public ServerConfig(String fileName) {
        ServerConfigStorage temp;
        block12: {
            this.fileName = fileName;
            temp = new ServerConfigStorage();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileName), SETTING_FILE_ENCODING);){
                    ServerConfigStorage storage = (ServerConfigStorage)GsonFactory.forReading().fromJson((Reader)reader, ServerConfigStorage.class);
                    if (storage != null) {
                        temp = storage;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) break block12;
                LOGGER.error("Couldn't load config file", (Object)fileName);
            }
        }
        this.STORAGE = temp;
    }

    @Override
    public void save() {
        AccumulatedBackgroundRunner.schedule((String)("save" + this.fileName), () -> this.store(), (int)300, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void store() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName), SETTING_FILE_ENCODING);){
                GSON_WRITER.toJson((Object)this.STORAGE, (Appendable)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save geo file for some reason", (Throwable)e);
        }
    }

    public Map<Integer, ServerContextStorage> getConfig() {
        return this.STORAGE.getServerConfig();
    }

    @Override
    public synchronized Map<String, SQLObjectUsage> getUsages(DatabaseContext context, Optional<String> section) {
        ServerDatabase db = context.getDatabase();
        Database server = db.getDb();
        String database = db.getDatabase();
        if (server instanceof DatabaseFromConfig) {
            DatabaseFromConfig conf = (DatabaseFromConfig)server;
            int id = conf.getConfig().getId();
            return this.STORAGE.getServerConfig().computeIfAbsent(id, e -> new ServerContextStorage()).getUsageConfig().computeIfAbsent(database, d -> new HashMap());
        }
        return new HashMap<String, SQLObjectUsage>();
    }
}

