/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion.domain;

import com.sigge.filerunner.completion.domain.FunctionArgs;
import com.sigge.filerunner.completion.domain.FunctionDocX;
import com.sigge.filerunner.completion.domain.SQLBaseFunctionCompletion;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLParam;
import com.sigge.filerunner.completion.domain.SQLSubObject;
import com.sigge.filerunner.core.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;

public class SQLFunctionCompletion
extends SQLBaseFunctionCompletion {
    private String longDesc;

    public SQLFunctionCompletion(CompletionProvider provider, SQLObject object, Icon icon, int relevance, boolean appendSchema) {
        super(provider, object, icon, relevance, appendSchema);
        this.setShortDescription(object.getContext().getQuotedIdentifier(object.getName()));
        this.setIcon(icon);
        this.setRelevance(relevance);
        FunctionDocX doc = (FunctionDocX)object.getCustomProperty("doc");
        if (doc != null) {
            this.longDesc = doc.getDescription().replace("\n", "<br>");
        }
        int paramCount = 0;
        List<FunctionArgs> args = doc != null ? doc.getArgs() : Collections.EMPTY_LIST;
        int i = 0;
        while (i < args.size()) {
            if (this.getParamCount() > i) {
                FunctionArgs functionArgs = args.get(i);
                this.getParam(i).setDescription(functionArgs.getDescription());
            }
            ++i;
        }
        ArrayList<ParameterizedCompletion.Parameter> params = new ArrayList<ParameterizedCompletion.Parameter>();
        for (SQLSubObject sQLSubObject : object.getParameters()) {
            if (sQLSubObject.getName().length() == 0) continue;
            params.add(this.createParamFromParameter(sQLSubObject, args.size() > paramCount ? args.get(paramCount).getName() : null, args.size() > paramCount ? args.get(paramCount).getDescription() : null));
            ++paramCount;
        }
        this.setParams(params);
    }

    private SQLParam createParamFromParameter(SQLSubObject sox, String alternativeName, String desc) {
        return new SQLParam.SQLParamBuilder(sox.getType(), StringUtils.isBlank(alternativeName, sox.getName())).defaultValue(sox.getCustomProperty("DEFAULT", null)).output(sox.getCustomProperty("PARAMETER_OUTPUT", false)).optional(sox.getCustomProperty("PARAMETER_OPTIONAL", false)).variadic(sox.getCustomProperty("PARAMETER_VARARG", false)).extra(sox.getCustomProperty("Extra", null)).description(desc).build();
    }

    @Override
    public String getSummary() {
        return String.valueOf(this.longDesc != null ? String.valueOf(this.longDesc.replace("\n", "<br>")) + "<br><br>" : "") + super.getSummary();
    }

    public String getName() {
        return this.object.getName();
    }

    public String getReplacementText() {
        return this.appendSchema && !this.object.getSchemaName().isEmpty() ? String.valueOf(this.object.getSchemaName()) + "." + this.object.getName() : this.object.getName();
    }
}

