/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion;

import com.sigge.filerunner.completion.CompletionXMLParser;
import com.sigge.filerunner.completion.domain.CompletionTemplate;
import com.sigge.filerunner.core.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.TemplateCompletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletionManager.class);

    public static DefaultCompletionProvider createProvider() {
        DefaultCompletionProvider provider = new DefaultCompletionProvider();
        File temp = new File("templates");
        if (!temp.exists()) {
            return provider;
        }
        ArrayList<CompletionTemplate> completionTemplates = new ArrayList<CompletionTemplate>();
        try {
            List files = Files.walk(Paths.get(temp.getAbsolutePath(), new String[0]), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(l -> FileUtils.hasExtension(l, "xml")).map(file -> file.toFile()).filter(l -> !l.getName().startsWith("_")).collect(Collectors.toList());
            if (files.size() == 0) {
                return provider;
            }
            CompletionXMLParser cp = new CompletionXMLParser();
            for (File l2 : files) {
                try {
                    completionTemplates.addAll(cp.parseXML(l2));
                }
                catch (Exception e) {
                    LOGGER.error("Error loading file {}: {}", (Object)l2, (Object)e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while walking template folder", (Throwable)e);
        }
        for (CompletionTemplate compTemplate : completionTemplates) {
            provider.addCompletion((Completion)new TemplateCompletion((CompletionProvider)provider, compTemplate.getKeywords(), compTemplate.getDescription(), compTemplate.getText()));
        }
        return provider;
    }
}

