/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.commands;

import com.sigge.parsql.sql.transform.ISQLToken;
import com.sigge.parsql.sql.transform.TSQLLexer;
import com.sigge.parsql.sql.transform.Token;
import com.sigge.parsql.sql.transform.TokenType;
import com.sigge.parsql.sql.transform.TokenUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.UIManager;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RecordableTextAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeywordsFormatter
extends RecordableTextAction {
    private static Set<String> KEYWORDS_TO_TAB = new HashSet<String>(Arrays.asList("SELECT", "FROM", "UPDATE", "SET", "WHERE", "ON", "EXEC"));
    private static final Logger LOGGER = LoggerFactory.getLogger(KeywordsFormatter.class);

    public KeywordsFormatter(String text) {
        super(text);
    }

    public String transform(String text, int tabSize) {
        try {
            List tokens = TSQLLexer.parse((String)text);
            if (tokens.size() > 0) {
                StringBuilder sb = new StringBuilder(text.length());
                int copiedSoFar = -1;
                int i = 0;
                while (i < tokens.size()) {
                    ISQLToken keyword = (ISQLToken)tokens.get(i);
                    String keywordInText = text.substring(keyword.getStart(), keyword.getEnd() + 1);
                    if (keyword.getTokenType() == TokenType.KEYWORD && KEYWORDS_TO_TAB.contains(keywordInText.toUpperCase())) {
                        this.normalizeStart(text, sb, tokens, i, copiedSoFar, tabSize);
                        sb.append(text.substring(keyword.getStart(), keyword.getEnd() + 1).toUpperCase());
                        if (i + 1 == tokens.size()) break;
                        NormalizePair p = this.normalizeAfter(text, sb, tokens, i);
                        copiedSoFar = p.charsCopiedNew;
                        i = p.newToken;
                    } else {
                        if (keyword.getStart() > copiedSoFar + 1) {
                            sb.append(text.substring(copiedSoFar + 1, keyword.getStart()));
                        }
                        sb.append(keyword.getTokenType() == TokenType.KEYWORD ? keywordInText.toUpperCase() : keywordInText);
                        copiedSoFar = keyword.getEnd();
                    }
                    ++i;
                }
                return sb.toString();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while formatting", (Throwable)e);
        }
        return text;
    }

    private NormalizePair normalizeAfter(String text, StringBuilder sb, List<ISQLToken> keywords, int currentToken) {
        List tokens = TokenUtils.getTokensUntilNewLine((String)text, keywords, (int)currentToken);
        if (tokens.isEmpty()) {
            return new NormalizePair(keywords.get(currentToken).getEnd(), currentToken);
        }
        List realTokens = TokenUtils.trimLeft((List)TokenUtils.trimRight((List)tokens));
        if (realTokens.size() > 0) {
            sb.append("\t");
            ISQLToken zz = (ISQLToken)realTokens.get(0);
            int i = 0;
            while (i < tokens.size()) {
                ISQLToken z = keywords.get(currentToken + i + 1);
                if (z == zz) {
                    return new NormalizePair(z.getStart() - 1, currentToken + i);
                }
                ++i;
            }
        }
        ISQLToken t = (ISQLToken)tokens.get(tokens.size() - 1);
        return new NormalizePair(t.getEnd(), currentToken + tokens.size());
    }

    private void normalizeStart(String text, StringBuilder sb, List<ISQLToken> keywords, int currentToken, int charIndexCopiedSoFar, int tabSize) {
        if (currentToken == 0) {
            return;
        }
        ISQLToken keyword = keywords.get(currentToken);
        int i = currentToken - 1;
        ISQLToken t = keywords.get(i);
        if (t.getEnd() <= charIndexCopiedSoFar) {
            return;
        }
        if (t.getTokenType() != TokenType.NEWLINE && t.getTokenType() != TokenType.TAB) {
            sb.append(text.substring(charIndexCopiedSoFar + 1, t.getEnd() + 1));
            return;
        }
        --i;
        while (i >= 0) {
            ISQLToken t2 = keywords.get(i);
            if (t2.getEnd() <= charIndexCopiedSoFar || t2.getTokenType() == TokenType.NEWLINE || t2.in(new TokenType[]{TokenType.MULTICOMMENT, TokenType.BRACES_IDENTIFIER, TokenType.DOUBLE_QUOTE_IDENTIFIER, TokenType.STRING}) && TokenUtils.tokenContainsNewLine((ISQLToken)t2, (String)text)) break;
            --i;
        }
        int countWS = 0;
        int countChars = 0;
        ISQLToken ke = null;
        int j = keywords.get(i + 1).getStart();
        while (j < keyword.getStart()) {
            ke = keywords.get(j);
            TokenType te = ke.getTokenType();
            switch (te) {
                case WHITESPACE: {
                    countChars += 1 + ke.getEnd() - ke.getStart();
                    countWS += 1 + ke.getEnd() - ke.getStart();
                    break;
                }
                case TAB: {
                    countChars += countChars % tabSize + (countChars % tabSize == 0 ? tabSize : 0);
                    countWS = 0;
                    break;
                }
                default: {
                    countWS = 0;
                    countChars += 1 + ke.getEnd() - ke.getStart();
                }
            }
            ++j;
        }
        if (countWS == 0) {
            sb.append(text.substring(charIndexCopiedSoFar + 1, ke.getEnd() + 1)).append("\t");
            return;
        }
        int cntReal = countChars - countWS;
        sb.append(text.substring(charIndexCopiedSoFar + 1, charIndexCopiedSoFar + 1 + cntReal));
        while (cntReal < countChars) {
            sb.append("\t");
            cntReal += cntReal % tabSize + (cntReal % tabSize == 0 ? tabSize : 0);
        }
    }

    public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
        if (!textArea.isEditable() || !textArea.isEnabled()) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
            return;
        }
        String selection = textArea.getSelectedText();
        if (selection == null || selection.length() == 0) {
            textArea.beginAtomicEdit();
            textArea.setText(this.transform(textArea.getText(), textArea.getTabSize()));
            textArea.endAtomicEdit();
        } else {
            textArea.beginAtomicEdit();
            textArea.replaceSelection(this.transform(selection, textArea.getTabSize()));
            textArea.endAtomicEdit();
        }
    }

    public String getMacroID() {
        return this.getName();
    }

    public List<Token> getKeywordsForFixing(List<Token> all) {
        return all.parallelStream().sorted((x, y) -> x.getStart() - y.getStart()).collect(Collectors.toList());
    }

    static class NormalizePair {
        int charsCopiedNew;
        int newToken;

        NormalizePair(int charsCopiedNew, int newToken) {
            this.charsCopiedNew = charsCopiedNew;
            this.newToken = newToken;
        }
    }
}

